/**  
 * @fileOverview 日程表主函数
 * @author tan
 * @version 1.0  
 */

/**
 * @author tan
 * @constructor calendar
 * @description 日程表主函数
 * @since version 1.0
 */

$package('itsm.portal');

itsm.portal.calendar = function() {
	return {
		// 日程表
		loadCalendar : function() {
			$('#loadingTask').hide();
			$('#external-events div.external-event').each(function() {
				var eventObject = {
					title : $.trim($(this).text())
				};
				$(this).data('eventObject', eventObject);
				$(this).draggable({
					zIndex : 999,
					revert : true,
					revertDuration : 0
				});
				setTimeout(itsm.portal.calendar.myInit, 10);
			});
			$('#calendar')
					.fullCalendar(
							{
								theme : true,
								header : { // 设置头的标题
									left : 'prev,next today,month,agendaWeek,agendaDay ',
									center : 'title,view name',
									right : 'prevYear,nextYear'

								},
								editable : false,
								weekMode : 'variable', // 下一个属性要用
								slotMinutes : 30, // 每个10分在周的视图
								titleFormat : 'yyyy-MM-dd', // title展示日期的格式
								timeFormat : 'TT HH:mm',
								droppable : true,
								buttonText : {
									prev : 'Yesterday',
									next : 'Tomorrow',
									prevYear : 'Last Year',
									nextYear : 'Next Year',
									today : 'Today',
									month : 'Month',
									week : 'Week',
									day : 'Day',
									refresh : 'fdsfsfs'
								},

								dayClick : function(date, allDay, jsEvent, view) {
									var copiedEventObject = new Object();
									copiedEventObject.start = date;
									copiedEventObject.allDay = allDay;
									var myTitle = null;
									if (myTitle == null) {
										return false
									}
									copiedEventObject.title = myTitle;
									$('#calendar').fullCalendar('renderEvent',
											copiedEventObject, true); // 核心的插入代码
								},
								eventDragStart : function(calEvent, jsEvent,
										ui, view) {
									alert('事件拖动开始');
								},
								eventDragStop : function(calEvent, jsEvent, ui,
										view) {
									alert('事件拖动停止');
								},
								eventDrop : function(calEvent, jsEvent, ui,
										view) {
									alert('事件拖动');
								},
								eventResize : function(calEvent, dayDelta,
										minuteDelta, revertFunc, jsEvent, ui,
										view) {
									alert('');
								},

								// 点击任务
								eventClick : function(calEvent, jsEvent, view) {
									itsm.portal.calendar
											.showCalendarTask(calEvent);
								},
								drop : function(date, allDay) {

								}
							});
		},
		updateEvent : function() {
			var renderEventObject = new Object();
			renderEventObject.id = $('#calendarTask_taskId').val();
			renderEventObject.title = $('#calendarTaskTitle').val();
			renderEventObject.start = $('#calendarTaskStartTime').val();
			renderEventObject.end = $('#calendarTaskEndTime').val();
			renderEventObject.allDay = $('#calendarTaskAllDay').val();
			renderEventObject.introduction = $('#calendarTaskIntroduction')
					.val();
			renderEventObject.location = $('#calendarTaskLocation').val();
			renderEventObject.status = $(
					"input[name='taskDto.taskStatus']:checked").val();
			$('#calendar').fullCalendar('updateEvent', renderEventObject, true);
		},

		myInit : function() {
			$.post('tasks!findAllTask.action?taskQueryDto.owner='
					+ login_userName, function(data) {
				for ( var i = 0; i < data.length; i++) {
					var copiedEventObject = new Object();
					copiedEventObject.start = data[i].startTime; // 开始时间
					copiedEventObject.title = data[i].title; // 标题
					copiedEventObject.id = data[i].taskId;
					copiedEventObject.end = data[i].endTime;
					copiedEventObject.allDay = data[i].allDay;
					copiedEventObject.introduction = data[i].introduction;
					copiedEventObject.location = data[i].location;
					copiedEventObject.status = data[i].taskStatus;
					$('#calendar').fullCalendar('renderEvent',
							copiedEventObject, true); // 核心的插入代码
				}
			});
		},
		showCalendarTask : function(eventObject) {
			// $('#calendarTask_taskId').text(eventObject.id);
			$('#calendarTaskTitle').text(eventObject.title);
			$('#calendarTaskLocation').text(eventObject.location);
			$('#calendarTaskIntroduction').text(eventObject.introduction);
			$('#calendarTaskStartTime').text(
					$.fullCalendar.formatDate(eventObject.start,
							'yyyy-MM-dd HH:mm:ss'));
			$('#calendarTaskEndTime').text(
					$.fullCalendar.formatDate(eventObject.end,
							'yyyy-MM-dd HH:mm:ss'));

			if (eventObject.status == '0') {
				$('#calendarTaskStatus').text(i18n['title_newCreate'])
			}
			if (eventObject.status == '1') {
				$('#calendarTaskStatus').text(i18n['task_label_pending']);
			}
			if (eventObject.status == '2') {
				$('#calendarTaskStatus').text(i18n['lable_complete']);
			}
			if (eventObject.allDay == 'true' || eventObject.allDay) {
				$('#calendarTaskAllDay').text(
						i18n['label_basicConfig_deafultCurrencyYes']);
			} else {
				$('#calendarTaskAllDay').text(
						i18n['label_basicConfig_deafultCurrencyNo']);
			}
			$('#calendarTaskDiv').window('open');
		},
		saveCalendarTask : function(operation) {
			if ($('#calendarTaskForm').form('validate')) {
				var _param = $('#calendarTaskDiv form').serialize();
				var _url = 'tasks!' + operation + '.action';
				$.post(_url, _param, function() {
					msgShow(i18n['saveSuccess'], 'show');
					$('#calendarTaskDiv').window('close');
					$('#calendar').fullCalendar('updateEvent',
							copiedEventObject, true);
					itsm.portal.calendar.updateEvent();
				});
			}

		}

	}
}();
