/**  
 * @author Van  
 * @constructor Van
 * @description 添加问题
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');
$import('itsm.config.categoryManage.eventCategoryTree');
$import('itsm.config.dataDictionary.dataDictionaryUtil');
$import('itsm.cm.configureItemUtil');



itsm.problem.addProblem = function () {


    return {

    	/**
    	 * 添加问题.
    	 */
    	saveProblem:function(){
    		
    		if($('#problem_basicInfo_form').form('validate')){
				var frm = $('#problem_basicInfo_form,#problem_detail_form,#add_problem_relatedCI,#add_problem_assign_form,#add_problem_relatedService').serialize();
				var url = 'problem!saveProblem.action';
				//调用
				startProcess();
				$.post(url,frm, function(res){
					
						closeTab(i18n['problem_add']);//关闭添加Tab
						//重新统计
						itsm.problem.problemStats.countAllProblem();
						endProcess();//销毁
						$('#problemGrid').trigger('reloadGrid');	
						refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+res);
						msgShow(i18n['addSuccess'],'show');
		
						
				});
    		}
    		
    	},
    	
    	/**
    	 * 服务目录.
    	 */
    	showServiceDirectory:function(){
    		
    		$('#add_problem_serviceDirectory tbody').html('');
			$.post('sd!findAllServiceDirectory.action',function(data){
				if(data!=null){
					if(data.length>0){
						for(var i=0;i<data.length;i++){
							$('<tr><td><input type="checkbox" name="problemDTO.serviceDirectoryNos" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#add_problem_serviceDirectory tbody');
						}
					}
				}
			});
			
    		
    	},
    	
    	
    	/**
    	 * 查找请求并填充.
    	 */
    	initRelatedRequest:function(){
    		
			if(enos!="" && enos!=null){
				if(enos.indexOf(",")==-1){			
					
					
					//查找请求信息
					$.post('request!showRequestInfo.action','eno='+enos,function(data){
						if(data!=null){
							$('#add_problem_etitle').val(data.etitle);
							$('#add_problem_edesc').val(data.edesc);
							
							$('<input type="hidden" name="problemDTO.enos" value="'+enos+'">').appendTo("#cnosPut");
							
						}
					});
					
				}else{				
					var arr=enos.split(',');
					for(var ii=0;ii<arr.length;ii++){	
						$('<input type="hidden" name="problemDTO.enos" value="'+arr[ii]+'">').appendTo("#cnosPut");
					}
				}
			}
    		
    	},
   
        /**
         * 载入数据.
         */
        init: function () {

        	$("#addProblem_loading").hide();
        	$("#addProblem_content").show();
        	
        	
        	$('#save_problem_btn').click(itsm.problem.addProblem.saveProblem);
        	
        	
        	$('#add_problem_categoryName').click(function(){//选择分类
        		itsm.config.categoryManage.eventCategoryTree.problemCategory('#add_problem_categoryName','#add_problem_categoryNo');
        	});
        	
        	$('#add_problem_relatedCI_add').click(function(){//关联配置项
        		itsm.cm.configureItemUtil.problemSelectCI('#add_problem_relatedCI');
        	});
        	
        	
        	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('problemStatus','#add_problem_status');
        	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#add_problem_priority');
        	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#add_problem_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#add_problem_seriousness');
			
			
			$('#add_problem_backList').click(itsm.problem.problemMain.showProblemIndex);
	
	
			setTimeout(function(){
				getUploader('#add_problem_attachments_file','#add_problem_attachments_str','#add_problem_attachments_successList','');
				
				itsm.problem.addProblem.showServiceDirectory();//加载服务目录
				
				itsm.problem.addProblem.initRelatedRequest();
			},0)
        	
        }

    };


}();

//载入
$(document).ready(itsm.problem.addProblem.init);