/**  
 * @author Mars  
 * @constructor Mars
 * @description 编辑问题
 * @date 2011-05-27
 * @since version 1.0 
 */
$package('itsm.problem');
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.config.categoryManage.eventCategoryTree");
$import('itsm.tools.attachIcon');
$import('itsm.cm.configureItemUtil');




itsm.problem.problemEdit = function () {

	this.rowHTML='<tr id="ref_ci_CIID">'+
	'<td align="center">CINO</td>'+
	'<td align="center"><input type="hidden" name="cinos" value="CIID" />'+
	'<a href=javascript:itsm.common.utility.tabUtility.reOpenTab("ci!findByciId.action?ciEditId=CIID","CIDETAIL_TITLE")>CINAME</a>'+
	'</td>'+
	'<td align="center">CATEGORYNAME</td>'+
	'<td align="center">CISTATUS</td>'+
	'<td align="center"><a onclick=itsm.cm.configureItemUtil.removeRow("#ref_ci_CIID")>DELETE</a></td>'+
	'</tr>';
	return{
		problemSetInput:function(value,inputId){
			if(value!=null)
				$(inputId).val(value);
			else
				$(inputId).val('');
		},
		/**
		 * @description 加载问题编辑数据
		 */
		loadProblemEdit:function(){
			$.post('problem!problemEdit.action','eno='+eno,function(data){
				if(data!=null){
					$('#edit_problemEno').val(data.eno);
					$('#edit_problemNo').val(data.problemNo);
					$('#problem_edit_etitle').val(data.etitle);
					itsm.problem.problemEdit.problemSetInput(data.edesc,'#problem_edit_edesc');
					itsm.problem.problemEdit.problemSetInput(data.assignNo,'#problem_edit_technicianNo');
					itsm.problem.problemEdit.problemSetInput(data.assignName,'#problem_edit_technicianName');
					itsm.problem.problemEdit.problemSetInput(data.categoryNo,'#problem_edit_categoryNo');
					itsm.problem.problemEdit.problemSetInput(data.categoryName,'#problem_edit_categoryName');
					itsm.problem.problemEdit.problemSetInput(timeFormatter(data.overdueTime),'#problem_edit_overdueTime');
					itsm.problem.problemEdit.problemSetInput(data.assigneeGroupNo,'#problem_edit_orgNo');
					itsm.problem.problemEdit.problemSetInput(data.assigneeGroupName,'#problem_edit_orgName');
					itsm.problem.problemEdit.problemSetInput(data.statusNo,'#problem_edit_status');
					itsm.problem.problemEdit.problemSetInput(data.priorityNo,'#problem_edit_priority');
					itsm.problem.problemEdit.problemSetInput(data.effectRangeNo,'#problem_edit_effectRange');
					itsm.problem.problemEdit.problemSetInput(data.seriousnessNo,'#problem_edit_seriousness');
					
					if(data.cigDTO!=null){
						htmlId='"edit_problem_relatedCIShow"';
						var cigDTO=data.cigDTO
						for(var i=0;i<cigDTO.length;i++){
							var status='';
							if(cigDTO[i].status!=null)
								status=cigDTO[i].status
								
								
							var newRowHTML=rowHTML.replace(/CIID/g,cigDTO[i].ciId)
							.replace(/CINO/g,cigDTO[i].cino)
							.replace(/CIDETAIL_TITLE/g,i18n['ci_configureItemInfo'])
							.replace(/CINAME/g,cigDTO[i].ciname)
							.replace(/CATEGORYNAME/g,cigDTO[i].category)
							.replace(/CISTATUS/g,status)
							.replace(/DELETE/g,i18n['deletes']); 	
							
							$(newRowHTML).appendTo('#edit_problem_relatedCIShow table');
						}
					};
					if(data.attachments!=null){
						var attachments=data.attachments;
						for(var i=0;i<attachments.length;i++){
							var attrs=attachments[i];
							$('<div style="padding:3px" id="attr_'+attrs.aid+
									'">'+itsm.tools.attachIcon.getIcon(attrs.attachmentName)+'<a href="attachment!download.action?downloadAttachmentId='+attrs.aid+
									'" target="_bank">'+attrs.attachmentName+
									'</a> <a onclick=itsm.problem.problemEdit.removeAttr("#attr_'+attrs.aid+'","'+attrs.aid+'")>删除</a></div>').appendTo('#show_problem_attachment');
						}
					}
					itsm.problem.problemEdit.problemEditEffectServiceWin(data.sdgDTO);
					
				}
			})
		},

		
		/**
    	 * 移除附件
    	 */
    	removeAttr:function(divId,aid){

    		$(divId).remove();//移除行
    		
			var url = 'problem!deleteAttachment.action?eno='+eno+'&aid='+aid+'&flag=problem';
			//调用
			startProcess();
			$.post(url, function(res){				
					endProcess();//销毁
					msgShow(i18n['common_attachment_del_success'],'show');
			});
    	},
		
		
		/**
		 * @description 服务目录
		 */
		problemEditEffectServiceWin:function(data1){
			$('#problemEditEffectServiceShow table').html('');
			$.post('sd!findAllServiceDirectory.action',function(data){
				if(data!=null && data.length>0){
					for(var i=0;i<data.length;i++){
						if(data1!=null && data1.length>0){
							var result=false;
							for(var j=0;j<data1.length;j++){
								if(data1[j].serviceDirectoryId==data[i].serviceDirectoryId){
									result=true;
								}
							}
							if(result){
								$('<tr><td><input type="checkbox" name="problemDTO.serviceDirectoryNos" value='+data[i].serviceDirectoryId+' checked /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#problemEditEffectServiceShow tbody');
							}else{
								$('<tr><td><input type="checkbox" name="problemDTO.serviceDirectoryNos" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#problemEditEffectServiceShow tbody');
							}
						}else{
							$('<tr><td><input type="checkbox" name="problemDTO.serviceDirectoryNos" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#problemEditEffectServiceShow tbody');
						}
					}
				}
			})
		},
		/**
		 * @description 选择问题分类.
		 */
		selectEditProblemCategory:function(){
			itsm.config.categoryManage.eventCategoryTree.problemCategory('#problem_edit_categoryName','#problem_edit_categoryNo');
		},

		/**
		 * @description 问题编辑
		 */
		problemEditOpt:function(){
			if($('#problem_basicInfo_form').form('validate')){
				var frm = $('#problem_basicInfo_form,#problem_detail_form,#edit_problem_relatedCIShow,#edit_problem_assign_form,#edit_problem_relatedService').serialize();
				var url='problem!editProblemBaseInfo.action';
				
				//调用
				startProcess();
				$.post(url,frm, function(){
					closeTab(i18n['problem_edit']);//关闭添加Tab
					//重新统计
					itsm.problem.problemStats.countAllProblem();
					endProcess();//销毁
					$('#problemGrid').trigger('reloadGrid');	
					refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+eno);
					msgShow(i18n['editSuccess'],'show');
				});
			}
			
		},
		
		/**
		 * @description 返回问题列表
		 */
		returnProblemList:function(){
			itsm.common.utility.tabUtility.addTab(i18n['problem_grid'],'../pages/problem/problemMain.jsp');
		},
		
		/**
		 * 载入.
		 */
		init:function(){
			$("#editProblem_loading").hide();
	    	$("#editProblem_content").show();
			
		    	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('problemStatus','#problem_edit_status');
	    	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#problem_edit_priority');
	    	itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#problem_edit_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#problem_edit_seriousness');
				
			
			$('#problemEdit_edit_but').click(itsm.problem.problemEdit.problemEditOpt);
			
			//绑定
			$('#editProblem_edit_ref_ci_btn').click(function(){
				
				itsm.cm.configureItemUtil.selectCISM('#edit_problem_relatedCIShow');
				
			});
			
			
			
			
			setTimeout(function(){
				getUploader('#edit_problem_attachments_file','#edit_problem_attachments_str','#edit_problem_attachments_successList','');
				itsm.problem.problemEdit.loadProblemEdit();	
			},0)	
			
		}	
	}
}();

//载入
$(document).ready(itsm.problem.problemEdit.init);