/**  
 * @author Van  
 * @constructor Van
 * @description 添加问题
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');

$import('itsm.problem.relatedRequestGrid');
$import('itsm.problem.problemFlowAction');
$import('itsm.problem.problemTask');
$import('itsm.problem.problemTimeCost');
$import('itsm.problem.timeCost_relatedTask');
$import('itsm.tools.attachIcon');



itsm.problem.problemDetails = function () {

	
	this.problemDetailsGrids=[];	
	this.problemDetails_relatedRequestFlag="0";
	this.problemDetails_taskLoadFlag="0";
	this.problemDetails_problemProcessFlag="0";
	this.problemDetails_timeCostFlag="0";
	this.problemDetails_historyRecord="0";
	this.problemDetails_relatedChange="0";
	this.problemDetails_solutions="0";
	
    return {

    	
    	/**
    	 * 主面板点击
    	 */
    	mainTabClick:function(){
    		
    		 $('#problemDetailsMainTab').tabs({
 	            onSelect:function(title){
 	            	
 	            	if(title==title_relatedRequest && problemDetails_relatedRequestFlag=="0"){//加载关联的请求
 	            		itsm.problem.relatedRequestGrid.showRelatedRequestGrid(eno);
 	            		problemDetails_relatedRequestFlag="1";
 	            	}
 	            	
 	            	if(title==title_task && problemDetails_taskLoadFlag=="0"){//加载问题任务列表
 	            		itsm.problem.problemTask.showProblemTaskGrid('#problemTaskGrid',eno,'itsm.problem');
 	            		problemDetails_taskLoadFlag="1"; 	            		
 	            	}
 	            	
 	            	if(title==title_problemProcess && problemDetails_problemProcessFlag=="0"){//处理问题面板点击
 	            		
	 	            	$('#problem_detail_save_symptom_btn').click(function(){//保存症状
	 	               		itsm.problem.problemDetails.saveComment('#problem_detail_symptom_form','symptom');
	 	               	});
	 	               	
	 	               	$('#problem_detail_save_effect_btn').click(function(){//保存影响
	 	               		itsm.problem.problemDetails.saveComment('#problem_detail_effect_form','effect');
	 	               	});
	 	               	
	 	               	$('#problem_detail_save_rootCauses_btn').click(function(){//根本原因
	 	               		itsm.problem.problemDetails.saveComment('#problem_detail_rootCauses_form','rootCauses');
	 	               	});
	 	               	
	 	               	$('#problem_detail_save_alternatives_btn').click(function(){//变通方法
	 	               		itsm.problem.problemDetails.saveAlternativeSoultions('#problem_detail_alternatives_form');
	 	               	});
	 	               	
	
	 	               	

	 	               	//症状附件
	 					getUploader('#problem_detail_symptom_attachments_file','#problem_detail_symptom_attachments_str','#problem_detail_symptom_attachments_uploaded','');
	 					//影响附件
	 					getUploader('#problem_detail_effect_attachments_file','#problem_detail_effect_attachments_str','#problem_detail_effect_attachments_uploaded','');
	 					//根本原因
	 					getUploader('#problem_detail_rootCauses_attachments_file','#problem_detail_rootCauses_attachments_str','#problem_detail_rootCauses_attachments_uploaded','');
	 					
	 					
	 					
	 					problemDetails_problemProcessFlag="1";
 	            	}
 	            	
 	            	
 	            	if(title==title_solutions && problemDetails_solutions=="0"){ 	            		
 	            		//解决方案
	 	               	$('#problem_detail_save_solutions_btn').click(itsm.problem.problemDetails.saveSoultions);
	 					getUploader('#problem_detail_solutions_attachments_file','#problem_detail_solutions_attachments_str','#problem_detail_solutions_attachments_uploaded','');
	 					
	 					problemDetails_solutions="1";
 	            	}
  	
 	            	if(title==title_timeCost && problemDetails_timeCostFlag=="0"){//加载进展及成本
 	            		itsm.problem.problemTimeCost.showTimeCostGrid('#problemTimeCostGrid',eno,'itsm.problem');
 	            		problemDetails_timeCostFlag="1";
 	            		          		
 	            		$('#index_timeCost_costTaskTitle').click(function(){
 	            			itsm.problem.timeCost_relatedTask.openTaskWindow(eno,'itsm.problem','#index_timeCost_costTaskTitle','#index_timeCost_costTaskId');
 	            		});
 	            	}
 	            	
 	            	if(title==title_historyRecord && problemDetails_historyRecord=="0"){//加载历史记录       		
 	 					itsm.problem.problemFlowAction.problemHistoryRecord();
 	 					problemDetails_historyRecord="1";
 	            	}
 	            	
 	            	if(title==title_relatedChange && problemDetails_relatedChange=="0"){
 	            		
 	            		itsm.problem.problemDetails.getRelatedChange();
 	            		
 	            		problemDetails_relatedChange="1";
 	            	}
 	            	
 	            }
 	        });
    		 
    		 
    	},
    	
    	/**
    	 * 保存症状、影响、根本原因.
    	 */
    	saveComment:function(form,flag){
    		
    		var frm = $(form).serialize();
			var url = 'problem!saveComment.action?flag='+flag;
			//调用
			startProcess();
			$.post(url,frm, function(res){				
					endProcess();//销毁
					msgShow(i18n['common_operation_success'],'show');
					itsm.problem.problemFlowAction.problemHistoryRecord();//更新历史记录
			});
    	},
    	
    	
    	
    	
    	/**
    	 * 保存解决方案
    	 */
    	saveSoultions:function(){
    		
    		var _frm = $('#problem_detail_solutions_form').serialize();
			var _url = 'problem!saveSolution.action';
			
			//调用
			startProcess();
			$.post(_url,_frm, function(res){				
					endProcess();//销毁
					msgShow(i18n['common_operation_success'],'show');
					itsm.problem.problemFlowAction.problemHistoryRecord();//更新历史记录
			});
			
    	},
    	
    	
    	
    	
    	
    	/**
    	 * 移除附件
    	 */
    	removeAttr:function(divId,aid,flag){

    		$(divId).remove();//移除行
    		
			var url = 'problem!deleteAttachment.action?eno='+eno+'&aid='+aid+'&flag='+flag;
			//调用
			startProcess();
			$.post(url, function(res){				
					endProcess();//销毁
					msgShow(i18n['common_attachment_del_success'],'show');
			});

    	},
   
    	
    	/**
    	 * 保存变通方法、决绝方案.
    	 */
    	saveAlternativeSoultions:function(fromId){
    		
    		var frm = $(fromId).serialize();
			var url = 'problem!saveAlternativeSoultions.action';
			//调用
			startProcess();
			$.post(url,frm, function(res){				
					endProcess();//销毁
					msgShow(i18n['common_operation_success'],'show');
					itsm.problem.problemFlowAction.problemHistoryRecord();//更新历史记录
			});
    	},
    	
    	/**
    	 * 获得关联变更.
    	 */
    	getRelatedChange:function(){
    		
    		if(eno!=null && eno!="undefined"){
    			
    			var url = 'change!findByProblemNo.action?eno='+eno;
        		$.post(url,function(res){				
    					
        			if(res!=null && res!='null'){
        				
        				$('#showAddRelatedChange').hide();
        				$('#showRelatedChange').show();
         				$('#showRelatedChange').html("<a style='font-size:16px' onclick=itsm.problem.problemDetails.viewChangeInfo('"+res.eno+"')>"+res.etitle+"</a>");

        			}else{
        				$('#showRelatedChange').hide();
        				$('#showAddRelatedChange').show();
        				
        			}
        			
        		});
    			
    		}
    		
    	},
    	
    	
    	viewChangeInfo:function(id){
    		
    		itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+id,i18n['title_changeInfo']);
    	},
    	
    	
    	/**
		 * 展开或收缩面板.
		 */
		panelCollapseExpand:function(){
			
			 $(problemDetailsGrids).each(function(i, g) {
			      setGridWidth(g, 'problemDetailsMainTab', 10);
			 });
		},
		
		/**
		 * 数据列表自动伸展.
		 */
		fitProblemGrids:function(){
			
			$('#problemDeatil_west').panel({
				onCollapse:itsm.problem.problemDetails.panelCollapseExpand,
				onExpand:itsm.problem.problemDetails.panelCollapseExpand
			});
		},
    	

        /**
         * 载入数据.
         */
        init: function () {

        	$("#problemDetails_loading").hide();
        	$("#problemDetails_content").show();
        	
        	itsm.problem.problemDetails.mainTabClick();
        	setTimeout(itsm.problem.problemDetails.fitProblemGrids,0);

        	
        	$('#fullsearch_problem_related_event_btn').click(function(){
				
				itsm.compass.fullSearch.openFullsearchWindow(queryString,'problem');		
			});
        	
        	$('#problem_details_flowPic_btn').click(itsm.problem.problemFlowAction.showFlowPic);//显示流程图
        	itsm.problem.problemFlowAction.init();//绑定相关操作
        	
        	$('#submitCurrentProblemToChange').click(function(){//将当前问题提交到变更
        		itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeAdd.jsp?pnos='+eno,i18n['titie_change_add']);
        	});
        	
        	$('#problems_details_editProblem_btn').click(function(){//编辑当前问题.
        		refreshTab(i18n['problem_edit'],'../pages/problem/editProblem.jsp?eno='+eno);     		
        	});

        }
    };


}();

//载入
$(document).ready(itsm.problem.problemDetails.init);