/**  
 * @author Van  
 * @constructor Van
 * @description 流程动作
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');
$import("itsm.security.userUtil");
$import("itsm.security.organizationTreeUtil");

itsm.problem.problemFlowAction = function () {

	this.problemActionForm="";
	
    return {

    	/**
    	 * 显示流程图
    	 */
    	showFlowPic:function(){
    		
    		refreshTab(i18n['problem_workFlow'],'upload!traceInstance.action?instanceId='+pid);
    	},

    	/**
    	 * 打开处理问题窗口.
    	 */
    	saveProblemAction_openWindow:function(flag){
    		problemActionForm="#problemDetails_action_resolveProblem_window form";
    		$('#padto_actionFlag').val(flag);
    		$('#problemDetails_action_resolveProblem_window').window('open');		
    	},

    	/**
    	 * 打开审批窗口.
    	 */
    	problemReview_openWindow:function(){
    		problemActionForm="#problemDetails_action_reviewProblem_window form";
    		$('#problemDetails_action_reviewProblem_window').window('open');		
    	},

    	/**
    	 * 提交问题处理.
    	 */
    	saveProblemAction:function(){
    		
    		var frm = $(problemActionForm).serialize();
			var url = 'problem!actionFlow.action';
			
			//调用
			startProcess();
			$.post(url,frm, function(res){	
				
					$('.easyui-window').window('close');
					refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+eno);
					endProcess();//销毁
					msgShow(i18n['common_operation_success'],'show');
			});
    	},

    	/**
    	 * 问题历史记录
    	 */
    	problemHistoryRecord:function(){
    		var problemRecord=new historyRecord('problemHistoryRecord',eno,'itsm.problem');
    		problemRecord.showHistoryRecord();
    	},

    	/**
    	 * 问题指派.
    	 */
    	problemAssign:function(){
    		
    		var frm = $('#problemDetails_action_problemAssign_window form').serialize();
			var url = 'problem!problemAssign.action';
			
			//调用
			startProcess();
			$.post(url,frm, function(res){	
					$('.easyui-window').window('close');
					refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+eno);
					endProcess();//销毁
					msgShow(i18n['common_operation_success'],'show');
					
					
			});
    	},

        /**
         * 载入数据.
         */
        init: function () {

        	$('#problem_details_flowPic_btn').click(itsm.problem.problemFlowAction.showFlowPic);
        	
        	//问题指派
        	$('#problems_details_problemAssign_btn').click(function(){
        		
        		$('#problemDetails_action_resolveProblem_window').window({title:title_problemAssign});	
        		
        		$('#problemDetails_action_problemAssign_window').window('open');
        	});

        	$('#problemDetails_action_problemAssign_groupName').click(function(){//指派组	
        		itsm.security.organizationTreeUtil.showAll_2('#index_assignGroup_window','#index_assignGroup_tree','#problemDetails_action_problemAssign_groupName','#problemDetails_action_problemAssign_groupNo');
        	});
        	
        	$('#problemDetails_action_problemAssign_tcName').click(function(){//选择技术员        		
        		itsm.security.userUtil.selectUser('#problemDetails_action_problemAssign_tcName','#problemDetails_action_problemAssign_tcNo','','loginName');
        	});

        	$('#problemDetails_action_problemAssign_confirmBtn').click(itsm.problem.problemFlowAction.problemAssign);//确定指派

        	
        	//流程-解决问题
        	$('#problems_details_resolveProblem_btn').click(function(){
        		
        		$('#problemDetails_action_resolveProblem_window').window({title:i18n['problem_resolve']});
        		itsm.problem.problemFlowAction.saveProblemAction_openWindow('resolveProblem');
        	});

        	//流程-提交评审
        	$('#problems_details_submitProblem_btn').click(function(){
        		$('#problemDetails_action_resolveProblem_window').window({title:i18n['problem_submitApproval']});	
        		itsm.problem.problemFlowAction.saveProblemAction_openWindow('submitReview');
        	});
        	
        	//流程-关闭问题
        	$('#problems_details_closeProblem_btn').click(function(){
        		$('#problemDetails_action_resolveProblem_window').window({title:i18n['problem_close']});	
        		itsm.problem.problemFlowAction.saveProblemAction_openWindow('closeProblem');
        	});
        	//流程-评审问题
        	$('#problems_details_reviewProblem_btn').click(itsm.problem.problemFlowAction.problemReview_openWindow);
        	
        	//处理问题
        	$('#problemDetails_action_resolveProblem_confirmBtn,#problemDetails_action_reviewProblem_confirmBtn').click(itsm.problem.problemFlowAction.saveProblemAction);

        }

    };
}();
