/**  
 * @author Van  
 * @constructor knowledge
 * @description "knowledge"
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');
$import('itsm.config.categoryManage.eventCategoryTree');
$import("itsm.config.dataDictionary.dataDictionaryUtil");


itsm.problem.problemMain = function () {


    return {

    	

    	actionFormat:function(){
    		return $('#problemGridFormatterDiv').html();
    	},
    	
    	
    	 /**
         * @description 问题列表
         */
        showProblemGrid: function () {
			
		    var _url='problem!findProblemPager.action';
			var _postData={};
			
			if(problem_fullSearchFlag=="yes"){//全文检索
				
				_url="problem!fullSearch.action";		
				var fullSearchQueryString=$('#fullSearchKeyWord').val();	  					
				$.extend(_postData, {'compassQueryDTO.alias':'Problems','compassQueryDTO.queryString':fullSearchQueryString});		
			}
			
						
            var params = $.extend({},jqGridParams, {
                url: _url,
                caption:i18n['problem_grid'],
                postData:_postData,
                colNames:[i18n['problem_code'],i18n['title'],i18n['category'],i18n['title_request_assignTo'],i18n['priority'],i18n['problem_reporter'],i18n['problem_reportTime'],i18n['status'],i18n['common_action'],''],
                colModel:[ {name:'problemNo',width:10},
                           {name:'etitle',width:15},
                           {name:'categoryName',width:10,align:'center',sortable:false},
                           {name:'assignName',width:10,align:'center',sortable:false},
                           {name:'priorityName',width:10,align:'center',sortable:false},
                           {name:'createdByName',width:10,align:'center',sortable:false},
                           {name:'createdOn',width:10,align:'center',formatter:timeFormatter},
                           {name:'statusName',width:10,align:'center',sortable:false},
                           {name:'act',width:15,align:'center',sortable:false,formatter:itsm.problem.problemMain.actionFormat},
                           {name:'eno',hidden:true}
                           ],
                jsonReader: $.extend({},jqGridJsonReader, {
                    id: "eno"
                }),
                sortname: 'eno',
                ondblClickRow:function(rowId){
                	refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+rowId);
                },
                pager: '#problemGridPager'
            });
            $("#problemGrid").jqGrid(params);
            $("#problemGrid").navGrid('#problemGridPager', navGridParams);
            //列表操作项
            $("#t_problemGrid").css(jqGridTopStyles);
            $("#t_problemGrid").append($('#problemGridToolbar').html());
            
            problem_fullSearchFlag="no";
        },

    	
    	
    	
    	/**
    	 * 加载主面板
    	 */
    	showProblemIndex:function(){
    		
    		showLeftMenu('../pages/problem/leftMenu.jsp','leftMenu');		
			refreshTab(i18n['problem_grid'],'../pages/problem/problemMain.jsp');	
    	},
     
    	/**
    	 * 添加问题.
    	 */
    	showAddProblem:function(){
    		
    		openTab(i18n['problem_add'],'../pages/problem/addProblem.jsp');
    	},
    	
    	/**
		 * @description 问题详细
		 */
		problemDetails_aff:function(){
			checkBeforeEditGrid('#problemGrid',function(rowData){itsm.problem.problemMain.problemDetailsOpt(rowData.eno);});
		},
		problemDetailsOpt:function(eno){
			refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+eno);
		},
    	
    	/**
    	 * 编辑问题.
    	 */
    	edit_problems_aff:function(){
    		checkBeforeEditGrid('#problemGrid',function(rowData){itsm.problem.problemMain.editProblems(rowData.eno);});
    	},
    	
    	
    	editProblems:function(eno){
    		refreshTab(i18n['problem_edit'],'../pages/problem/editProblem.jsp?eno='+eno);
    	},
    	
    	/**
    	 * 删除问题.
    	 */
    	delete_problems_aff:function(){
    		checkBeforeDeleteGrid('#problemGrid',itsm.problem.problemMain.deleteProblems);
    	},
    	
    	
    	/**
    	 * 行内删除.
    	 */
    	deleteInline:function(rowId){
    		
    		
    		$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
    			if(r){
    				itsm.problem.problemMain.deleteProblems(rowId);
    			}
    		});
    		
    	},
    	
    	deleteProblems:function(rowIds){
    		
    		var _param = $.param({'ids':rowIds},true);
			
			startProcess();
			$.post("problem!deleteProblem.action", _param, function(){
				
				//重新统计
				itsm.problem.problemStats.countAllProblem();
				endProcess();
				$('#problemGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'info');
			}, "json");
    	},
    	
    	/**
    	 * 搜索问题.
    	 */
    	searchProblem:function(){
    		var _url = 'problem!findProblemPager.action';	
			var sdata = $('#search_problem_window form').getForm();
			var postData = $("#problemGrid").jqGrid("getGridParam", "postData");     
			$.extend(postData, sdata);
			$('#problemGrid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
    		
    	},
    	
    	
		/**
		 *  提交变更
		 */
		problem2change:function(){
			var rowIds = $("#problemGrid").getGridParam('selarrrow');
			if(rowIds==''){
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else{
				itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeAdd.jsp?pnos='+rowIds,i18n['titie_change_add']);
			}	
		},
    	
    	
       
        
        
        
        
        /**
         * 载入数据.
         */
        init: function () {

        	$("#problemMain_loading").hide();
        	$("#problemMain_content").show();
        	
        
        		
    		itsm.problem.problemMain.showProblemGrid();
        	
        	$('#problemGrid_add').click(itsm.problem.problemMain.showAddProblem);
        	$('#problemGrid_edit').click(itsm.problem.problemMain.edit_problems_aff);
        	$('#problemGrid_delete').click(itsm.problem.problemMain.delete_problems_aff);
        	$('#problemGrid_search').click(function(){
        		
        		itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('problemStatus','#search_problem_statusNo');
        		$('#search_problem_window').window('open');
        		
        		
        	});
        	$('#problem2change').click(itsm.problem.problemMain.problem2change);
        	$('#search_problem_do').click(itsm.problem.problemMain.searchProblem);
        	
        	$('#search_problem_categoryName').click(function(){//选择分类
        		itsm.config.categoryManage.eventCategoryTree.problemCategory('#search_problem_categoryName','#search_problem_categoryNo');
        	});

        }

    };


}();

//载入
$(document).ready(itsm.problem.problemMain.init);