$package("itsm.problem")
/**  
 * @fileOverview 问题统计主函数
 * @author Mars
 * @version 1.0  
 */  
 /**  
 * @author Mars 
 * @constructor 问题统计主函数
 * @description 问题统计主函数
 * @date 2011-06-01
 * @since version 1.0 
 */

itsm.problem.problemStats=function(){
	return {
		/**
		 * @description 问题统计
		 */
		
		countAllProblem:function(){
			var url = 'problem!countProblem.action';
			$.post(url,'queryDTO.userName='+userName,function(res){
				$("#allProblem").text("[ "+res.countAllProblem+" ]");
				$("#myProposedProblem").text("[ "+res.countMyProblem+" ]");
				$("#assigneeToMyProblem").text("[ "+res.countMyPeProblem+" ]");
				$("#assigneeGroupProblem").text("[ "+res.countMyGrProblem+" ]");
			});
		},
		/**
		 * @description 问题统计搜索
		 */
		problemCountSearch:function(type){
			
			if ($('#itsmMainTab').tabs('exists',i18n['problem_grid'])){
				
				$('#itsmMainTab').tabs('select',i18n['problem_grid'])
				var _url = 'problem!findProblemPager.action?queryDTO.countQueryType='+type+'&queryDTO.currentUser='+userName;	
				$('#problemGrid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
				
			}else{
		
				itsm.common.utility.tabUtility.reOpenTab('../pages/problem/problemMain.jsp?queryDTO.countQueryType='+type+'&queryDTO.currentUser='+userName+'&random='+Math.random()*10+1,i18n['problem_grid']);
			}
		}
	}
	
}();