/**  
 * @author Van  
 * @constructor Van
 * @description 问题关联的任务.
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');

itsm.problem.problemTask = function () {

	
	this.index_task_operation="";
	this.load_task_grid_flag="0";
	
	
    return {

    	
    	
    	taskStatusFormatter:function(cell,event,data){
    		if(data.taskStatus=='0')
    			return i18n['title_newCreate'];
    		if(data.taskStatus=='1')
    			return i18n['task_label_pending'];
    		if(data.taskStatus=='2')
    			return i18n['lable_complete'];
    	},
    	
    	/**
    	 * 显示列表
    	 */
    	showProblemTaskGrid:function(grid,eno,eventType){

    		var t_grid=grid.replace("#","#t_");
    		var gridPage=grid+"Pager";
    		var toolbar=grid+"Toolbar";

    		var params = $.extend({},jqGridParams, {	
    			url:'eventTask!findPagerChangeTask.action?queryDTO.eno='+eno+'&queryDTO.eventType='+eventType,
    			caption:i18n['caption_request_taskGrid'],
    			colNames:[i18n['title'],i18n['lable_task_location'],i18n['status'],i18n['title_startTime'],i18n['title_endTime'],i18n['common_owner'],i18n['operateItems'],'','',''],
    			colModel:[
    			    
    			    {name:'title',align:'center',width:20},
    		   		{name:'location',align:'center',width:20},
    		   		{name:'taskStatusPanel',align:'center',width:10,formatter:itsm.problem.problemTask.taskStatusFormatter},
    		   		{name:'startTime',align:'center',width:20,formatter:timeFormatter},
    		   		{name:'endTime',align:'center',width:20,formatter:timeFormatter},
    		   		{name:'owner',align:'center', width:10},
    		   		{name:'introduction',hidden:true},
    		   		{name:'taskStatus',hidden:true},
    		   		{name:'taskId',hidden:true},
    		   		{name:'allDay',hidden:true}
    		   		
    			],	
    			toolbar: [true,"top"],
    			jsonReader: $.extend(jqGridJsonReader,{id: "taskId"}),
    			sortname:'taskId',
    			pager:gridPage
    		});
    		$(grid).jqGrid(params);
    		$(grid).navGrid(gridPage,navGridParams);
    		//列表操作项
    		$(t_grid).css(jqGridTopStyles);
    		$(t_grid).append($(toolbar).html());
    		problemDetailsGrids.push(grid);
    	
    		
    		//添加
    		$(grid+"_add").click(function(){
    			itsm.problem.problemTask.addTask(eno,eventType);
    		});
    		
    		//编辑
    		$(grid+"_edit").click(function(){
    			itsm.problem.problemTask.editTask(grid,eno,eventType);
    		});
    		
    		//删除
    		$(grid+"_delete").click(function(){    			
    			itsm.problem.problemTask.deleteTask(grid);  			
    		});
    		
    		
    		
    		if(load_task_grid_flag=="0"){//加载一次
    			
	    		//添加或编辑
	    		$('#index_addEditTask_save').click(function(){
	    			itsm.problem.problemTask.saveTask(grid);
	    		});
	    		
	    		load_task_grid_flag="1";
    		}
    	},

    	
    	/**
    	 * 添加任务
    	 */
    	addTask:function(eno,eventType){
    		
    		index_task_operation='saveEventTask';
			$('#index_eventTaskDTO_taskId').val('');//赋值
			$('#index_eventTaskDTO_eno').val(eno);//赋值
			$('#index_eventTaskDTO_eventType').val(eventType);//赋值
			$('#index_addEditTask_window').window('open');//开窗
    		
    	},
    	
    	/**
    	 * 编辑任务.
    	 */
    	editTask:function(grid,eno,eventType){
    		
    		checkBeforeEditGrid(grid,function(rowData){
				
				index_task_operation='editEventTask';		

    			$('#index_eventTaskDTO_taskId').val(rowData.taskId);//赋值
    			$('#index_eventTaskDTO_taskTitle').val(rowData.title);//赋值
    			$('#index_eventTaskDTO_taskLocation').val(rowData.location);//赋值
    			$('#index_eventTaskDTO_introduction').val(rowData.introduction);//赋值
    			
    			if(rowData.taskStatus=='0'){
					$('#index_eventTaskDTO_statusNew').attr('checked',true);
				}
				if(rowData.taskStatus=='1'){
					$('#index_eventTaskDTO_statusProcessing').attr('checked',true);
				}
				if(rowData.taskStatus=='2'){
					$('#index_eventTaskDTO_statusDone').attr('checked',true);
				}

				if(rowData.allDay==true || rowData.allDay=='true'){
					$('#index_eventTaskDTO_allDay').attr('checked',true);
				}else{
					$('#index_eventTaskDTO_allDay').attr("checked",'');
					
				}
    			$('#index_eventTaskDTO_startTime').val(rowData.startTime);//赋值
    			$('#index_eventTaskDTO_endTime').val(rowData.endTime);//赋值
    			$('#index_eventTaskDTO_owner').val(rowData.owner);//赋值
    		
    			
    			$('#index_eventTaskDTO_eno').val(eno);//赋值
    			$('#index_eventTaskDTO_eventType').val(eventType);//赋值
    			$('#index_addEditTask_window').window('open');//开窗
				
			});
    	},
    	
    	/**
    	 * 删除任务.
    	 */
    	deleteTask:function(grid){
    		
    		checkBeforeDeleteGrid(grid,function(rowIds){
				
				var _param = $.param({'ids':rowIds},true);
				$.post("eventTask!deleteEventTask.action", _param, function(){
					$(grid).trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'show');
				}, "json");
				
			});
    		
    	},
    	/**
    	 * 保存任务.
    	 */
    	saveTask:function(grid){
    		
   			if($("#index_addEditTask_window form").form('validate')){
				var _param = $("#index_addEditTask_window form").serialize();
				var _url='eventTask!'+index_task_operation+'.action';
				$.post(_url,_param,function(){
					$('#index_addEditTask_window').window('close');//关窗
					$(grid).trigger('reloadGrid');
		 			msgShow(i18n['saveSuccess'],'show');
		 			resetForm('#index_addEditTask_window form');
				});
			}
    	}
    	
    	
		
    };


}();