/**  
 * @author Van  
 * @constructor Van
 * @description 问题关联的任务.
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');

itsm.problem.problemTimeCost = function () {

	
	this.index_timeCost_operation="";
	this.load_timeCost_grid_flag="0";
	
	
    return {

    	/**
    	 * 显示列表
    	 */
    	showTimeCostGrid:function(grid,eno,eventType){

    		var t_grid=grid.replace("#","#t_");
    		var gridPage=grid+"Pager";
    		var toolbar=grid+"Toolbar";

    		var params = $.extend({},jqGridParams, {	
    			url:'cost!findPagerCost.action?costDTO.eno='+eno+'&costDTO.eventType='+eventType,
    			caption:i18n['caption_request_activityGrid'],
    			colNames:[i18n['title_technician'],i18n['title_opertionTime'],i18n['title_spendTime'],i18n['title_totalCost'],i18n['description'],i18n['title_belongsStage'],'','','','','','','',''],
    			colModel:[
    		   		{name:'userName',align:'center',width:20},
    		   		{name:'opertionTime',align:'center',width:20,formatter:timeFormatter},
    		   		{name:'useTime',width:10,align:'center'},
    		   		{name:'totalFees',width:10,align:'center'},
    		   		{name:'description',width:30,align:'center'},
    		   		{name:'stage',width:10,align:'center'},
    		   		{name:'status',hidden:true},
    		   		{name:'taskId',hidden:true},
    		   		{name:'title',hidden:true},
    			    {name:'progressId',hidden:true},
    			    {name:'userId',hidden:true},
    			    {name:'perHourFees',hidden:true},
    		   		{name:'skillFees',hidden:true},
    		   		{name:'othersFees',hidden:true}
    		   		
    			],
    			jsonReader: $.extend(jqGridJsonReader,{id: "progressId"}),
    			sortname:'progressId',
    			pager:gridPage
    		});
    		
    		$(grid).jqGrid(params);
    		$(grid).navGrid(gridPage,navGridParams);
    		//列表操作项
    		$(t_grid).css(jqGridTopStyles);
    		$(t_grid).append($(toolbar).html());
    		problemDetailsGrids.push(grid);
    	
    		
    		//添加
    		$(grid+"_add").click(function(){
    			itsm.problem.problemTimeCost.addTimeCost(eno,eventType);
    		});
    		
    		//编辑
    		$(grid+"_edit").click(function(){
    			itsm.problem.problemTimeCost.editTimeCost(grid,eno,eventType);
    		});
    		
    		//删除
    		$(grid+"_delete").click(function(){    			
    			itsm.problem.problemTimeCost.deleteTimeCost(grid);  			
    		});
    		
    		
    		
    		if(load_timeCost_grid_flag=="0"){//加载一次
    			
	    		//添加或编辑
	    		$('#index_timeCost_save').click(function(){
	    			itsm.problem.problemTimeCost.saveTimeCost(grid);
	    		});
	    		
	    		load_timeCost_grid_flag="1";
    		}
    	},

    	
    	/**
    	 * 添加时间成本
    	 */
    	addTimeCost:function(eno,eventType){
    		
    		index_timeCost_operation='saveCost';
    		
			$('#index_timeCost_progressId').val('');//赋值
			$('#index_timeCost_eno').val(eno);//赋值
			$('#index_timeCost_eventType').val(eventType);//赋值
			$('#index_timeCost_window').window('open');//开窗
    	},
    	
    	/**
    	 * 编辑时间成本.
    	 */
    	editTimeCost:function(grid,eno,eventType){
    		
    		checkBeforeEditGrid(grid,function(rowData){
				
    			index_timeCost_operation='editCost';	
    			
    			resetForm("#index_timeCost_window form");
    			
    			$('#index_timeCost_eno').val(eno);//赋值
    			$('#index_timeCost_eventType').val(eventType);//赋值
    			

    			$('#index_timeCost_progressId').val(rowData.progressId);
    			$('#index_timeCost_tcId').val(rowData.userId);
    			$('#index_timeCost_tcName').val(rowData.userName);
    			$('#index_timeCost_opertionTime').val(rowData.opertionTime);
    			$('#index_timeCost_useTime').val(rowData.useTime);
    			$('#index_timeCost_perHourFees').val(rowData.perHourFees);
    			$('#index_timeCost_skillFees').val(rowData.skillFees);
    			$('#index_timeCost_othersFees').val(rowData.othersFees);
    			$('#index_timeCost_totalFees').val(rowData.totalFees);
    			$('#index_timeCost_description').val(rowData.description);
    			$('#index_timeCost_belongsStage').val(rowData.stage);
    			
    			if(rowData.status=='2'){
    				$('#index_timeCost_statusComplete').attr('checked',true);
    			}else{
    				$('#index_timeCost_statusComplete').attr('checked','');
    			}
    			
    			$('#index_timeCost_costTaskId').val(rowData.taskId);
    			$('#index_timeCost_costTaskTitle').val(rowData.title);

    			$('#index_timeCost_window').window('open');//开窗
				
			});
    	},
    	
    	/**
    	 * 删除时间成本.
    	 */
    	deleteTimeCost:function(grid){
    		
    		checkBeforeDeleteGrid(grid,function(rowIds){
				
				var _param = $.param({'ids':rowIds},true);
				$.post("cost!deleteCost.action", _param, function(){
					$(grid).trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'show');
				}, "json");
				
			});
    		
    	},
    	/**
    	 * 保存任务.
    	 */
    	saveTimeCost:function(grid){
    		
   			if($("#index_timeCost_window form").form('validate')){

   					var _param = $("#index_timeCost_window form").serialize();
   					var _url='cost!'+index_timeCost_operation+'.action';
   					$.post(_url,_param,function(){
   						$('#index_timeCost_window').window('close');
   			 			$(grid).trigger('reloadGrid');
   			 			msgShow(i18n['saveSuccess'],'show');	
   					});
   				   				
			}
    	},
    	
    	loadCostCurrency:function(){
    		
    		$.post('currency!findDefaultCurrency.action',function(data){
    			if(data!=null && data!=''){
    				
    				$('#index_timeCost_perHourFees_currency').text(data);
    				$('#index_timeCost_skillFees_currency').text(data);
    				$('#index_timeCost_othersFees_currency').text(data);
    				$('#index_timeCost_totalFees_currency').text(data);
    				
    			}else{
    				
    				$('#index_timeCost_perHourFees_currency').text('￥');
    				$('#index_timeCost_skillFees_currency').text('￥');
    				$('#index_timeCost_othersFees_currency').text('￥');
    				$('#index_timeCost_totalFees_currency').text('￥');
    			}
    		});
    	}
    	
    	
		
    };


}();


//载入
$(document).ready(itsm.problem.problemTimeCost.loadCostCurrency);