$package("itsm.request") 

 /**  
 * @author Van  
 * @constructor Van
 * @description 选择关联请求公共方法.
 * @date 2011-05-28
 * @since version 1.0 
 */
$import('itsm.config.categoryManage.eventCategoryTree');

itsm.problem.problemUtil = function() {
	
	this.index_loadRelatedProblemGridFlag="0";

	//载入
	return {

		/**
		 * @description 选择关联请求Grid
		 */
		showGrid:function(){
			  var params = $.extend({},jqGridParams, {
	                url: 'problem!findProblemPager.action',
	                caption:i18n['problem_grid'],
	                colNames:[i18n['problem_code'],i18n['title'],i18n['category'],
	                          //'指派给','优先级','报告人','报告时间',
	                          i18n['status'],''],
	                colModel:[ {name:'problemNo',width:30},
	                           {name:'etitle',width:40},
	                           {name:'categoryName',width:10,align:'center'},
	                           //{name:'assignName',width:10,align:'center'},
	                           //{name:'priorityName',width:10,align:'center'},
	                           //{name:'CreatedByName',width:10,align:'center'},
	                           //{name:'createdOn',width:10,align:'center',formatter:timeFormatter},
	                           {name:'statusName',width:20,align:'center'},                   
	                           {name:'eno',hidden:true}
	                           ],
	                jsonReader: $.extend({},jqGridJsonReader, {
	                    id: "eno"
	                }),
	                sortname: 'eno',
	                ondblClickRow:function(rowId){
	                	                	
	                },
	                pager: '#index_related_problem_grid_pager'
	            });
	            $("#index_related_problem_grid").jqGrid(params);
	            $("#index_related_problem_grid").navGrid('#index_related_problem_grid_pager', navGridParams);
	            //列表操作项
	            $("#t_index_related_problem_grid").css(jqGridTopStyles);
	            $("#t_index_related_problem_grid").append($('#index_related_problem_grid_toolbar').html());
			
	            //搜索
	            //$('#index_related_problem_grid_search').click(itsm.problem.problemUtil.searchRelatedProblem);//搜索
	            
	        	$('#index_related_problem_grid_search_categoryName').click(function(){//选择分类
	        		itsm.config.categoryManage.eventCategoryTree.problemCategory('#index_related_problem_grid_search_categoryName','#index_related_problem_grid_search_categoryNo');
	        	});
	            

		},
		
		/**
		 * @description 打开选择关联问题窗口
		 */
		openSelectWindow:function(callback){
			
			
			
			$('#index_related_problem_grid_idCategory').show();
			$('#index_related_problem_grid_etitle').val('');
			
			var _url="problem!findProblemPager.action";				
			$('#index_related_problem_grid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
			
			
			$('#index_related_problem_window').window('open');
			
			if(index_loadRelatedProblemGridFlag=="0"){
				
				itsm.problem.problemUtil.showGrid();//加载列表
				index_loadRelatedProblemGridFlag="1";	
				
				$('#index_related_problem_grid_select').click(function(){
					itsm.problem.problemUtil.confirmSelect(callback);
				});//选定
				
			}else{
				$('#index_related_problem_grid').trigger('reloadGrid');
			}
			
			$('#index_related_problem_grid_search').unbind();
			$('#index_related_problem_grid_search').click(itsm.problem.problemUtil.searchRelatedProblem);//搜索
		},
		
		/**
		 * @description 选定选中的问题
		 */
		confirmSelect:function(callback){
			var rowIds = $("#index_related_problem_grid").getGridParam('selarrrow');
			if(rowIds==''){
				
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else{
				callback(rowIds);
				$('#index_related_problem_window').window('close');
			}
		},
		
		
		
		
		
		/**
		 * @description 搜索问题
		 */
		searchRelatedProblem:function(){
			
			var _url="problem!findProblemPager.action";
			var sdata = $('#index_related_problem_grid_form').getForm();			
			$('#index_related_problem_grid').jqGrid('setGridParam',{page:1,url:_url,postData:sdata}).trigger('reloadGrid');
		},
		
		
		
		
		
		
		
		
		/**
		 * 全文检索.
		 */
		fullsearchOpenwindow:function(queryString,callback){
			
			
			
			$('#index_related_problem_grid_idCategory').hide();
			$('#index_related_problem_grid_etitle').val(queryString);
			
			$('#index_related_problem_window').window('open');
			
			
			if(index_loadRelatedProblemGridFlag=="0"){
				
				itsm.problem.problemUtil.showGrid();//加载列表
				index_loadRelatedProblemGridFlag="1";	
				
				$('#index_related_problem_grid_select').click(function(){
					itsm.problem.problemUtil.confirmSelect(callback);
				});//选定
				
			}
			
			setTimeout(function(){
				var _url="problem!fullSearch.action";
				var _fullSearchData = $.param({'compassQueryDTO.alias':'Problems','compassQueryDTO.queryString':queryString});								
				$('#index_related_problem_grid').jqGrid('setGridParam',{page:1,url:_url,postData:_fullSearchData}).trigger('reloadGrid');
			},1000);

			
			$('#index_related_problem_grid_search').unbind();
			$('#index_related_problem_grid_search').click(itsm.problem.problemUtil.doFullsearch);//搜索
			
			
		},
		
		
		
		
		

		doFullsearch:function(){
			
			var _url="problem!fullSearch.action";
			var _queryString=$('#index_related_problem_grid_etitle').val();
			var _fullSearchData = $.param({'compassQueryDTO.alias':'Problems','compassQueryDTO.queryString':_queryString});								
			$('#index_related_problem_grid').jqGrid('setGridParam',{page:1,url:_url,postData:_fullSearchData}).trigger('reloadGrid');
		}
		
		
		
	};
	
}();

