/**  
 * @author Van  
 * @constructor Van
 * @description 问题关联请求
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');
$import('itsm.request.requestUtil');




itsm.problem.relatedRequestGrid = function () {

	
	this.relatedRequestGrid_eno;
	

    return {

    	
    	/**
		 * @description 关联请求列表
		 */
		showRelatedRequestGrid:function(eno){
    	
    	
    		relatedRequestGrid_eno=eno;
    	
    	
			var params=$.extend({},jqGridParams,{
				caption:i18n['problem_relatedRequest'],
				url:'problem!findProblemRelatedRequest.action?eno='+eno,
				colNames:['',i18n['common_id'],i18n['common_title'],i18n['category'],i18n['requester'],i18n['title_request_assignToTC'],i18n['priority'],i18n['common_state'],i18n['common_createTime'],i18n['title_request_SLAState']],
				colModel:[
				          {name:'eno',hidden:true},
						  {name:'requestCode',width:10},
						  {name:'etitle',width:15},
						  {name:'ecategoryName',width:10,align:'center',sortable:false},
						  {name:'createdByName',width:10,align:'center',sortable:false},
						  {name:'assigneeName',width:10,align:'center',sortable:false},
						  {name:'priorityName',width:10,align:'center',sortable:false},
						  {name:'statusName',width:10,align:'center',sortable:false},
						  {name:'createdOn',width:15,align:'center',formatter:timeFormatter,sortable:false},
						  {name:'slaState',width:10,align:'center',sortable:false}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "eno"}),
				sortname:'eno',
				pager:'#problem_relatedRequestGridPager',
				autowidth:true
			});
			$("#problem_relatedRequestGrid").jqGrid(params);
			$("#problem_relatedRequestGrid").navGrid('#problem_relatedRequestGridPager',navGridParams);
			//列表操作项
			$("#t_problem_relatedRequestGrid").css(jqGridTopStyles);
			$("#t_problem_relatedRequestGrid").append($('#problem_relatedRequestToolbar').html());
			setGridWidth("#problem_relatedRequestGrid","regCenter",418);			
			problemDetailsGrids.push('#problem_relatedRequestGrid');

			$('#problem_relatedRequestGrid_add').click(function(){//添加关联请求
							
				itsm.request.requestUtil.openSelectWindow(function(rowIds){
					itsm.problem.relatedRequestGrid.add_reletedRequest(rowIds);
				});
			});
			
			
			$('#problem_relatedRequestGrid_fullsearch').click(function(){//搜索类似的请求
				
				itsm.request.requestUtil.fullsearchOpenwindow(queryString,function(rowIds){
					itsm.problem.relatedRequestGrid.add_reletedRequest(rowIds);
				});
			});
			
			
			

			$('#problem_relatedRequestGrid_remove').click(itsm.problem.relatedRequestGrid.remove_reletedRequest);//移除关联请求
			
		},
		
		
		/**
		 * @description 移除关联的请求
		 */
		remove_reletedRequest:function(){
			checkBeforeDeleteGrid('#problem_relatedRequestGrid', function(rowIds){
				var _param = $.param({'requestIds':rowIds,'eno':relatedRequestGrid_eno},true);
				var _url="problem!removeRelatedRequest.action";
				$.post(_url,_param,function(){
					
					msgShow(i18n['problem_removeRelatedRequest'],'show');
					$('#problem_relatedRequestGrid').trigger('reloadGrid');
				});
			});
		},
		
		/**
		 * @description 添加关联的请求.
		 */
		add_reletedRequest:function(rowIds){
	
			var _param = $.param({'requestIds':rowIds,'eno':relatedRequestGrid_eno},true);
			var _url="problem!addRelatedRequest.action";
			$.post(_url,_param,function(){
				msgShow(i18n['problem_addRelatedRequest'],'show');
				$('#problem_relatedRequestGrid').trigger('reloadGrid');
			});
			
		}
		
		/**
		 * @description 添加关联的请求.
		 */
		
		
		
    };

}();