/**  
 * @author Van  
 * @constructor Van
 * @description 问题关联的任务.
 * @date 2011-05-26
 * @since version 1.0 
 */
$package('itsm.problem');

itsm.problem.timeCost_relatedTask = function () {


	this.timeCost_relatedTask_titlePut;
	this.timeCost_relatedTask_idPut;
	
    return {
    	
    	/**
    	 * 打开选择窗口
    	 */
    	openTaskWindow:function(eno,eventType,p_titlePut,p_idPut){
    		
    		timeCost_relatedTask_titlePut=p_titlePut;
    		timeCost_relatedTask_idPut=p_idPut;
    		$('#timeCostRelatedTask_window').window('open');
    		itsm.problem.timeCost_relatedTask.showTaskGrid(eno,eventType);//加载列表
    		
    	},
    	
    	/**
    	 * 状态格式化.
    	 */
    	statusFormat:function(cell,event,data){
    		
    			if(data.taskStatus=='0')
    				return i18n['title_newCreate'];
    			if(data.taskStatus=='1')
    				return i18n['task_label_pending'];
    			if(data.taskStatus=='2')
    				return i18n['lable_complete'];
    		
    	},
    	/**
    	 * 动作格式化
    	 */
    	actionFormat:function(cell,event,data){
    		return '<a onclick=itsm.problem.timeCost_relatedTask.confirmSelect("'+data.title+'","'+data.taskId+'")><img src="../images/icons/ok.png" /></a>';
    	},
    	
    	/**
    	 * 选定动作.
    	 */
    	confirmSelect:function(title,taskId){
    		
    		$(timeCost_relatedTask_titlePut).val(title);
    		$(timeCost_relatedTask_idPut).val(taskId);
    		
    		$('#timeCostRelatedTask_window').window('close');
    	},
    	
    	/**
    	 * 显示列表
    	 */
    	showTaskGrid:function(eno,eventType){

    		var params = $.extend({},jqGridParams, {	
				url:'eventTask!findPagerChangeTask.action?queryDTO.eno='+eno+'&queryDTO.eventType='+eventType,
				caption:i18n['caption_request_taskGrid'],
				colNames:[i18n['title'],i18n['status'],i18n['common_owner'],i18n['operateItems'],'','','',''],
				colModel:[
			   		{name:'title',width:30,align:'center'},
			   		{name:'taskStatusPanel',width:20,align:'center',formatter:itsm.problem.timeCost_relatedTask.statusFormat},   				   		
			   		{name:'owner',width:20,align:'center'},
			   		{name:'act',width:30,align:'center',formatter:itsm.problem.timeCost_relatedTask.actionFormat},
			   		{name:'taskId',hidden:true},
			   		{name:'taskStatus',hidden:true},
			   		{name:'startTime',hidden:true},
			   		{name:'endTime',hidden:true}
				],	
				toolbar:false,
				jsonReader: $.extend(jqGridJsonReader,{id: "taskId"}),
				sortname:'taskId',
				pager:'#timeCostRelatedTaskGridPager',

			});
			$('#timeCostRelatedTaskGrid').jqGrid(params);
			$('#timeCostRelatedTaskGrid').navGrid('#timeCostRelatedTaskGridPager',navGridParams);
    	}

    };


}();