$package('itsm.request'); 
/**  
 * @fileOverview 我的任务（请求）
 * @author Tan
 * @version 1.0  
 */  
 /**  
 * @author Tan  
 * @constructor myRequestTask
 * @description 我的任务（请求）
 * @date 2010-02-26
 * @since version 1.0 
 */
$import("itsm.common.utility.tabUtility");
itsm.request.myRequestTask = function() 
{
	return {
		/**
		 * @description 数据列表行格式化.
		 */
		titleUrlFrm:function(cellvalue, options, rowObject){
			var executionId=rowObject.executionId;
			if(executionId.indexOf('Changes')>=0){
				return "<a href=javascript:itsm.request.myRequestTask.changeDetails("+rowObject.variables.dto.eno+")>"+cellvalue+":"+rowObject.variables.dto.etitle+"</a>"
			}	
			else if(executionId.indexOf('request')>=0 || executionId.indexOf('Request')>=0){	
				return '<a href="JavaScript:itsm.request.myRequestTask.requestDetails('+rowObject.variables.dto.eno+','+rowObject.id+')">'+cellvalue+"："+rowObject.variables.dto.etitle+'</a>'
			}else{
				return cellvalue;
			}
		},
		
		changeDetails:function(changeId){
			itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+changeId,i18n['title_changeInfo']);
		},
		
		/**
		 * @description 转到请求详细页面.
		 */
		requestDetails:function(gr,taskId){
			itsm.common.utility.tabUtility.reOpenTab('request!requestDetails.action?eno='+gr+'&taskId='+taskId,i18n['title_request_requestDetail']);
		},
		
		/**
		 * @description 加载我的任务列表.
		 */
		myRequestTaskGrid:function(){
			var params=$.extend({},jqGridParams,{
				caption:i18n['caption_request_myRequestTask'],
				url:'upload!showMyTasks.action',
				colNames:['ID',i18n['common_name'],i18n['title_request_requestTitle'],i18n['common_desc'],i18n['common_createTime'],'eno'],
				colModel:[
	  					  {name:'id'},
						  {name:'name',width:150,formatter:this.titleUrlFrm},
						  {name:'variables.dto.etitle',hidden:true},
						  {name:'description',index:'description',width:100},
						  {name:'createTime',index:'createTime',width:100,formatter:timeFormatter},
						  {name:'variables.dto.eno',index:'cno',hidden:true}
					  ],
				toolbar:false,
				jsonReader: $.extend(jqGridJsonReader, {id: "id"}),
				sortname:'id',
				pager:'#MyRequestTaskPager'
			});
			$("#MyRequestTaskGrid").jqGrid(params);
			$("#MyRequestTaskGrid").navGrid('#MyRequestTaskPager',navGridParams);
			//自适应大小
			setGridWidth("#requestOwnerGrid","regCenter",10);
		},
		init: function(){
			itsm.request.myRequestTask.myRequestTaskGrid();
		}
	}
}();

$(document).ready(itsm.request.myRequestTask.init);
