$package("itsm.request")
/**  
 * @fileOverview 请求详细信息主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 请求详细信息主函数
 * @description 请求详细信息主函数
 * @date 2010-11-17
 * @since version 1.0 
 */

itsm.request.requestAction=function(){
	return {
		/**
		 * @description 重新打开详细信息页面.
		 */
		reOpeRequestInfo:function(){
			var _url ="request!requestDetails.action?eno="+$('#requestDetails_requestNo').val();
			itsm.common.utility.tabUtility.reOpenTab(_url,i18n["title_request_requestDetail"]);
		},
		/**
		 * @description 打开请求动作窗口.
		 */
		openRequestActionWin:function(id){
			$('#'+id).window('open');
		},
		
		requestActionIsEmailNotice:function(isEmailNoticeId,requestRemarkId){
			if($("#"+isEmailNoticeId).attr("checked")){
				$('#'+requestRemarkId).val($('#'+requestRemarkId).val()+'<br>['+i18n['is_request_action_notice']+']')
			}
		},
		
		//开始请求处理
		requestDeal_opt:function(){
			
			if($('#startRequestDeal_form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('startRequestDeal_isEmailNotice','requestDeal_value');
				
				var frm = $('#requestDeal_win form,#requestActionComm form').serialize();
				
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					$('#requestDeal_win').window('close');
					if($("#startRequestDeal_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('startRequestDeal_action');
					}
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_startSuccessful'],'show');
					
				});
			}	
		},
		//请求提取
		requestGet_opt:function(){
			
			if($('#requestGet_win form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestGet_isEmailNotice','requestGet_value');
	
				var frm = $('#requestGet_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					$('#requestGet_win').window('close');
					if($("#requestGet_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestExtraction_action');
					}
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_getSuccessful'],'show');
			
				});
			}
			
		},
		
		/**
		 * @description 进行指派操作.
		 */
		requestAssign_opt:function(){
			
			if($('#requestDetail_assigneeGroupName').val()=='' && $('#requestDetail_assigneeName').val()==''){
				msgAlert('<span style="color:red">'+i18n["msg_request_assignCanNotNull"]+'</span>','info');

			}else if($('#assignRemark').val()==''){
				msgAlert('<span style="color:red">'+i18n["msg_request_assignMarkCanNotNull"]+'</span>','info');
			}else{

				var frm = $('#requestAssign_win form,#requestActionComm form').serialize();
				var logDetails="historyRecordDto.logDetails="+i18n['label_request_assignGroup']+":"+$('#requestDetail_assigneeGroupName').val()+"-"+i18n['label_request_assigner']+":"+$('#requestDetail_assigneeName').val()+"<br>"+i18n['remark']+":"+$('#assignRemark').val()
				if($("#requestAssign_isEmailNotice").attr("checked")){
					logDetails+='<br>['+i18n['is_request_action_notice']+']'
				}
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm+"&"+logDetails,function(){
					
					//隐藏进程
					endProcess();
					$('#requestAssign_win').window('close');
					if($("#requestAssign_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestAssign_action');
					}
					itsm.request.requestAction.reOpeRequestInfo();
					
					msgShow(i18n['msg_request_assignSuccessful'],'show');
					
				});
			}
				
		},
		
		
		/**
		 * @description 进行二线\三线\四线指派.
		 */
		requestAssign_opt:function(line,div){
			if($('#requestDetail_assigneeGroupName_'+line).val()=='' && $('#requestDetail_assigneeName_'+line).val()==''){
				
				msgAlert('<span style="color:red">'+i18n["msg_request_assignCanNotNull"]+'</span>','info');
				
			}else if($('#assignRemark_'+line).val()==''){
				
				msgAlert('<span style="color:red">'+i18n["msg_request_assignMarkCanNotNull"]+'</span>','info');
				
			}else{
				var frm = $('#'+div+' form,#requestActionComm form').serialize();
				var logDetails="historyRecordDto.logDetails="+i18n['label_request_assignGroup']+":"+$('#requestDetail_assigneeGroupName_'+line).val()+"-"+i18n['label_request_assigner']+":"+$('#requestDetail_assigneeName_'+line).val()+"<br>"+i18n['remark']+":"+$('#assignRemark_'+line).val()
				
				if($("#"+div+'_isEmailNotice').attr("checked")){
					logDetails+='<br>['+i18n['is_request_action_notice']+']'
				}
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm+"&"+logDetails,function(){
					
					//隐藏进程
					endProcess();
					if($("#"+div+'_isEmailNotice').attr("checked")){
						itsm.request.requestAction.emailNotice(div+'_action');
					}
					$('#'+div).window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_assignSuccessful'],'show');
				});
			}
		},

		/**
		 * @description 进行请求再指派.
		 */
		requestAgainAssign_opt:function(){
			if($('#requestDetail_assigneeName_Again').val()==''){
				
				msgAlert('<span style="color:red">'+i18n["msg_request_assignCanNotNull"]+'</span>','info');
				
			}else if($('#assignRemark_Again').val()==''){
				
				msgAlert('<span style="color:red">'+i18n["msg_request_assignMarkCanNotNull"]+'</span>','info');
				
			}else{
				var frm = $('#requestAgainAssign_win form,#requestActionComm form').serialize();
				var logDetails="historyRecordDto.logDetails="+i18n['label_request_assigner']+":"+$('#requestDetail_assigneeName_Again').val()+"<br>"+i18n['remark']+":"+$('#assignRemark_Again').val()
				if($("#requestAgainAssign_isEmailNotice").attr("checked")){
					logDetails+='<br>['+i18n['is_request_action_notice']+']'
				}
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm+"&"+logDetails,function(){
					
					//显示进程
					endProcess();
					if($("#requestAgainAssign_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestAssignAgain_action');
					}
					$('#requestAgainAssign_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					
					msgShow(i18n['msg_request_assignSuccessful'],'show');
				});
			}
		},
		
		
		
		/**
		 * @description 执行请求回退操作.
		 */
		requestBack_opt:function(){
			if($('#requestBack_win').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestBack_isEmailNotice','requestBackReason_value');
				
				var frm = $('#requestBack_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//显示进程
					endProcess();
					if($("#requestBack_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('backToFirstLine_action');
					}
					$('#requestBack_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_backSuccessful'],'show');
				});
			}
		},
		
		
		
		/**
		 * @description 执行请求升级操作.
		 */
		requestUpgrade_opt:function(){
			if($('#requestUpgrade_win form').form('validate')){
				var frm = $('#requestUpgrade_win form,#requestActionComm form').serialize();
				var logDetails="historyRecordDto.logDetails="+i18n['label_request_updateTo']+":"+$('#requestDetail_upgradeToName').val()+"<br>"+i18n['label_request_updateCause']+":"+$('#requestUpgradeReason').val()
				if($("#requestUpgrade_isEmailNotice").attr("checked")){
					logDetails+='<br>['+i18n['is_request_action_notice']+']'
				}
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm+"&"+logDetails,function(){
					
					//隐藏进程
					endProcess();
					if($("#requestUpgrade_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestUpdate_action');
					}
					$('#requestUpgrade_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					
					
					msgShow(i18n['msg_request_updateSuccessful'],'show');
					
				});
			}	
		},
		
		/**
		 * @description 进行请求升级操作.
		 */
		requestUpgradeApply_opt:function(){
			if($('#requestUpgradeApply_win').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestUpgradeApply_isEmailNotice','requestUpgradeApplyReason_value');
				
				var frm = $('#requestUpgradeApply_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					if($("#requestUpgradeApply_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('upgradeApplication_action');
					}
					$('#requestUpgradeApply_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					
	
					msgShow(i18n['msg_request_submitSucceccful'],'show');
				});
			}
		},
		/**
		 * @description 请求关闭窗口
		 */
		requestClose_win:function(){
			var myDate = new Date();
			
			$('#requestCloseTime').val(myDate.getFullYear()+"-"+(myDate.getMonth()+1)+"-"+myDate.getDate()+" "+myDate.toLocaleTimeString())
			$('#requestClose_win').window('open');
		},
		
		requestClose_opt:function(){
			
			if($('#requestClose_win form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestClose_isEmailNotice','requestClose_value');
				
				var frm = $('#requestClose_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					if($("#requestClose_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestClose_action');
					}
					$('#requestClose_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
		
					msgShow(i18n['msg_request_closeSuccessful'],'show');
					
				});
			}	
		},
		//处理备注
		requestDealRemark_opt:function(){
			if($('#requestDealRemark_win form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestDealRemark_isEmailNotice','requestDealRemark_value');
				
				var frm = $('#requestDealRemark_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					if($("#requestDealRemark_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestProcessMrak_action');
					}
					$('#requestDealRemark_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_addSucceccful'],'show');
					
				});
			}	
		},
		//处理完成
		requestDealComplete_opt:function(){
			if($('#requestDealComplete_win form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestDealComplete_isEmailNotice','requestDealComplete_value');
				
				var frm = $('#requestDealComplete_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					if($("#requestDealComplete_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('processComplete_action');
					}
					$('#requestDealComplete_win').window('close');
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_submitSucceccful'],'show');
	
				});
			}	
		},
		
		
		
		//请求重新开启
		requestReOpen_opt:function(){
			if($('#requestReOpen_win form').form('validate')){
				
				itsm.request.requestAction.requestActionIsEmailNotice('requestReOpen_isEmailNotice','requestReOpen_value');
				
				var frm = $('#requestReOpen_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					$('#requestReOpen_win').window('close');
					if($("#requestReOpen_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('reStartRequest_action');
					}
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_restartSuccessful'],'show');
				});
			}
		},
		//回退组
		requestBackGroup_opt:function(){
			
			if($('#requestBackGroup_win form').form('validate')){
			
				itsm.request.requestAction.requestActionIsEmailNotice('requestBackGroup_isEmailNotice','requestBackGroup_value');
				
				var frm = $('#requestBackGroup_win form,#requestActionComm form').serialize();
				//显示进程
				startProcess();
				$.post('request!requestAction.action',frm,function(){
					//隐藏进程
					endProcess();
					$('#requestBackGroup_win').window('close');
					if($("#requestBackGroup_isEmailNotice").attr("checked")){
						itsm.request.requestAction.emailNotice('requestBackToGroup_action');
					}
					itsm.request.requestAction.reOpeRequestInfo();
					msgShow(i18n['msg_request_backSuccessful'],'show');
				});
			}
			
		},
		/**
		 * @description 请求回访
		 */
		requestVisit_win:function(){
			$("#requestVisit_win table").html("");
			$.post('visit!findVisit.action?rows=10000&useStatus=true',function(data){
				if(data==null || data.data==null) return;
				var visitItem=data.data;
				
				for(var i=0;i<visitItem.length;i++){
					if(visitItem[i].useStatus){
						var html="";
					    if(visitItem[i].visitItemType=='radio'
					            && visitItem[i].visitItems!=null){
					    	
							for(var j=0;j<visitItem[i].visitItems.length;j++){
							    html+= "<input type='radio' value='"+visitItem[i].visitItems[j].visitItemName+"' name='visitItemValue"+i+"' ";
							    if (j==0) {html+= "checked='checked' ";}
							    html+= "/>"+visitItem[i].visitItems[j].visitItemName;
							}
					    } else {
					        html="<input  id='visitItemValue"+i+"' />";
					    }
					    $("#requestVisit_win table").append("<tr><td>"+visitItem[i].visitName+"<input type='hidden' value='"+visitItem [i].visitName+"' id='visitItemName"+i+"' /></td><td>"+html+"</td></tr>");
					}
				}
			});
			$('#requestVisit_win').window('open');
		},
		/**
		 * @description 对请求进行回访
		 */
		requestVisit_opt:function(){
				var tab = document.getElementById("requestVisit_table") ;
			    //表格行数
			    var rows = tab.rows.length;
			    var visitRecord='';
			    for(var i=0;i<rows;i++){
			    	var _value = $("input[@type=radio][name=visitItemValue"+i+"][checked]").val();
			    	if(_value==undefined){
			    		_value=$('#visitItemValue'+i).val();
			    	}
			    	visitRecord=visitRecord+$('#visitItemName'+i).val()+":"+_value+"<br><hr>"
			    }
			    
				setTimeout(function(){
					$('#request_visitRecord').val(visitRecord);
					var frm = $('#requestVisit_win form,#requestActionComm form').serialize();
					$.post('request!requestAction.action',frm+'&requestDTO.visitState=1',function(){
						$('#requestVisit_win').window('close');
						itsm.request.requestAction.reOpeRequestInfo();
						msgShow(i18n['msg_request_reViewSuccessful'],'show');
					});
				},0);
				
		},
		
		requestApproval_opt:function(result){
			
			var frm = $('#requestApproval_win form,#requestActionComm form').serialize();
			//显示进程
			startProcess();
			$.post('request!requestAction.action',frm+"&requestDTO.approvalResult="+result,function(){
				//隐藏进程
				endProcess();
				if($("#requestApproval_isEmailNotice").attr("checked")){
					itsm.request.requestAction.emailNotice('requestApproval_action');
				}
				$('#requestApproval_win').window('close');
				itsm.request.requestAction.reOpeRequestInfo();
				
				msgShow(i18n['msg_request_appSuccessful'],'show');
			
			});
		},
		//邮件通知请求人
		emailNotice:function(actionId){
			var frm = $('#emailNoticeInfoDiv form').serialize();
			var titleString=i18n['rquestTreatmentProgress']+':'+$('#'+actionId).val()+'('+$('#requestCode').val()+')'
			$.post('noticeRule!noticeRule.action',frm+'&titleString='+titleString,function(){})
		}
	}
}();