$package("itsm.request");
 /**  
 * @fileOverview 新增请求主函数.
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor Van
 * @description 新增请求主函数.
 * @date 2010-11-17
 * @since version 1.0 
 * @returns
 * @param select
 */
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.config.categoryManage.eventCategoryTree");
$import("itsm.security.userUtil");
$import("itsm.cm.configureItemUtil");
$import("itsm.config.eav.attributes");

itsm.request.addRequest = function(){
	return {
		
		
		/**
		 * @description 选择请求者.
		 */
		selectRequestCreator:function(){
			
			itsm.security.userUtil.selectUser('#selectCreator','#addRequestUserId','','loginName');
		},
		
		/**
		 * @description 选择请求分类.
		 */
		selectRequestCategory:function(){

			itsm.config.categoryManage.eventCategoryTree.showSelectTree('#add_request_select_category_panel'
					,'#add_request_select_category_panel'
					,'Request'
					,'#addRequestCategoryName'
					,'#addRequestCategoryNo');
		},
		
		/**
		 * @description 提交保存请求.
		 */
		saveRequest:function(){
			var title=$.trim($('#request_etitle').val());
			var edesc=$.trim($('#request_edesc').val());
			var uid=$('#addRequestUserId').val();
			var username=$('#selectCreator').val();
			if($('#addRequestForm').form('validate')){
				var frm = $('#addRequestDiv form').serialize();
				var url = 'request!saveRequest.action';
				//调用
				startProcess();
				$.post(url,frm, function(eno){
						endProcess();
						closeTab(i18n['title_request_addRequest']);
						showRequestIndex();
						itsm.common.utility.tabUtility.reOpenTab("request!requestDetails.action?eno="+eno,i18n["title_request_requestDetail"]);
						$('#requestGrid').trigger('reloadGrid');
						msgShow(i18n['msg_request_addSuccessful'],'show');
					
				});
			}
		},
  
		init:function() 
		{
			
			
			$("#addRequest_loading").hide();
			$("#addRequestDiv").show();
			
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#request_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#request_seriousness');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('imode','#request_imode');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('level','#request_level');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#request_priority');
			
			$('#saveRequestBtn').click(itsm.request.addRequest.saveRequest);
			$('#selectCreator').click(itsm.request.addRequest.selectRequestCreator);
			$('#selectAssigneeInfo').click(itsm.request.addRequest.selectRequestAssignee);
			setTimeout(function(){
				getUploader('#add_request_file','#add_request_attachmentStr','#add_request_success_attachment','');
			},0)
			
			
			
			//绑定
			$('#add_request_ref_ciname').click(function(){
				itsm.cm.configureItemUtil.selectCIS('#add_request_ref_ciname','#add_request_ref_ciid');
			});

			//设置请求下拉树的宽度
			setTimeout(function(){
				$('#add_request_select_category_panel').css('width',$('#addRequestCategoryName').css('width'));
			},0);
			
			
			itsm.config.eav.attributes.showAttributes('request','request_add_eavAttributet');
			
		}
	}
}();
//载入
$(document).ready(itsm.request.addRequest.init);