$package("itsm.request")
/**  
 * @fileOverview 请求详细信息主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 请求详细信息主函数
 * @description 请求详细信息主函数
 * @date 2010-11-17
 * @since version 1.0 
 */
$import('itsm.request.requestEmailHistory');
$import("itsm.jbpm.processCommon");
$import("itsm.common.utility.tabUtility")
$import("itsm.request.requestAction");
$import("itsm.request.requestTask");
$import("itsm.request.requestEventCost");

$import("itsm.security.userUtil");
$import("itsm.security.organizationTreeUtil");
$import("itsm.tools.eventAttachment");
$import("itsm.config.eav.attributes");




itsm.request.requestDetail = function() 
{
	var eno=$('#requestDetails_requestNo').val();
	
	//请求详细页面数据列表集合
	this.requestDetailsGrids=[];
	//加载标识
	this.loadTaskFlag="0";
	this.loadTimeDetailFlag="0";
	this.loadRequestHistoryOptLogFlag="0";
	this.loadAttachementTag="0";
	this.loademailHistoryListFlag="0"
	this.optLogHtml;
	return {
		
		
		/**
		 * @description 选择指派组
		 */
		selectAssginGroup:function(assigneeGroupNo,assigneeGroupName){
			
			
			itsm.security.organizationTreeUtil.showAll_2('#requestAssginGroup_win','#assginGroupTree',assigneeGroupName,assigneeGroupNo);
		},
		/**
		 * @description 选择指派信息
		 */
		selectRequestUser_byOrgNo:function(userName,userId){
			
			itsm.security.userUtil.selectUser(userName,userId,'','loginName');
		},

		saveSlutionsOnly:function(){
			tag="only";
			itsm.request.requestDetail.saveSlutions();
			
		},
		saveSlutionsBoth:function(){
			tag="both";
			itsm.request.requestDetail.saveSlutions();
			
		},
		saveSlutions:function(){
			var frm = $('#requestSolutionsDiv form').serialize();
			var url = 'request!saveSolutions.action';
			$.post(url,frm, function()
			{
				if(tag=="both"){
					itsm.request.requestDetail.saveToKnowledge();
				}else{
					msgShow(i18n['msg_request_solutionsSaveSuccessful'],'show');
				}
			});
		},
		
		/**
		 * @description 解决方案转为知识
		 */
		saveToKnowledge:function(){
			refreshTab(i18n["title_request_newKnowledge"],"request!jumpToAddKnowledge.action?eno="+eno);
				
		},
		/**
		 * @description 查找相关的知识
		 */
		usefullKnowledge:function(){
			
			refreshTab(i18n["title_request_knowledgeGrid"],"../pages/knowledge/knowledgeMain.jsp?keyWord="+$('#requestDetailDTO_keyWord').val());
		},
		/**
		 * @description 查找类似的请求
		 */
		sameRequest:function(){
			showLeftMenu('../pages/request/leftMenu.jsp','leftMenu');	
			refreshTab(i18n["title_request_requestGrid"],"../pages/request/requestMain.jsp?keyWord="+$('#requestDetailDTO_keyWord').val());
		},
			
		
		/**
		 * @description tab点击事件
		 */
		tabClick:function(){
	            $('#requestDetailsTab').tabs({
	                onSelect:itsm.request.requestDetail.tabClickEvents
	            });
		},
		
		/**
		 * @description 点击tab后，根据tab标题加载不同的数据
		 */
		tabClickEvents:function(title){

			
			if(title==i18n["title_request_task"]){
				if(loadTaskFlag=="0"){
					var requestEventTask=new eventTask($('#requestDetails_requestNo').val(),'request');
					requestEventTask.eventTaskGrid();
					loadTaskFlag="1";
				}
			}
			if(title==i18n["title_request_timeDetail"]){
				if(loadTimeDetailFlag=="0"){
					var requestEventCost=new eventCost(eno,'request');
					requestEventCost.eventCostGrid();
					loadTimeDetailFlag="1";
				}
			}
			if(title==i18n["title_request_history"]){
				var requestHistoryRecord=new historyRecord('requestHistoryRecord',eno,'itsm.request');
				requestHistoryRecord.showHistoryRecord();
			}
			if(title==i18n["title_request_emailHistory"]){
				
				if(loademailHistoryListFlag=="0"){
					itsm.request.requestEmailHistory.emailHistoryList();
					loademailHistoryListFlag="1";
				}
			}
			if(title==i18n["attachment"]){
			
				if(loadAttachementTag=="0"){
					itsm.tools.eventAttachment.showEventAttachment('show_request_attachment',eno,'itsm.request');
					loadAttachementTag="1";
				}
				
			}
			
			
		},
		
		/**
		 * 选择负责人
		 */
		request_selectUser:function(userName,userId){
		
			itsm.security.userUtil.selectUser(userName,userId,'loginName');			
		},
		
		
		/**
		 * @description 选择用户
		 */
		requestDetails_SelectUser_win:function(id1,id2){
			assigneeName_id=id1;
			assigneeNo_id=id2;
			openSelectWindow();
		},
		
		
		
		/**
		 * @description 提交变更
		 */
		requestInfoToChange:function(){
			itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeAdd.jsp?enos='+eno,i18n['titie_change_add']);
		},
		
		configureItemInfo:function(id){
			itsm.common.utility.tabUtility.reOpenTab('ci!findByciId.action?ciEditId='+id,i18n['ci_configureItemInfo']);
		},
		
		//数据列表伸展
	
		requestDetailsPanelCollapseAndExpand:function(){
			
			 $(requestDetailsGrids).each(function(i, g) {
			      setGridWidth(g, 'requestDetailsTab', 10);
			 });
		},
		//数据列表自动伸展
		fitRequestDetailsGrids:function(){
			
			$('#requestDetails_west,#requestDetails_center').panel({
				onCollapse:itsm.request.requestDetail.requestDetailsPanelCollapseAndExpand,
				onExpand:itsm.request.requestDetail.requestDetailsPanelCollapseAndExpand
			});
		},
		//请求邮件回复
		rquestActionEmailReply_win:function(){
			var requestEmailReplyTitle=i18n['rquestTreatmentProgress']+':('+$('#requestCode').val()+')'
			$('#requestEmailReplyTitle').val(requestEmailReplyTitle);
			$('#requestEmailReplyUser').val($('#rquestDetailCreatedByEmail').val());
			$('#rquestActionEmailReply').window('open');
		},
		
		rquestActionEmailReply:function(){
			var _param = $('#rquestActionEmailReply form').serialize();
			startProcess();
			var _url='email!toEmail.action';
			$.post(_url,_param,function(result){
				endProcess();
				if(result){
					$('#rquestActionEmailReply').window('close');
					resetForm("#rquestActionEmailReplyForm");
					msgShow(i18n['msg_sendSuccessful'],'show');
				}else{
					msgShow(i18n['sendFailure'],'show');
				}
					
			});

		},
		init:function(){
			
			$("#requestDetail_loading").hide();
			$("#requestDetail_contentPanel").show();
			
			//绑定页面加载事件
			itsm.request.requestDetail.tabClick();
			$('#saveToKnowledgeBtn').click(itsm.request.requestDetail.saveSlutionsBoth);
			$('#saveSolutionsBtn').click(itsm.request.requestDetail.saveSlutionsOnly);
			//流程跟踪
			$('#traceRequestDetailBtn').click(function(){itsm.jbpm.processCommon.showFlowChart( $('#requestDetail_pid').val())});
			$('#submitChangeBtn_info').click(itsm.request.requestDetail.requestInfoToChange);
			setTimeout(itsm.request.requestDetail.fitRequestDetailsGrids,0);
			
			$('#searchSimilarRequest_btn').click(function(){//查看类似请求
				itsm.compass.fullSearch.openFullsearchWindow(queryString,'request');			
			});
			
			itsm.config.eav.attributes.showAttributeInfoByEno(eno,'itsm.request','request_info_eavAttributet')
			
			$('#request_email_reply').click(itsm.request.requestDetail.rquestActionEmailReply_win);
			$('#rquestActionEmailReply_send').click(itsm.request.requestDetail.rquestActionEmailReply);
			$('#requestDetails_edit_but').click(function(){itsm.common.utility.tabUtility.reOpenTab("request/requestEdit.jsp?eno="+eno,i18n["title_request_editRequest"]);});

			
			//提交问题
			$('#request_detail_2problem').click(function(){
				
				itsm.common.utility.tabUtility.reOpenTab('../pages/problem/addProblem.jsp?enos='+eno,i18n['problem_add']);
			});
			
		}
	}	
}();
//载入
$(document).ready(itsm.request.requestDetail.init);