$package("itsm.request")
/**  
 * @fileOverview "requestEdit"
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor requestEdit
 * @description "requestEdit"
 * @date 2010-11-17
 * @since version 1.0 
 */
$import("itsm.jbpm.processCommon");
$import("itsm.config.dataDictionary.dataDictionaryUtil");

$import("itsm.config.categoryManage.eventCategoryTree");
$import("itsm.security.organizationTreeUtil");
$import("itsm.security.userUtil");
$import("itsm.tools.eventAttachment");
$import("itsm.cm.configureItemUtil");
$import("itsm.config.eav.attributes");

itsm.request.requestEdit = function() 
{
	return {
		/**
		 * @description 获取当前请求信息
		 */
		findRequestById:function(){
			var url = 'request!findRequestById.action?requestQueryDTO.eno='+eno;
			$.post(url, function(res)
			{
				//基本信息
				$('#requestEdit_pid').val(res.pid);
				if(res.pid!=null){
					$('#traceRequestEditBtn').attr('style','margin-right:15px;')
				}
				$('#requestEdit_eno').val(res.eno);
				$('#requestEdit_etitle').val(res.etitle);
				$('#requestEdit_edesc').val(res.edesc);
				if(res.statusNo!=null){
					$('#requestEdit_status').val(res.statusNo);
				}else{
					$('#requestEdit_status').val('');
				}
				if(res.ecategoryNo!=null)
					$('#requestEdit_ecategory').val(res.ecategoryNo);
				else
					$('#requestEdit_ecategory').val('');
				
				if(res.effectRangeNo!=null)
					$('#requestEdit_effectRange').val(res.effectRangeNo);
				else
					$('#requestEdit_effectRange').val('');
				if(res.levelNo!=null)
					$('#requestEdit_level').val(res.levelNo);
				else
					$('#requestEdit_level').val('');
				if(res.priorityNo!=null)
					$('#requestEdit_priority').val(res.priorityNo);
				else
					$('#requestEdit_priority').val('');
				
				if(res.seriousnessNo!=null)
					$('#requestEdit_seriousness').val(res.seriousnessNo);
				else
					$('#requestEdit_seriousness').val('');
				if(res.imodeNo!=null)
					$('#requestEdit_imode').val(res.imodeNo);
				else
					$('#requestEdit_imode').val('');
	
				$('#requestEdit_address').val(res.address);
				//请求人
				$('#RequestEdit_UserId').val(res.createdByNo);
				$('#RequestEdit_UserName').val(res.createdByName);
				if(res.createdByPhone!=null)
					$('#RequestEdit_UserPhone').val(res.createdByPhone);
				else
					$('#RequestEdit_UserPhone').val('');
				//指派
				if(res.assigneeGroupName!=null)
					$('#requestEdit_assigneeGroupName').val(res.assigneeGroupName);
				else
					$('#requestEdit_assigneeGroupName').val('');
				if(res.assigneeGroupNo!=null)
					$('#requestEdit_assigneeGroupNo').val(res.assigneeGroupNo);
				else
					$('#requestEdit_assigneeGroupNo').val('');
					
				if(res.assigneeName!=null)
					$('#requestEdit_assigneeName').val(res.assigneeName);
				else
					$('#requestEdit_assigneeName').val('');
				if(res.assigneeNo!=null)
					$('#requestEdit_assigneeNo').val(res.assigneeNo);
				else
					$('#requestEdit_assigneeNo').val('');
				
				//关系配置项
				if(res.ciName!=null){
					$('#edit_request_ref_ciname').val(res.ciName);
				}
				if(res.ciId!=null){
					$('#edit_request_ref_ciid').val(res.ciId);
				}
				//解决方案
				if(res.solutions!=null){
					$('#requestEditSolutions').val(res.solutions);
				}
				//影响明细
				$('#requestEditEffectRemark').val(res.effectRemark);
				$('#requestEdit_requestCode').val(res.requestCode);
				//请求分类
				if(res.requestCategoryNo!=null)
					$('#editRequestCategoryNo').val(res.requestCategoryNo);
				if(res.requestCategoryName!=null)
					$('#editRequestCategoryName').val(res.requestCategoryName);
				
				
				
			});
			
		},
		/**
		 * @description 选择请求分类
		 * */
		selectEditRequestCategory:function(){
			
			itsm.config.categoryManage.eventCategoryTree.showSelectTree('#edit_request_select_category_panel'
					,'#edit_request_select_category_panel'
					,'Request'
					,'#editRequestCategoryName'
					,'#editRequestCategoryNo');
		},
		
		
		/**
		 * @description 保存修改
		 * */
		saveRequestEdit:function(){
			if($('#requestEditForm').form('validate')){
				var frm = $('#requestEditDiv form').serialize();
				var url = 'request!updateRequest.action';
				startProcess();
				$.post(url,frm, function(){
					endProcess();
					showRequestIndex();
					$('#requestGrid').trigger('reloadGrid');
					//关闭请求详情TAB
					closeTab(i18n['title_request_editRequest']);
					msgShow(i18n['saveSuccess'],'show');
		
				});
			}
		},
		/**
		 * @description 创建人信息
		 * */
		selectCreator_openWindow:function(){
			itsm.security.userUtil.selectUser('#RequestEdit_UserName','#RequestEdit_UserId','','loginName');
		},
		
		
	
		
		/**
		 * @description 删除附件
		 */
		deleteRequestAttachement:function(eno,aid){
			
			$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
				if(r){
					var _url = "request!deleteRequestAttachement.action";
					$.post(_url,'eno='+eno+'&aid='+aid,function(){
						$('#show_edit_request_attachment #att_'+aid).remove();
						msgShow(i18n['deleteSuccess'],'show');
					});
				}
			});
			
		},
		init: function() 
		{
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#requestEdit_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#requestEdit_seriousness');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('imode','#requestEdit_imode');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('level','#requestEdit_level');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#requestEdit_priority');

			setTimeout(itsm.request.requestEdit.findRequestById,0);
			
			//流程跟踪
			$('#traceRequestEditBtn').click(function(){itsm.jbpm.processCommon.showFlowChart( $('#requestEdit_pid').val() );});
			
			$('#RequestEdit_UserName').click(itsm.request.requestEdit.selectCreator_openWindow);
			
			setTimeout(function(){
				//getUploader('上传文件文本ID','上传后返回的信息字符串','显示上传成功的附件','');
				getUploader('#edit_request_file','#edit_request_attachmentStr','#show_edit_request_attachment_success','',function(){
					itsm.tools.eventAttachment.saveEventAttachment('show_edit_request_attachment',eno,'itsm.request','edit_request_attachmentStr');
				});
				
			},0)
			
			itsm.tools.eventAttachment.showEventAttachment('show_edit_request_attachment',eno,'itsm.request');
			
			//设置请求下拉树的宽度
			setTimeout(function(){
				$('#edit_request_select_category_panel').css('width',$('#editRequestCategoryName').css('width'));
			},0);

			$('#edit_request_ref_ci').click(function(){//选择配置项
				
				itsm.cm.configureItemUtil.selectCIS('#edit_request_ref_ci','#requestEditCIId');
				
			});
			itsm.config.eav.attributes.findAttributeByEno(eno,'itsm.request','request_edit_eavAttributet')
			//绑定
			$('#edit_request_ref_ciname').click(function(){
				
				itsm.cm.configureItemUtil.selectCIS('#edit_request_ref_ciname','#edit_request_ref_ciid');
				
			});
			
		}
	}
}();


//载入
$(document).ready(itsm.request.requestEdit.init);