

$package('itsm.request');


itsm.request.requestEmailHistory=function(){
	
	return {

		/**
		 * @description 类型格式化.
		 */
		folderNameFormat:function(cellvalue, options){
			if(cellvalue=="INBOX"){
				return i18n['common_receive'];
			}
				
			else{
				return i18n['common_sent'];
			}
				
		},
		
		  /**
         * @description 发件人格式化
         */
        FromUserFormatter:function(cellvalue,options){
        	var newCellValue=(cellvalue.replace('<',' ')).replace('>',' ');
        	return newCellValue;
        },
        
        
        /**
         * @description 收件人格式化
         */
        ToUserFormatter:function(cellvalue,options){
        	var newCellValue=(cellvalue.replace('<',' ')).replace('>',' ');
        	return newCellValue;
        },
		
		
		 /**
         * @description 标题格式化
         */
        emailGridTitleFormatter: function (cell, opt, data) {
		
            return "<a href=javascript:itsm.request.requestEmailHistory.showEmailDetail('" + data.emailMessageId + "')>" + cell + "</a>";
        },

		/**
		 * @description 请求历史邮件
		 */
		emailHistoryList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'email!findEmailAboutRequest.action?emailMessageQueryDto.subject='+$('#requestCode').val(),
				caption:i18n['caption_emailGrid'],
				colNames:[i18n['number'],i18n['title_mailTitle'],i18n['title_mailType'],i18n['title_mailFromUser'],i18n['title_mailToUser'],i18n['title_sendTime'],i18n['title_receviceTime']],
				colModel:[
			   		{name:'emailMessageId',width:60,sortable:true},
			   		{name:'subject',width:200,formatter:this.emailGridTitleFormatter},
			   		{name:'folderName',width:90,formatter:this.folderNameFormat},
			   		{name:'fromUser',width:150,formatter:this.FromUserFormatter},
			   		{name:'toUser',width:150,formatter:this.ToUserFormatter},
			   		{name:'sendDate',width:140,formatter:timeFormatter},
			   		{name:'receiveDate',width:140,formatter:timeFormatter}
			   	],
			   	toolbar: false,
			   	ondblClickRow:function(rowId){itsm.request.requestEmailHistory.showEmailDetail(rowId)},
				jsonReader: $.extend(jqGridJsonReader, {id: "emailMessageId"}),
				sortname:'emailMessageId',
				pager:'#emailHistoryPager'
			});
			$("#emailHistoryGrid").jqGrid(params);
			$("#emailHistoryGrid").navGrid('#emailHistoryPager',navGridParams);
			requestDetailsGrids.push('#emailHistoryGrid');
		},
		
		/**
		 *@description 显示邮件详细信息
		 */
		showEmailDetail:function(id){
			var url="email!showEmailDetail.action?eid="+id;
			refreshTab(i18n['common_email']+i18n['details'],url);		
		},
		
		downloadAttachMent:function(attachMentId){
			
			var url="attachment!download.action?downloadAttachmentId="+attachMentId;
			window.location=url;
		}
	}
	
}();
