$package("itsm.request") 
/**  
 * @fileOverview "请求主函数"
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author Tan  
 * @constructor Van
 * @description 请求主函数
 * @date 2010-11-17
 * @since version 1.0 
 */

$import("itsm.request.requestStats");
$import("itsm.config.categoryManage.eventCategoryTree");
$import("itsm.config.dataDictionary.dataDictionaryUtil");
itsm.request.requestMain = function() {
	
	
	//载入
	return {

		upgradeApplySignFormat:function(cellValue){
			if(cellValue=='0'){
				return "<a title='"+i18n['label_request_normor']+"'><img src=../images/icons/app_normor.png /></a>";
			}
			if(cellValue=='1'){
				return "<a title='"+i18n['label_request_appToUpdate']+"'><img src=../images/icons/app_toupdate.png /></a>";
			}
			if(cellValue=='2'){
				return "<a title='"+i18n['label_request_updateComplete']+"'><img src='../images/icons/app_update.png' /></a>";
			}
		},
		titleUrlFormatter:function(cellvalue, options, rowObject){
			return '<a href="JavaScript:itsm.request.requestMain.requestDetails('+rowObject.eno+')">'+cellvalue+'</a>'
			
		},
		/**
		 * @description 操作项格式化
		 */
		requestGridFormatter:function(){
			return $('#requestGridFormatterDiv').html();
		},
	
		
		
		
		
		/**
		 * @description 请求列表
		 */
		showRequestList:function(){
			var _url='request!findRequests.action'
			
			var _postData={};
			
			if(request_fullSearchFlag=="yes"){//全文检索
				
				var fullSearchQueryString=$('#fullSearchKeyWord').val();
				_url="request!analogousRequest.action";						
				$.extend(_postData,{'compassQueryDTO.alias':'RequestInfo','compassQueryDTO.queryString':fullSearchQueryString});
				
			}else{
				
				if(countQueryType!='' && currentUser!=''){
					_url=_url+'?requestQueryDTO.countQueryType='+countQueryType+'&requestQueryDTO.currentUser='+currentUser
				}
			}
			
			
			var params=$.extend({},jqGridParams,{
				caption:i18n['title_request_requestGrid'],
				url:_url,
				postData:_postData,
				colNames:['','tag',i18n['common_id'],i18n['common_title'],i18n['category'],i18n['requester'],i18n['common_owner'],i18n['title_request_assignToGroup'],i18n['title_request_assignToTC'],i18n['priority'],i18n['common_state'],i18n['common_createTime'],i18n['title_request_SLAState'],i18n['common_action']],
				colModel:[
				          {name:'eno',hidden:true},
				          {name:'upgradeApplySign',width:16,formatter:itsm.request.requestMain.upgradeApplySignFormat},
						  {name:'requestCode',width:70},
						  {name:'etitle',width:100,formatter:itsm.request.requestMain.titleUrlFormatter},
						  {name:'requestCategoryName',width:50,sortable:false,align:'center'},
						  {name:'createdByName',width:40,sortable:false,align:'center'},
						  {name:'ownerName',width:40,sortable:false,align:'center'},
						  {name:'assigneeGroupName',width:50,sortable:false,align:'center'},
						  {name:'assigneeName',width:55,sortable:false,align:'center'},
						  {name:'priorityName',width:35,align:'center',sortable:false},
						  {name:'statusName',width:35,sortable:false,align:'center'},
						  {name:'createdOn',width:80,formatter:timeFormatter,align:'center'},
						  {name:'slaState',width:50,sortable:false,align:'center'},
						  {name:'act', width:50,sortable:false,align:'center',formatter:itsm.request.requestMain.requestGridFormatter}
						  ],
				jsonReader: $.extend({},jqGridJsonReader, {id: "eno"}),
				ondblClickRow:function(rowId){itsm.request.requestMain.requestDetails(rowId)},
				sortname:'eno',
				pager:'#requestGridPager'
			});
			$("#requestGrid").jqGrid(params);
			$("#requestGrid").navGrid('#requestGridPager',navGridParams);
			//列表操作项
			$("#t_requestGrid").css(jqGridTopStyles);
			$("#t_requestGrid").append($('#requestGridToolbar').html());
			//自适应大小
			setGridWidth("#requestGrid","regCenter",10);
			
			request_fullSearchFlag="no";
			
			
		},
		/**
		 * @description 新增请求
		 */
		showAddRequest:function(){
			refreshTab(i18n["title_request_addRequest"],'../pages/request/addRequest.jsp');
		},
		/**
		 * @description 请求详细
		 */
		requestDetails_aff:function(){
			checkBeforeEditGrid('#requestGrid',itsm.request.requestMain.requestDetailsOpt);
		},
		requestDetailsOpt:function(rowData){
			itsm.common.utility.tabUtility.reOpenTab("request!requestDetails.action?eno="+rowData.eno,i18n["title_request_requestDetail"]);
		},
		/**
		 * @description 请求详细
		 */
		requestDetails:function(eno){
			itsm.common.utility.tabUtility.reOpenTab("request!requestDetails.action?eno="+eno,i18n["title_request_requestDetail"]);
		},
		
		/**
		 * @description 请求编辑操作
		 */
		editRequest_aff:function(){
			checkBeforeEditGrid('#requestGrid', itsm.request.requestMain.showEditRequest);
		},
		
		/**
		 * @description 请求编辑打开
		 */
		showEditRequest:function(rowData){
			itsm.common.utility.tabUtility.reOpenTab("request/requestEdit.jsp?eno="+rowData.eno,i18n["title_request_editRequest"]);
		},
		/**
		 * @description 判断是否选择要删除的请求
		 */
		deleteRequest_aff:function(){
			checkBeforeDeleteGrid('#requestGrid', itsm.request.requestMain.deleteRequestOpt);
		},
		/**
		 * @description 删除请求操作
		 */
		deleteRequestOpt:function(rowsId){
			var url="request!deleteRequests.action";
			var param = $.param({'enos':rowsId},true);
			$.post(url, param, function()
			{
				//重新统计
				countRequest();
				$('#requestGrid').trigger('reloadGrid');
				
				msgShow(i18n['msg_deleteSuccessful'],'show');
				
			}, "json");	
		},
		
		
		/**
		 * @description 搜索
		 */
		searchRequestOpenWindow:function(){
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('requestStatus','#searchRequest_statusNo');
			$('#searchRequestWindow').window('open');
		},
		
		/**
		 * 搜索树结构.
		 */
		search_select_category:function(){
			
			
			itsm.config.categoryManage.eventCategoryTree.showSelectTree('#search_request_select_category_window'
					,'#search_request_select_category_tree'
					,'Request'
					,'#searchRequest_ecategoryName'
					,'#searchRequest_ecategoryNo');

		},
		
		doSearchRequest:function(){
			var _url = 'request!findRequests.action';	
			var sdata = $('#searchRequestWindow form').getForm();
			var postData = $("#requestGrid").jqGrid("getGridParam", "postData");     
			$.extend(postData, sdata);
			$('#requestGrid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
		},
		
		/**
		 * @description 提交变更
		 */
		requestMainToChange:function(){
			var rowIds = $("#requestGrid").getGridParam('selarrrow');
			if(rowIds=='')
			{
				$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
			}
			else
			{
				itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeAdd.jsp?enos='+rowIds,i18n['titie_change_add']);
			}	
		},
		
		/**
		 * 提交问题.
		 */
		request2Problem:function(){
			
			var rowIds = $("#requestGrid").getGridParam('selarrrow');
			if(rowIds==''){
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else{
				itsm.common.utility.tabUtility.reOpenTab('../pages/problem/addProblem.jsp?enos='+rowIds,i18n['problem_add']);
			}	
		},
		
		
		/**
		 * 导出数据到Excel
		 */
		exportRequestData:function(){
			var extype=$("#exportData").val();
			
			if(extype=="view"){
				itsm.request.requestMain.exportRequestView();	
			}
			if(extype=="all"){
				msgAlert(i18n["msg_dc_comfirmExport"],"question");
			}
		},
	
	     //获取查找数据和列表数据提交到后台
		exportRequestView:function(){	
			
			var url = "request!exportRequest.action";	
			var sdata = $('#searchRequestWindow form').getForm();
			var rqData = $("#requestGrid").jqGrid("getGridParam", "postData");   
			for(i in sdata)
			{    
				if(sdata[i]!=""&&sdata[i]!=null){
					if(i=='requestQueryDTO.requestCode')$('#exportRq_requestCode').val(sdata[i]); 
					if(i=='requestQueryDTO.statusNo')$('#exportRq_statusNo').val(sdata[i]);
					if(i=='requestQueryDTO.etitle')$('#exportRq_etitle').val(sdata[i]);
					if(i=='requestQueryDTO.ecategoryNo')$('#exportRq_ecategoryNo').val(sdata[i]);
				}
			}
			$('#exportRq_sidx').val(rqData.sidx);
			$('#exportRq_sord').val(rqData.sord);
			$('#exportRq_page').val(rqData.page);
			$('#exportRq_rows').val(rqData.rows);
			$("#exportRequestWindow form").submit();
		},

		
		/**
		 * 全文检索
		 */
		showFullSearchGrid:function(queryString){
			
				openTab(i18n['title_allRequestList'],'../pages/request/requestMain.jsp');//如果没打开就打开显示
				
				setTimeout(function(){
					
					var _url="request!analogousRequest.action";
					var _fullSearchData = $.param({'compassQueryDTO.alias':'RequestInfo','compassQueryDTO.queryString':''});								
					$('#requestGrid').jqGrid('setGridParam',{page:1,url:_url,postData:_fullSearchData}).trigger('reloadGrid');
					
				},1000);
				
		},
		
		
		
		init: function() 
		{
			
			$("#requestMain_loading").hide();
			$("#requestMain_content").show();
			
			
		
			itsm.request.requestMain.showRequestList();				
			$('#addRequestBtn').click(itsm.request.requestMain.showAddRequest);
			$('#editRequestBtn').click(itsm.request.requestMain.editRequest_aff);
			$('#deleteRequestBtn').click(itsm.request.requestMain.deleteRequest_aff);
			$('#searchRequestBtn').click(itsm.request.requestMain.searchRequestOpenWindow);
			$('#doSearchRequestBtn').click(itsm.request.requestMain.doSearchRequest);
			$('#submitChangeBtn_list').click(itsm.request.requestMain.requestMainToChange);
			$('#request2problem').click(itsm.request.requestMain.request2Problem);
			
			//搜索分类
			$('#searchRequest_ecategoryName').click(itsm.request.requestMain.search_select_category);
	
		
			
		}
	}
}();

//载入
$(document).ready(itsm.request.requestMain.init);

