$package("itsm.request") 

 /**  
 * @author Van  
 * @constructor Van
 * @description 选择关联请求公共方法.
 * @date 2011-05-28
 * @since version 1.0 
 */
itsm.request.requestUtil = function() {
	
	this.index_loadRelatedRequestGridFlag="0";

	//载入
	return {

		/**
		 * @description 选择关联请求Grid
		 */
		selectRelatedRequestGrid:function(){
			var params=$.extend({},jqGridParams,{
				caption:i18n['title_request_requestGrid'],
				url:'request!findRequests.action',
				colNames:[i18n['common_id'],i18n['common_title'],i18n['requester'],i18n['priority'],i18n['common_state'],i18n['common_createTime'],''],
				colModel:[
						  {name:'requestCode',width:15,align:'center'},
						  {name:'etitle',width:20,align:'center'},
						  {name:'createdByName',width:15,align:'left',sortable:false},
						  {name:'priorityName',width:15,align:'left',sortable:false},
						  {name:'statusName',width:15,align:'left',sortable:false},
						  {name:'createdOn',width:20,align:'left',sortable:false},
						  {name:'eno',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id:"eno"}),
				sortname:'eno',
				autowidth:false,
				width:575,
				height:222,
				pager:'#index_related_request_grid_pager'
			});
			$("#index_related_request_grid").jqGrid(params);
			$("#index_related_request_grid").navGrid('#index_related_request_grid_pager',navGridParams);
			
			//列表操作项
			$("#t_index_related_request_grid").css(jqGridTopStyles);
			$("#t_index_related_request_grid").append($('#index_related_request_grid_toolbar').html());
			
			//搜索
			//$('#index_related_request_grid_search').click(itsm.request.requestUtil.searchRelatedRequest);//搜索
			
			
			
			
			

		},
		
		/**
		 * @description 打开选择关联请求窗口
		 */
		openSelectWindow:function(callback){

			
			var _url="request!findRequests.action";				
			$('#index_related_request_grid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
			
			$('#index_related_request_grid_requestCode').show();
			
			
			if(index_loadRelatedRequestGridFlag=="0"){
				
				itsm.request.requestUtil.selectRelatedRequestGrid();//加载列表
				index_loadRelatedRequestGridFlag="1";
				
				$('#index_related_request_grid_select').click(function(){
					itsm.request.requestUtil.confirmSelect(callback);
				});//选定
				
			}else{
				$('#index_related_request_grid').trigger('reloadGrid');
			}
			
			
			$('#index_related_request_grid_search').unbind();
			$('#index_related_request_grid_search').click(itsm.request.requestUtil.searchRelatedRequest);//搜索
			
			
			$('#index_related_request_window').window('open');
		},
		
		/**
		 * @description 选定选中的请求
		 */
		confirmSelect:function(callback){
			var rowIds = $("#index_related_request_grid").getGridParam('selarrrow');
			if(rowIds==''){
				
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else{
				callback(rowIds);
				$('#index_related_request_window').window('close');
			}
		},
		
		/**
		 * @description 搜索请求
		 */
		searchRelatedRequest:function(){
			
			var _url = 'request!findRequests.action';
			var sdata = $('#index_related_request_grid_form').getForm();
			$('#index_related_request_grid').jqGrid('setGridParam',{page:1,url:_url,postData:sdata}).trigger('reloadGrid');
		},
		
		/**
		 * 全文检索.
		 */
		fullsearchOpenwindow:function(queryString,callback){
			
			$('#index_related_request_grid_requestCode').hide();
			$('#index_related_request_grid_etitle').val(queryString);
			
			if(index_loadRelatedRequestGridFlag=="0"){
				
				itsm.request.requestUtil.selectRelatedRequestGrid();//加载列表
				index_loadRelatedRequestGridFlag="1";
				
				$('#index_related_request_grid_select').click(function(){
					itsm.request.requestUtil.confirmSelect(callback);
				});//选定	
			}
			
			
			setTimeout(function(){
				
				var _url="request!analogousRequest.action";
				var _fullSearchData = $.param({'compassQueryDTO.alias':'RequestInfo','compassQueryDTO.queryString':queryString});								
				$('#index_related_request_grid').jqGrid('setGridParam',{page:1,url:_url,postData:_fullSearchData}).trigger('reloadGrid');
				
			},1000);
			
			
			
			
			$('#index_related_request_grid_search').unbind();
			$('#index_related_request_grid_search').click(itsm.request.requestUtil.doFullsearch);//搜索
			
			$('#index_related_request_window').window('open');
		},
		
		doFullsearch:function(){
			
			var _url="request!analogousRequest.action";
			var _queryString=$('#index_related_request_grid_etitle').val();
			var _fullSearchData = $.param({'compassQueryDTO.alias':'RequestInfo','compassQueryDTO.queryString':_queryString});								
			$('#index_related_request_grid').jqGrid('setGridParam',{page:1,url:_url,postData:_fullSearchData}).trigger('reloadGrid');
		}
		
		
		
	};
	
}();

