/**  
 * @author Van  
 * @constructor Van
 * @description 新增业务规则主函数.
 * @date 2011-02-26
 * @since version 1.0 
 */

$package('itsm.rules');
$import('itsm.rules.ruleCM');



itsm.rules.addRule= function(){
	
	this.i=0;
	this.j=0;
	
	
	return {

		/**
		 * @description 加载规则集属性列表.
		 */
		ruleTermSet:function(){
			
			    $("#addRule_team").html(''); 
			    $("#addRule_matical").html(''); 
				$(itsm.rules.ruleCM.loadConditionHTML()).appendTo("#addRule_team"); 
				$(itsm.rules.ruleCM.loadConditionMathematicalOperationHTML()).appendTo("#addRule_matical"); 
		},

		/**
		 * @description 显示属性标题.
		 */
		add_switchTitle:function(){
			
			return $("#addRule_team").find("option:selected").text()+$("#addRule_matical").find("option:selected").text();
		},
		
		/**
		 * @description 显示属性值.
		 */
		add_switchValue:function(){
				
			return itsm.rules.ruleCM.getRuleTitle('#addRule_team','#addRule_propertyValue','#addRule_namePut');
		},

		/**
		 * @description 加载下拉列表项.
		 */
		setPVHTML:function(){
			
			var flag=$('#addRule_team').val();
			itsm.rules.ruleCM.createRuleEvent(flag,'#addRule_propertyValueDIV','addRule_namePut','addRule_propertyValue','');
			
		},
		
		/**
		 * @description 符号
		 */
		setTerm:function(){
			
			itsm.rules.ruleCM.setMathematicalOperation('#addRule_team','#addRule_matical');
		},
	
		/**
		 * @description 提交新增.
		 */
		saveRule:function(){
			
			 if($('#addRuleForm').form('validate')){ 
				 
				 	var constraintsNames = $('#addRuleDiv form input[name="rule_condition_constraints_propertyName"]');
					var actionsNames = $('#addRuleDiv form input[name="rule_actions_propertyName"]');
					
					if(constraintsNames.length>0&&actionsNames.length>0){
						
						itsm.rules.addRule.saveRuleMethod();
					}else{
						msgAlert(i18n['msg_msg_vaildateRulesAndAction'],'error');
					}
			 }
		},
		
		/**
		 * @description 提交新增.
		 */
		saveRuleMethod:function(){			
			itsm.rules.ruleCM.saveRuleCommon('#addRuleDiv','save','#add_rule_and');
		},

		/**
		 * @description 添加规则集.
		 */
		addToRuleList:function(){
			
			var propertyName = $('#addRule_team').val()+' '+$('#addRule_matical').val();
			var propertyValue = $('#addRule_propertyValue').val();

			var key=$('#addRule_matical').val();

			if(key=="matches"){
				propertyValue=".*"+propertyValue+".*";
			}
			
			if(key=="matches start"){
				propertyValue=propertyValue+".*";
			}
			
			if(key=="matches end"){
				propertyValue=".*"+propertyValue;
			}
			
			if(propertyValue!=''){
				
				i++;
				
				var trHTML=itsm.rules.ruleCM.replaceRuleStr(i,
						itsm.rules.addRule.add_switchTitle(),
						'',
						itsm.rules.ruleCM.switchDataType('#addRule_team'),
						propertyName,
						itsm.rules.addRule.add_switchValue(),
						itsm.rules.addRule.add_switchValue(),
						propertyValue,
						"#constraint"+i
				);
				
				$("#addRule_constraintsTable").append(trHTML);				

			}else{

				msgAlert(i18n['msg_rule_ruleActionCanNotBeNull'],'error');
			}
		},

		/**
		 * @description 执行动作.
		 */
		executeAction:function(){
			
			$(itsm.rules.ruleCM.loadActionHTML()).appendTo("#addRule_executeAction"); 
		},
		
		/**
		 * @description 显示效果.
		 */
		add_switchAction:function(){
			
			return $("#addRule_executeAction").find("option:selected").text(); 
			
		},
		
		/**
		 * 获取相关动作的标题以显示到列表.
		 */
		add_switchGavenValue:function(){
			
			return itsm.rules.ruleCM.getRuleTitle('#addRule_executeAction','#givenValue','#givenValue_Panel');
		},
		
		
		/**
		 * 创建填写动作HTML控件.
		 */
		addRule_setExHTML:function(){
			
			var flag=$('#addRule_executeAction').val();
			itsm.rules.ruleCM.createRuleEvent(flag,'#givenValueDIV','givenValue_Panel','givenValue','itsm.rules.addRule.addRule_selectServiceOrg()');
		},
		

		/**
		 * @description 调用方法打开选择服务机构窗口.
		 */
		addRule_selectServiceOrg:function(){
						
			itsm.rules.ruleCM.selectServiceOrg('#addRuleSeclceServicesOrgTreeDIV','#addRuleSeclceServicesOrgDIV','#givenValue','#givenValue_Panel');
		},


		/**
		 * @description 将条件添加到动作列表.
		 */
		addToActionList:function(){
			
			var propertyName = $('#addRule_executeAction').val();
			var givenValue = $('#givenValue').val();
	
			var exitTag="0";
	
			$("#addRule_actionTable input:hidden[name='rule_actions_propertyName']").each(function(i,e){
				
				if(propertyName==$(this).val()){
					exitTag="1";
				}
			});
			
		   var valueTag=$('#givenValue').val();
			
		   if(exitTag=="0" && valueTag!=''){
				   
				   j++;
				   
				   var trHTML=itsm.rules.ruleCM.replaceActionStr(j,
						    itsm.rules.addRule.add_switchAction(),	
							propertyName,
							itsm.rules.addRule.add_switchGavenValue(),
							itsm.rules.addRule.add_switchGavenValue(),
							givenValue,
							"#action"+j
					);
				  					
					$("#addRule_actionTable").append(trHTML);
					$('#givenValue').val('');
					$('#givenValue_Panel').val('');
					
			   }else{
				   
					if(valueTag==''){
						
						msgAlert(i18n['label_rule_actionCanNotBeNull'],'info');	
					}else{
						
						 msgAlert(i18n['label_rule_actionExist'],'info');
					}
			   }
		},
		

		/**
		 * 载入.
		 */
		init:function(){
			
			$("#addRule_loading").hide();
			$("#addRule_content").show();

			$('#addRule_team').change(function(){
				
				itsm.rules.addRule.setPVHTML();
				itsm.rules.addRule.setTerm();
				
			});

			$('#addRule_executeAction').change(function(){
				
				itsm.rules.addRule.addRule_setExHTML();
			});

			$('#givenValue_Panel').click(itsm.rules.addRule.addRule_selectServiceOrg);
			$('#addRule_addRulesToList').click(itsm.rules.addRule.addToRuleList);			
			$('#addRule_addActionToList').click(itsm.rules.addRule.addToActionList);
			$('#addRule_saveRuleBtn').click(itsm.rules.addRule.saveRule);
			$('#addRule_returnRuleGrid').click(function(){itsm.rules.ruleCM.showRuleList(_rulePackageNo);});

			itsm.rules.addRule.ruleTermSet();
			itsm.rules.addRule.executeAction();
		}
	};
	
	
}();

$(document).ready(itsm.rules.addRule.init);