/**  
 * @author Van  
 * @constructor Van
 * @description 编辑SLA规则. rules/editRule.jsp
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.rules');
$import('itsm.rules.ruleCM');

itsm.rules.editRule = function(){
	
	
	this.j=0;
	this.i=0;
	
	
	return {
		
		
		/**
		 * @description 加载规则集属性.
		 */
		editRule_ruleTermSet:function(){
			
			$("#editRule_team").html(''); 
			$("#editRule_matical").html(''); 
			$(itsm.rules.ruleCM.loadConditionHTML()).appendTo("#editRule_team"); 
			$(itsm.rules.ruleCM.loadConditionMathematicalOperationHTML()).appendTo("#editRule_matical"); 
			
		},

		
		/**
		 * @description 取得属性中文显示名称.
		 */
		switchRuleNameActionName:function(str,putId){
			
			var newStr=itsm.rules.ruleCM.switchRuleName(str);
			
			$(putId).html(newStr);
		},
		
		
		edit_switchTitle:function(){
			return $("#editRule_team").find("option:selected").text()+$("#editRule_matical").find("option:selected").text();

		},
		
		/**
		 * 取值.
		 */
		edit_switchValue:function(){

			return itsm.rules.ruleCM.getRuleTitle('#editRule_team','#editRule_propertyValue','#editRule_namePut');
			
		},
		
		
		/**
		 * @description 加载规则集运算符号.
		 */
		editRule_setTerm:function(){
		
			
			
			//加载条件名称HTML
			itsm.rules.ruleCM.setMathematicalOperation('#editRule_team','#editRule_matical');
			
			var flag=$("#editRule_team").val();
			
			//调用方法显示规则条件HTML
			itsm.rules.ruleCM.createRuleEvent(flag,'#editRule_propertyValueDIV','editRule_namePut','editRule_propertyValue','');
			
		},

		/**
		 * @description 编辑.
		 */
		editRule_merge:function(){
			
			
			 if($('#editRuleForm').form('validate')){ 
				 
				 
				 var constraintsNames = $('#editRuleDiv form input[name="rule_condition_constraints_propertyName"]');
				 var actionsNames = $('#editRuleDiv form input[name="rule_actions_propertyName"]');
					
					if(constraintsNames.length>0&&actionsNames.length>0){
						
						itsm.rules.editRule.editRule_do();
						
					}else{
						
						msgAlert(i18n['msg_msg_vaildateRulesAndAction'],'error');
					}
			 }
		},
		
		/**
		 * @description 提交新增.
		 */
		editRule_do:function(){
		
			itsm.rules.ruleCM.saveRuleCommon('#editRuleDiv','merge','#edit_rule_and');
		},

		
		/**
		 * @description 添加规则集.
		 */
		editRule_addRulesToList:function(){
			
			var propertyName = $('#editRule_team').val()+' '+$('#editRule_matical').val();
			var propertyValue = $('#editRule_propertyValue').val();
			
			var key=$('#editRule_matical').val();
			
			
			if(key=="matches"){
				propertyValue=".*"+propertyValue+".*";
			}
			
			if(key=="matches start"){
				propertyValue=propertyValue+".*";
			}
			
			if(key=="matches end"){
				propertyValue=".*"+propertyValue;
			}

			if(propertyValue!=''){

				i++;
				
				var trHTML=itsm.rules.ruleCM.replaceRuleStr(i,
						itsm.rules.editRule.edit_switchTitle(),
						'',
						itsm.rules.ruleCM.switchDataType('#editRule_team'),
						propertyName,
						itsm.rules.editRule.edit_switchValue(),
						itsm.rules.editRule.edit_switchValue(),
						propertyValue,
						"#constraint"+i
				);

				$("#editRule_constraintsTable").append(trHTML);
				
				
			}else{
				
				msgAlert(i18n['msg_rule_ruleActionCanNotBeNull'],'error');
			}
		},


		
		/**
		 * @description 执行动作.
		 */
		editRule_executeAction:function(){
			
			$(itsm.rules.ruleCM.loadActionHTML()).appendTo("#editRule_executeAction"); 
		},
		
		/**
		 * @description 动作集显示效果.
		 */
		edit_switchAction:function(){
			
			return $("#editRule_executeAction").find("option:selected").text(); 
			
		},
		
		/**
		 * 获取相关动作的标题以显示到列表.
		 */
		edit_switchGavenValue:function(){		
			
			return itsm.rules.ruleCM.getRuleTitle('#editRule_executeAction','#editRule_givenValue','#editRule_givenValue_Panel');
		},
		
		
		/**
		 * 创建填写动作HTML控件.
		 */
		setEXHTML_edit:function(){
			
			var flag=$('#editRule_executeAction').val();

			itsm.rules.ruleCM.createRuleEvent(flag,'#editRule_givenValueDIV','editRule_givenValue_Panel','editRule_givenValue','itsm.rules.editRule.editRule_selectServiceOrg()');
		},

		/**
		 * @description 选择服务机构.
		 */
		editRule_selectServiceOrg:function(){			

			itsm.rules.ruleCM.selectServiceOrg('#editRuleSeclceServicesOrgTreeDIV','#editRuleSeclceServicesOrgDIV','#editRule_givenValue','#editRule_givenValue_Panel');
		},

		/**
		 * @description 添加动作集
		 */
		addToActionList:function(){
			
			var propertyName = $('#editRule_executeAction').val();
			var givenValue = $('#editRule_givenValue').val();
			
			var exitTag="0";

			$("#editRule_actionTable input:hidden[name='rule_actions_propertyName']").each(function(i,e){
				
				if(propertyName==$(this).val()){
					
					exitTag="1";
				}
				
			});
			
			var valueTag=$('#editRule_givenValue').val();

			if(exitTag=="0" && valueTag!=''){
				
				j++;
				
				 var trHTML=itsm.rules.ruleCM.replaceActionStr(j,
						 	itsm.rules.editRule.edit_switchAction(),							
						 	propertyName,
						 	itsm.rules.editRule.edit_switchGavenValue(),
						 	itsm.rules.editRule.edit_switchGavenValue(),
						 	givenValue,
							"#action"+j
					);
				
				$("#editRule_actionTable").append(trHTML);				
				$('#editRule_givenValue').val('');
				$('#editRule_givenValue_Panel').val('');

				
			}else{
				
				if(valueTag==''){					
					msgAlert(i18n['label_rule_actionCanNotBeNull'],'info');					
				}else{
					msgAlert(i18n['label_rule_actionExist'],'info');
				}
			}

		},

		init:function(){
			
			
			$("#editRule_loading").hide();
			$("#editRule_content").show();
			
			itsm.rules.editRule.editRule_ruleTermSet();
			itsm.rules.editRule.editRule_executeAction();
			
			$('#editRule_team').change(function(){
				itsm.rules.editRule.editRule_setTerm();
			});
			
			$('#editRule_addRuleToList').click(itsm.rules.editRule.editRule_addRulesToList);
		
			$('#editRule_executeAction').change(itsm.rules.editRule.setEXHTML_edit);
			$('#editRule_givenValue_Panel').click(itsm.rules.editRule.editRule_selectServiceOrg);
			$('#editRule_addActionsToList').click(itsm.rules.editRule.addToActionList);			
			$('#editRule_saveRule').click(itsm.rules.editRule.editRule_merge);
			
			$('#editRule_backToRuleList').click(function(){
				itsm.rules.ruleCM.showRuleList(_rulePackageNo);
			});
			
		}
		
		
	};
	
}();

$(document).ready(itsm.rules.editRule.init);