/**  
 * @author Van  
 * @constructor callBusinessRule
 * @description 规则列表主函数.rules/ruleMain.jsp
 * @date 2011-02-26
 * @since version 1.0 
 */
$package('itsm.rules');

itsm.rules.ruleMain = function(){
	 
	 
		return {

			
			/**
			 * @description 加载规则列表.
			 */
			showRulesGrid:function(){

				var params = $.extend({},jqGridParams, {	
					url:'callBusinessRule!findRules.action?rulePackageNo='+_rulePackageNo,
					caption:i18n['caption_ruleGrid'],
					colNames:[i18n['common_name'],i18n['common_desc'],''],
					colModel:[
						       {name:'ruleName',width:30},
						       {name:'description',width:70},
						       {name:'ruleNo',hidden:true}
						],
					jsonReader: $.extend(jqGridJsonReader, {id: "ruleNo"}),
					sortname:'ruleNo',
					pager:'#rulesGridPager'
				});
				$("#rulesGrid").jqGrid(params);
				$("#rulesGrid").navGrid('#rulesGridPager',navGridParams);
				//列表操作项
				$("#t_rulesGrid").css(jqGridTopStyles);
				$("#t_rulesGrid").append($('#rulesGridToolbar').html());
				//自适应大小
				setGridWidth("#rulesGrid","regCenter",10);
			},
			
			/**
			 * @description 转到新增规则页面.
			 */
			showAddRule:function(){
				
				refreshTab(i18n['title_rule_addRule'],"../pages/rules/addRule.jsp?rulePackageNo="+_rulePackageNo+"&tag="+tag);
				
			},
			
			
			
			/**
			 * @description 转到编辑规则页面.
			 */
			showEditRule:function(){
				
				var gr = jQuery("#rulesGrid").jqGrid('getGridParam','selrow');
				
				if(gr==null){
					
					msgAlert(i18n['msg_atLeastChooseOneData'],'info');
					
				}else{
					
					var row=$("#rulesGrid").getRowData(gr);
					var url ="callBusinessRuleSet!findRule.action?ruleNo="+row.ruleNo+"&packageNo="+_rulePackageNo+"&tag="+tag;
					refreshTab(i18n['title_rule_editRule'],url);
				}
				
			},
			
			
			/**
			 * @description 删除规则.
			 */
			delRules:function(){
				checkBeforeDeleteGrid('#rulesGrid',function(rowIds){
					
					var _param = $.param({'ruleNos':rowIds},true);
					$.post("callBusinessRule!delete.action",_param,function(rs){
						if(rs){
							
							$("#rulesGrid").trigger('reloadGrid');
							
							msgShow(i18n['msg_deleteSuccessful'],'show');
							
						}else{
							msgAlert(i18n['msg_canNotDeleteSystemData'],'info');	
						}	
		
					},"json");
					
				});
			},
			
				
			/**
			 * @description 搜索
			 * */
			doSearchRules:function(){
				var sdata = $('#searchRuleDiv form').getForm();
				var postData = $("#rulesGrid").jqGrid("getGridParam", "postData");       
				$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
				
				var _url = 'callBusinessRule!find.action';
				$('#rulesGrid').trigger('reloadGrid');
				
			},
			
			
			/**
			 * 载入
			 */
			init:function(){
				
				$("#ruleMain_loading").hide();
				$("#ruleMain_content").show();
				
				
				itsm.rules.ruleMain.showRulesGrid();

				$('#rulesGrid_add').click(itsm.rules.ruleMain.showAddRule);
				$('#rulesGrid_edit').click(itsm.rules.ruleMain.showEditRule);
				$('#rulesGrid_delete').click(itsm.rules.ruleMain.delRules);
				$('#rulesGrid_search').click(function(){
					$("#searchRuleDiv").window('open');
				});				
				
			

				$('#rulesGrid_doSearch').click(itsm.rules.ruleMain.doSearchRules);
				

			}
			
		};
}();



$(document).ready(itsm.rules.ruleMain.init);