
 /**  
 * @fileOverview 添加用户主函数.
 * @author Tan
 * @version 1.0  
 */  
 /**  
 * @author Tan  
 * @constructor adUser
 * @description 添加用户主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
var adUser=function(){
	
	/**
	 * @description 加载LDAP.
	 */
	this.LDAPId=0;
	this.loadLDAP=function(){
		$("").appendTo('#ldap');
		$("<option>----LDAP---</option>").appendTo('#ldap');
		$.post('ldap!getLDAPAll.action',function(data){
			this.options;
			options="";
			if(data!=null){
				if(data[0].LDAPId>0)
				{
					LDAPId=data[0].ldapId;
					$('#ldapId').val(data[0].ldapId);
				}
				for(var i=0;i<data.length;i++){
					options=options+"<option value='"+data[i].ldapId+"'>"+data[i].ldapName+"</option>"
				}
			}
			
			$(options).appendTo('#ldap');
		},"json")
		
	}
	
	/** 
	 * @description 用户列表.
	 */
	this.adUserList=function(){
		$('#adGrid').jqGrid({
			url:'ldap!getADByLDAP.action',
			mtype:'post',
			datatype:'json',
			height:'auto',
			autowidth:true,
			colNames:[i18n['loginName'],i18n['title_user_firstName'],i18n['title_user_lastName'],i18n['title_customer_email'],i18n['title_customer_phone'],i18n['title_user_mobile']],
		 	colModel:[
		 	          {name:'loginName',index:'loginName',width:80},
		 	          {name:'firstName',index:'firstName',width:50},
		 	          {name:'lastName',index:'lastName',width:50},
		 	          {name:'email',index:'email',width:80},
		 	          {name:'phone',index:'phone',width:80},
		 	          {name:'moblie',index:'moblie',width:80}
		 	],
		 	jsonReader: {
				root: "data",
				records:"totalSize",
				page: "page",
				total: "total",
	            repeatitems: false,
	            id: "loginName"
	        },
	        viewrecords:true,
		 	multiselect: true,
		 	caption:'AD'+i18n['caption_userGrid'],
		 	rowNum:10,
		   	rowList:[10,20,30],
		   	pager: '#adPager',
		   	hidegrid:false,
		   	toolbar: [true,"top"]
		})
		.navGrid('#adPager',{edit:false,add:false,del:false,search:false,refresh:true});
		
		$("#t_adGrid").css(jqGridTopStyles);
		
		$("#t_adGrid").append($('#adGridToolbar').html());
	}
	
	/**
	 * @description 角色加载.
	 */
	this.mydata = new Array();
	this.roleLoad=function(){
		$.post("role!findByState.action",function(data){
			mydata=data;
			$("#roleSet table").empty();
			this.roleHtml;
			roleHtml="";
			for(var i=0;i<mydata.length;i++)
			{								
				if(i % 2==0){
					roleHtml=roleHtml+"<tr>"
				}
				roleHtml=roleHtml+"<td><input type='checkbox' class='userRoleId1'";
				roleHtml=roleHtml+" value='"+mydata[i].roleId+"' />"+mydata[i].roleName+"</td>"
			}
			$("#roleSet table").html(roleHtml);
		},"json")
	}
	
	
	/**
	 * @description 从新加载LDAP用户.
	 */
	this.LDAPList=function(id){
		$('#ldapId1').val(id);
		var sdata=$('#searchAdUser form').getForm();
		var postData = $("#adGrid").jqGrid("getGridParam", "postData");
		$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
		var _url = 'ldap!getADByLDAP.action';		
		$('#adGrid').jqGrid('setGridParam',{url:_url})
			.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
		return false;
	}
	/**
	 * @description 加载页面编辑窗口显示
	 * */
	this.webShow=function(){
		$('#userImport').attr("style","width:400px;height:350px;");
	}
	/**
	 * @description 页面事件
	 */
	this.webEvent=function(){
		
		/**
		 * 导入
		 */
		$('#link_user_import').click(function(){
			
			var rowIds = jQuery("#adGrid").jqGrid('getGridParam','selrow');
			if(rowIds==null)
			{
				msgAlert(i18n['plaseSelectOptInfo'],'info');
			}else
			{
				roleId="";	
				$("#roleSet table").html("");
				roleLoad();
				$('#userImport').window('open');
			}
		});
		
		
		
		/**
		 * 导入
		 */
		this.roleId;
		$('#link_user_import1').click(function(){
			var orgNo=$('#orgNoAdUser').val()
			if(orgNo=="" || orgNo==null)
			{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['title_user_selectOrg'],'error');
			}else{
				this.sendData;
				sendData="";
				/**
				 * 获取选中的角色
				 */
				roleId="";
				$(".userRoleId1").each(function(){ //由于复选框一般选中的是多个,所以可以循环输出
					if($(this).attr('checked')){
						if(roleId=="")
							roleId='userDto.roleIds='+$(this).val();
						else
							roleId=roleId+"&userDto.roleIds="+$(this).val();
					}
				});
				var rowIds = jQuery("#adGrid").jqGrid('getGridParam','selarrrow');
				rowIds=rowIds+""
				var userIds=rowIds.split(",")
				this.addNumber;
				addNumber=0;
				this.upNumber;
				upNumber=0
				var userState=$("input[name=userState]:checked").val();
				for(var i=0; i<userIds.length;i++){
					
					var data = $("#adGrid").getRowData(userIds[i]);
					sendData="userDto.loginName="+data.loginName+"&userDto.email="+data.email
					+"&userDto.lastName="+data.lastName+"&userDto.firstName="+data.firstName
					+"&userDto.moblie="+data.moblie+"&userDto.phone="+data.phone
					+"&userDto.password="+data.loginName+"&userDto.userState="+userState
					+"&"+roleId+"&userDto.orgNo="+orgNo
					$.post('ldap!adUserImport.action',sendData,function(data){
						var result=data;
						result=result+""
						if(result=='true'){
							addNumber++
						}else
						{
							upNumber++
						}	
						
					})
				}
				setTimeout(function(){
					this.filed=userIds.length-addNumber-upNumber
					$.messager.alert(i18n['importRuselt'],'<br/>'+i18n['opertionTotal']+':'+userIds.length+'，'+i18n['newAdd']+'：'+addNumber+'，'+i18n['update']+':'+upNumber+'，'+i18n['failure']+'：'+filed,'info');
					$('#userImport').window('close');
				},500)
			
			}
		})
		
		/** 
		 * @description 所属机构
		 * */
	this.auUserOrgWin=function()
	{
		load_selectTreeAduser();
		$('#selectTreeAdUser').window('open');
	}
	/**
	 * @description 加载所属机构树
	 * */
	this.load_selectTreeAduser=function ()
	{
		$("#selectTreeAdUserDIV").jstree({
			json_data: {
				ajax: {url : "organization!findAll.action",cache: false}
			},
			plugins : ["themes", "json_data", "ui", "crrm"]

		})
		.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
		.bind('select_node.jstree',selectTreeAdUserNode);
	}
	
	this.selectTreeAdUserNode=function(event, data)
	{
		var orgNo=data.rslt.obj.attr("orgNo");
		var orgName=data.rslt.obj.attr("orgName");
		
		var orgType=data.rslt.obj.attr("orgType");
		if(orgType==null || orgType=="customerPanel" || orgType=="supplierPanel" || orgType=="outerPanel" || orgType=="innerPanel"){
			
		}else{
			$('#orgNameAdUser').val(orgName);
			$('#orgNoAdUser').val(orgNo);
			$('#selectTreeAdUser').window('close');
		}
	 }
		
		/**
		 * 取消
		 */
		$('#link_user_cancel').click(function(){
			$('#userImport').window('close');
		})
		
	}
	
	
	
	
	
	/** 
	 * @description 用户新增、编辑所属机构
	 * */
	this.adImportOrgTree_win=function()
	{
		
		load_adImportOrgTree();
	
		$('#adImportOrgTree').window('open');
		
		initAdImportOrgTab();
		
	}
	/**
	 * @description 加载所属机构树
	 * */
	this.load_adImportOrgTree=function ()
	{
		$("#adImportOrgTreeDiv").bind('loaded.jstree', function(e,data){data.inst.open_all(-1);}).jstree({
			json_data: {
				ajax: {url : "organization!findAll.action",cache: false}
			},
			plugins : ["themes", "json_data", "ui", "crrm"]

		})
		.bind('select_node.jstree',adImportOrgTreeNode);
	}
	
	this.adImportOrgTreeNode=function(event, data)
	{
		
		
		var orgType=data.rslt.obj.attr("orgType");
		

		
		if(orgType=="customerPanel"){
			
			$('#adImportSelectOrg').tabs('select',i18n['common_customer']);
			
			showSelectCustomers_findByCompany(data.rslt.obj.attr("companyNo"));
			
		}
			
		if(orgType=="supplierPanel"){
			
			$('#adImportSelectOrg').tabs('select',i18n['common_supplier']);
			showSelectSupplierGrid_findByCompany(data.rslt.obj.attr("companyNo"));
		}
		
		

		if(orgType==null || orgType=="innerPanel" || orgType=="customerPanel" || orgType=="supplierPanel" || orgType=="company")
		{
			
		}
		else
		{
			var orgNo=data.rslt.obj.attr("orgNo");
			var orgName=data.rslt.obj.attr("orgName");
			
			$('#orgNameAdUser').val(orgName);
			$('#orgNoAdUser').val(orgNo);
			

			$('#adImportOrgTree').window('close');
		}
		

		
		
	 }
	

	
	this.initAdImportOrgTab=function()
	{
		$('#adImportSelectOrg').tabs();
	}
	

	/**
	 * @description 加载客户
	 */
	
	this.showSelectCustomers=function()
	{
		
		$("#adImprotOrgTree_CustomerGrid").jqGrid({	
			url:'customer!findByCompany.action',
			datatype:'json',
			mtype:'post',
			datatype: "json",
			sortable: true, 			  
			autowidth:false,
			jsonReader: {root: "data",records: "totalSize",page: "page",total: "total",repeatitems: false,id: "orgNo"},
			colNames:[i18n['number'],i18n['name'],i18n['telephone'],'','',i18n['check']],
			colModel:[
					  {name:'orgNo',hidden:true},
					  {name:'orgName',width:100,align:'center'},
					  {name:'officePhone',width:80,align:'center'},
					  {name:'orgType',hidden:true},
					  {name:'companyNo',hidden:true},
					  {name:'act', width:80,sortable:false,align:'center'}
					  ],
			pager:'#adImprotOrgTree_CustomerGridPager', 
			rowNum:10, 
			rowList:[5,15,20,30], 
			viewrecords: true, 
			multiselect:false,
			sortname:'orgNo',
			sortorder:'desc',
			height:200,
			width:360,
			cellEdit:false,
			hidegrid:false,
			toolbar: [false,"top"],
			gridComplete: function(){
			var ids = jQuery("#adImprotOrgTree_CustomerGrid").jqGrid('getDataIDs');
			for(var i=0;i < ids.length;i++)
			{
				edit ='<div style="padding:4px">'
						+'<a href="javascript:showSelectCustomers_select()" title="'+i18n['check']+'">'
						+'<img src="../../images/icons/edit.gif"/></a>&nbsp;&nbsp;&nbsp;&nbsp;'
						+'</a></div>'
											
				jQuery("#adImprotOrgTree_CustomerGrid").jqGrid('setRowData',ids[i],{act:edit});
			}	
		}
			
			
		})
		.navGrid('#adImprotOrgTree_CustomerGridPager',{edit:false,add:false,del:false,search:false})
		.navButtonAdd('#adImprotOrgTree_CustomerGridPager',{  
			caption:"",   
			buttonicon:"ui-icon-search",   
			onClickButton: function() {
			
				$('#adImprotOrgTree_searchCustomerGrid').window('open');
			},   
			position:"last"  
		}); 

	}
	
	
	
	this.showSelectCustomers_select=function()
	{
		 var gr = jQuery("#adImprotOrgTree_CustomerGrid").jqGrid('getGridParam','selrow');
		 var rowData=$("#adImprotOrgTree_CustomerGrid").getRowData(gr);
		 

		$('#orgNameAdUser').val(rowData.orgName);
		$('#orgNoAdUser').val(rowData.orgNo);
		
		$('#adImportOrgTree').window('close');
		 
		 
		 
	}
	
	
	/**
	 * @description 搜索客户列表
	 */
	
	this.showSelectCustomers_findByCompany=function(cNo)
	{
		$('#searchSelectCustomerGrid_companyNo').val(cNo);
		
		var sdata = $('#adImprotOrgTree_searchCustomerGrid form').getForm();
		var postData = $("#adImprotOrgTree_CustomerGrid").jqGrid("getGridParam", "postData");     
		
		$.extend(postData, sdata);
		var _url = 'customer!findByCompany.action';		
		
		$('#adImprotOrgTree_CustomerGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');
		
	}
	
	
	this.showSelectCustomers_doSearch=function()
	{
		var sdata = $('#adImprotOrgTree_searchCustomerGrid form').getForm();
		var postData = $("#adImprotOrgTree_CustomerGrid").jqGrid("getGridParam", "postData");       
		$.extend(postData, sdata);
		var _url = 'customer!findByCompany.action';		
		$('#adImprotOrgTree_CustomerGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');
	}
	
	
	/**
	 * @description 供应商列表
	 */
	this.showSelectSupplierGrid=function()
	{
		$("#adImprotOrgTree_SupplierGrid").jqGrid({	
			url:'supplier!findByCompany.action',
			datatype:'json',
			mtype:'post',
			datatype: "json",
			sortable: true, 			  
			autowidth:false,
			jsonReader: {root: "data",records: "totalSize",page: "page",total: "total",repeatitems: false,id: "orgNo"},
			colNames:[i18n['number'],i18n['name'],i18n['telephone'],'','',i18n['operateItems']],
			colModel:[
					  {name:'orgNo',hidden:true},
					  {name:'orgName',index:'orgName',width:100,align:'center'},
					  {name:'officePhone',width:80,align:'center'},
					  {name:'orgType',hidden:true},
					  {name:'companyNo',hidden:true},
					  {name:'act', width:80,sortable:false,align:'center'},
					  ],
			pager:'#adImprotOrgTree_SupplierPager', 
			rowNum:10, 
			rowList:[5,15,20,30], 
			viewrecords: true, 
			multiselect:false,
			sortname:'orgNo',
			sortorder:'desc',
			editurl:'eidt.do',
			width:360,
			height:200,
			cellEdit:false,
			hidegrid:false,
			toolbar: [false,"top"],
			gridComplete: function(){
			var ids = jQuery("#adImprotOrgTree_SupplierGrid").jqGrid('getDataIDs');
			for(var i=0;i < ids.length;i++)
			{
				edit ='<div style="padding:4px">'
						+'<a href="javascript:showSelectSuppliers_select()" title="'+i18n['check']+'">'
						+'<img src="../../images/icons/edit.gif"/></a>&nbsp;&nbsp;&nbsp;&nbsp;'
						+'</a></div>'
											
				jQuery("#adImprotOrgTree_SupplierGrid").jqGrid('setRowData',ids[i],{act:edit});
			}	
		}
			
			
		}).navGrid('#adImprotOrgTree_SupplierPager',{edit:false,add:false,del:false,search:false})
		
		.navButtonAdd('#adImprotOrgTree_SupplierPager',{  
			caption:"",   
			buttonicon:"ui-icon-search",   
			onClickButton: function() {
			
				$('#adImprotOrgTree_searchSelectSupplierGrid').window('open');
			},   
			position:"last"  
		}); 
		

	}
	
	
	
	
	this.showSelectSuppliers_select=function()
	{
		 var gr = jQuery("#adImprotOrgTree_SupplierGrid").jqGrid('getGridParam','selrow');
		 var rowData=$("#adImprotOrgTree_SupplierGrid").getRowData(gr);
		 
		$('#orgNameAdUser').val(rowData.orgName);
		$('#orgNoAdUser').val(rowData.orgNo);
		
		$('#adImportOrgTree').window('close');
		 
	}
	
	
	
	/**
	 * @description 供应商列表
	 */
	
	this.showSelectSupplierGrid_findByCompany=function(cNo)
	{
		$('#searchSelectSupplierGrid_companyNo').val(cNo);
		var sdata = $('#adImportOrgTree_searchSelectSupplierGrid form').getForm();
		var postData = $("#adImportOrgTree_SupplierGrid").jqGrid("getGridParam", "postData");       
		$.extend(postData, sdata);
		var _url = 'supplier!findByCompany.action';		
		$('#adImportOrgTree_SupplierGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');

	}
	
	
	
	this.showSelectSupplierGrid_doSearch=function()
	{
		var sdata = $('#adImprotOrgTree_searchSelectSupplierGrid form').getForm();
		var postData = $("#adImprotOrgTree_SupplierGrid").jqGrid("getGridParam", "postData");       
		$.extend(postData, sdata);
		var _url = 'supplier!findByCompany.action';		
		$('#adImprotOrgTree_SupplierGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');

	}
	
	
	
	
	/////////////////////////////////////////////////////////
	
	
	
	/**
	 * @description 加载页面编辑窗口显示
	 * */
	this.adUserWebShow=function(){
		$('#userImport').attr('style','width:400px;height:350px;')
		$('#adImprotOrgTree_searchCustomerGrid').attr("style","width: 400px; height: 230px; padding: 10px; line-height: 20px;");
		$('#adImprotOrgTree_searchSelectSupplierGrid').attr("style","width: 400px; height: 230px; padding: 10px; line-height: 20px;");
	}

	/**载入**/
	return{
		init:function(){
		
		
			loadLDAP();
			adUserList();
			webEvent();
			webShow();
			adUserWebShow();
		}
	}
}();


/**载入**/
$(document).ready(adUser.init);