 /**  
 * @fileOverview 公司信息设置主函数.
 * @author Van
 * @version 1.0  
 */  
 /**  
 * @author Van  
 * @constructor company
 * @description 公司信息设置主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
var company = function() 
{
	/**
	 * @description 查找公司信息
	 */
	this.findCompanyInfo=function (){
		
		var url = 'organization!findCompany.action';
		$.post(url,function(res){
			
			$('#init_orgName').val($vl(res.orgName));
			$('#init_officeFax').val($vl(res.officeFax));
			$('#init_officePhone').val($vl(res.officePhone));
			$('#init_email').val($vl(res.email));
			$('#init_address').val($vl(res.address));
			$('#init_homePage').val($vl(res.homePage));
			$('#init_logo').val($vl(res.logo));
			$('#showCompanyCompanyLogo').html('<img src="../upload/images/'+res.logo+'" width="30px" height="30px" />');
		});
	}
	
	/**
	 * @description 保存公司信息
	 */
	this.saveCompanyInfo=function (){
		
		
		
		   if($('#companyInfoForm').form('validate')){
			   
				var frm = $('#companyInfoDiv form').serialize();
				var _url = 'organization!mergeCompany.action';
				$.post(_url,frm, function(){
					
					msgShow(i18n['msg_company_companyInfoSetSuccessful'],'show');
					
				});
			   
		   }

	}

	
	/**
	 * @description 邮件连接测试.
	 * @author mars
	 */
	this.emailConnTest=function(){
		//var frmp = $('#MailServerDiv form').serialize();
		startProcess();
		var frmp="emailConnectionDto.smtphost="+$('#smtp_serverAddress').val()+"&emailConnectionDto.smtpport="+$('#smtp_serverPort').val()
		+"&emailConnectionDto.username="+$('#userName').val()+"&emailConnectionDto.password="+$('#password').val()
		+"&emailConnectionDto.pop3host="+$('#pop3_serverAddress').val()+"&emailConnectionDto.pop3port="+$('#pop3_serverPort').val()
		$.post('email!emailConnTest.action',frmp,function(testErrorEncode){
			endProcess();
		switch(testErrorEncode){
			
			case 0: msgShow(i18n['msg_company_connectionSuccessful'],'show'); break;
			case 1: msgShow(i18n['msg_company_pop3connectionFailure'],'show'); break;
			case 2:	msgShow(i18n['msg_company_smtpconnectionFailure'],'show'); break;
			default: msgShow(i18n['msg_company_smtp_pop3connectionFailure'],'show');
			}	
		})
	}
	
	
	
	/**
	 * @description 邮件扫描
	 * @author mars
	 */
	this.scanEmailServer=function(){
		var frmp="emailConnectionDto.smtphost="+$('#smtp_serverAddress').val()+"&emailConnectionDto.smtpport="+$('#smtp_serverPort').val()
		+"&emailConnectionDto.username="+$('#userName').val()+"&emailConnectionDto.password="+$('#password').val()
		+"&emailConnectionDto.pop3host="+$('#pop3_serverAddress').val()+"&emailConnectionDto.pop3port="+$('#pop3_serverPort').val()
		//显示进程
		startProcess();
		$.post('email!scanEmailMessagesByUser.action',frmp,function(result){
			//显示进程
			endProcess();
			if(result){
				msgShow(i18n['msg_company_scansucess'],'show');
			}
			else{
				msgShow(i18n['ERROR_SCANEMAILMESSAGE'],'show');
			}
		})
		
	}
	

	
  //加载
  return {
			init: function() {
				findCompanyInfo();
				
				
				$('#import_company_btn').click(function(){
					
					$('#index_import_excel_window').window('open');
					
					$("#index_import_confirm").unbind(); //清空事件      
					$('#index_import_confirm').click(function(){
						
						
						$.ajaxFileUpload({
				            url:'company!importCompanyInfo.action',
				            secureuri:false,
				            fileElementId:'importFile', 
				            dataType:'json',
				            success: function(data,status){
							
								$('#index_import_excel_window').window('close');
								findCompanyInfo();
				            	msgShow(i18n['msg_company_dataImportSuccessful'],'show');
				            	resetForm('#index_import_excel_window form');
				            	
				            }
				        });
						
					});
					
				});
			}
		}
}();

//载入
$(document).ready(company.init);
