/**  
 * @author Van  
 * @constructor Van
 * @description 客户管理主函数.
 * @date 2010-02-25
 * @since version 1.0 
 */

$package('itsm.security');

itsm.security.customerMain = function() {

	


  return {

		/**
		 * @description 动作格式化.
		 */
		customerGridFormatter:function(cell,opt,data){
			
			return actionFormat('1','1')
			.replace('[edit]','itsm.security.customerMain.editCustomer_openWindow()')
			.replace('[delete]','itsm.security.customerMain.deleteCustomerInLine('+data.orgNo+')');
		},

		
		
		/**
		 * @description 加载客户列表.
		 */
		showCustomerGrid:function(){
			
				var params = $.extend({},jqGridParams, {	
				url:'customer!findByCompany.action',
				caption:i18n['caption_customerGrid'],
				colNames:[i18n['title_customer_name'],i18n['title_customer_phone'],i18n['title_customer_email'],i18n['title_customer_address'],i18n['common_action'],'','','',''],
				colModel:[
						 
						  {name:'orgName',width:100,align:'center'},
						  {name:'officePhone',width:80,align:'center'},
						  {name:'email',width:80,align:'center'},
						  {name:'address',width:150,align:'center'},
						  {name:'act', width:80,align:'center',sortable:false,formatter:itsm.security.customerMain.customerGridFormatter},
						  {name:'orgNo',hidden:true},
						  {name:'officeFax',hidden:true},
						  {name:'orgType',hidden:true},
						  {name:'companyNo',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "orgNo"}),
				sortname:'orgNo',
				pager:'#customerGridPager'
				});
				$("#customerGrid").jqGrid(params);
				$("#customerGrid").navGrid('#customerGridPager',navGridParams);
				//列表操作项
				$("#t_customerGrid").css(jqGridTopStyles);
				$("#t_customerGrid").append($('#customerGridToolbar').html());
				
				//自适应宽度
				setGridWidth("#customerGrid","regCenter",10);
		},
			
		

		/**
		 * @description 新增客户.
		 */
		addCustomer_openWindow:function(){
			
			$('#addCustomer_win').window('open');
		},

		/**
		 * @description 新增客户方法.
		 */
		addCustomer_doAdd:function(){
			
			if($('#addCustomer_form').form('validate')){
			
				var frm = $('#addCustomer_win form').serialize();
				var url = 'customer!save.action';
				$.post(url,frm, function(){
					
					
					$('#addCustomer_win').window('close');
					$('#customerGrid').trigger('reloadGrid');
					

					$('#add_orgName').val('');
					$('#add_officeFax').val('');
					$('#add_officePhone').val('');
					$('#add_email').val('');
					$('#add_addr').val('');
					
					msgShow(i18n['msg_customer_addSuccessful'],'show');
				});
			}
		},
			

		/**
		 * @description 编辑客户.
		 */
		editCustomer_openWindow:function(){
			checkBeforeEditGrid("#customerGrid",function(rowData){
				
				 $('#editCustomer_orgName').val(rowData.orgName);
				 $('#editCustomer_officeFax').val(rowData.officeFax);
				 $('#editCustomer_officePhone').val(rowData.officePhone);
				 $('#editCustomer_email').val(rowData.email);
				 $('#editCustomer_address').val(rowData.address);
				 $('#editCustomer_orgNo').val(rowData.orgNo);
				 $('#editCustomer_companyNo').val(rowData.companyNo);
				 
				 $('#editCustomer_win').window('open');
			});
		},


		/**
		 * @description 提交编辑客户.
		 */
		editCustomer_doEdit:function(){
			
			if($('#editCustomer_form').form('validate')){
				var frm = $('#editCustomer_win form').serialize();
				var url = 'customer!merge.action';
				$.post(url,frm, function(){
					$('#customerGrid').trigger('reloadGrid');
					$('#editCustomer_win').window('close');
					msgShow(i18n['msg_customer_editSuccessful'],'show');
				});
			}
		},

		/**
		 * @description 删除客户.
		 */
		deleteCustomer_tooBar:function(){
			checkBeforeDeleteGrid("#customerGrid",function(rowIds){
				
				var param = $.param({'orgNos':rowIds},true);
				$.post("customer!deleteCustomers.action", param, function(){
					$('#customerGrid').trigger('reloadGrid');
					msgShow(i18n['msg_deleteSuccessful'],'show');
				}, "json");
			});
		},
		
		
		/**
		 * @description 表格行内删除客户方法.
		 */
		deleteCustomerInLine:function(rowId){
		
			confirmBeforeDelete(function(){
				
				var url = "customer!deleteCustomer.action";
				var params = {"orgNo" :rowId};
				$.post(url,params,function (r) {
					$('#customerGrid').trigger('reloadGrid');
					msgShow(i18n['msg_customer_deleteSuccessful'],'show');

				},'json');
			});
		},

		/**
		 * @description 打开搜索客户窗口.
		 */
		searchCustomer_openWindow:function(){
			
			$('#searchCustomerGrid').window('open');
		},
		
		/**
		 * @description 提交执行搜索.
		 */
		searchCustomer_doSearch:function(){
			var _url = 'customer!findByCompany.action';	
			searchGridWithForm('#customerGrid','#searchCustomerGrid',_url);	
		},
		
		/**
		 * 导出数据到Excel
		 */
		exportCustomerData:function(){
			
			var extype=$('#customerGrid_export').val();
			if(extype=="view"){
				itsm.security.customerMain.exportCustomerView();	
			}
			if(extype=="all"){
				
				msgAlert(i18n["msg_dc_comfirmExport"],"question");
			}
			
		},
		
		
		exportCustomerView:function(){
			var sdata = $('#searchCustomerGrid form').getForm();
			
			var csData = $("#customerGrid").jqGrid("getGridParam", "postData");   	
			
			for(i in sdata){    	   	
				if(sdata[i]!=""&&sdata[i]!=null){
					if(i=='queryDto.orgName')$('#exportCustomer_orgName').val(sdata[i]); 
					if(i=='queryDto.officePhone')$('#exportCustomer_officePhone').val(sdata[i]);
					if(i=='queryDto.email')$('#exportCustomer_email').val(sdata[i]);
					if(i=='queryDto.address')$('#exportCustomer_address').val(sdata[i]);
					}
			}
			$('#exportCustomer_sidx').val(csData.sidx);
			$('#exportCustomer_sord').val(csData.sord);
			$('#exportCustomer_page').val(csData.page);
			$('#exportCustomer_rows').val(csData.rows);
			$("#exportCustomerWindow form").submit();
		},
		
		
		/**
		 * 导入数据.
		 */
		importCustomerData:function(){
			
			$('#importCustomerDataWindow').window('open');
		},
		
		/**
		 * @descriptionadd 客户管理导入
		 * */
		importCustomerExcel:function(){
			
				$.ajaxFileUpload({
		            url:'customer!importCustomerData.action',
		            secureuri:false,
		            fileElementId:'importCustomerFile', 
		            dataType:'json',
		            success: function(data,status){
		             	$('#importCustomerDataWindow').window('close');
		            	$('#customerGrid').trigger('reloadGrid'); 
		            	if(data=="-2"){
		            		
							msgShow(i18n['duplicated_customer_names'],'show');
							
						}else if(data=="-1"){

							msgAlert(i18n['msg_dc_fileNotExists'],'error');
							
						}else if(data=="0"){
							
							msgShow(i18n['msg_dc_noEffect'],'show');
							
						}else{
							
							msgShow(i18n['msg_dc_importSuccess'].replace('N',data),'show');
						}
		            }
		        });
			
		},
	  

	  
		init: function() {
			
			//隐显加载图标
			showAndHidePanel('#customerMain_content','#customerMain_loading');
			
			//加载列表
			itsm.security.customerMain.showCustomerGrid();
			
			//客户
			$('#addCustomerBtn').click(itsm.security.customerMain.addCustomer_openWindow);
			$('#addCustomerBtn_OK').click(itsm.security.customerMain.addCustomer_doAdd);
			$('#editCustomerBtn').click(itsm.security.customerMain.editCustomer_openWindow);
			$('#editCustomerBtn_OK').click(itsm.security.customerMain.editCustomer_doEdit);
			$('#deleteCustomerBtn').click(itsm.security.customerMain.deleteCustomer_tooBar);
			$('#searchCustomerBtn').click(itsm.security.customerMain.searchCustomer_openWindow);
			$('#searchCustomerBtn_OK').click(itsm.security.customerMain.searchCustomer_doSearch);
			
			//导入导出
			$('#customerGrid_export').change(itsm.security.customerMain.exportCustomerData);
			$('#customerGrid_import').change(itsm.security.customerMain.importCustomerData);
			$('#customerGrid_doImport').click(itsm.security.customerMain.importCustomerExcel);
			
			
			
			
			
		}
	}
}();


//载入
$(document).ready(itsm.security.customerMain.init);
