/**  
 * @author Van  
 * @constructor resourceMain
 * @description 资源管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.security');

$import('itsm.security.operationGrid');

itsm.security.functionTree = function() {
	

	
	return {
		
		
		
		
		/**
		 * 功能树，带回调函数.
		 */
		functionTreeCallback:function(treeDIV,callback){
			
			$(treeDIV).jstree({
				json_data:{
					ajax: {url : "function!findTree.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]

			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e,data){
				
				callback(e,data);
				
			});
		},
		
		/**
		 * @description 加载功能树结构. #functionTreeDIV
		 */
		showFunctionTree:function(treeDIV){
			
			$(treeDIV).jstree({
				json_data: 
				{
					ajax: {url : "function!findTree.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]

			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',itsm.security.functionTree.selectTreeNode)
			.bind('delete_node.jstree',itsm.security.functionTree.removeTreeNode)
			.bind('move_node.jstree', itsm.security.functionTree.moveTreeNode);
		},
		
		
		/**
		 * @description 点击树节点
		 */
		selectTreeNode:function(event, data){
			
			var obj = data.rslt.obj;
			
			if(obj.attr("resName")!=''){
				
				//编辑面板
				$('#editCurrentFunction_resNo').val(obj.attr("resNo"));
				$('#edit_resName').val(obj.attr("resName"));
				$('#edit_resCode').val(obj.attr("resCode"));
				$('#edit_icon').val(obj.attr("resIcon"));
				$('#edit_resUrl').val(obj.attr("resUrl"));
				
				$('#show_edit_icon').html('<img src="../upload/images/'+obj.attr("resIcon")+'" width="30px" height="30px" />');
				//新增
				$('#add_parentFunctionNo').val(obj.attr("resNo"));
				//新增操作
				$('#operation_functionNo').val(obj.attr("resNo"));
				//搜索项
				$('#search_FunctionNo').val(obj.attr("resNo"));
				//查找当前节点下的列表
				itsm.security.operationGrid.showGridByFunction();
				
			}else{
				
				$('#edit_resName').val("ROOT");
				$('#edit_resCode').val("");
				$('#edit_icon').val("");
				$('#edit_resUrl').val("");
				$('#edit_resNo').val(null);
				$('#add_parentFunctionNo').val("-1");
				//搜索项
				$('#search_FunctionNo').val("-1");
				//查询对应功能的操作
				//selectFunction_showGrid();
				
				itsm.security.operationGrid.showGridByFunction();
			}
			
		},
		
		
		
		/**
		 * @description 删除功能节点
		 */
		removeTreeNode:function(e, data){
			
			var url = "function!deleteFunction.action";
			var params = {"functionDto.resNo" : data.rslt.obj.attr("resNo")};
			$.post(url,params,
				function (r) {
					$('#functionGrid').jqGrid().trigger('reloadGrid');
					msgShow(i18n['msg_operationSuccessful'],'show');
					
				},
				'json'
			);
		},
		
		
		/**
		 * @description 拖拽、复制粘贴节点
		 */
		moveTreeNode:function (e, data) {
			//遍历节点
			data.rslt.o.each(function (i){
				
				var parentFunctionNo="-1";
				var resNo=$(this).attr('resNo').replace('node_','');
				if(data.rslt.np.attr('resNo')!=null){
					parentFunctionNo=data.rslt.np.attr('resNo').replace('node_','');
				}
				var params = {"functionDto.resNo" : resNo,"functionDto.parentFunctionNo":parentFunctionNo};
			   //复制功能
			   if(data.rslt.cy==true){
				   itsm.security.functionTree.moveTreeNode_CopyNode(params);
				   return;
			   }
			   //剪切功能
			   if(data.rslt.cy==null||data.rslt.cy==false){
				   itsm.security.functionTree.moveTreeNode_CutNode(params);
				   return;
			   }  
			});
		},
		
		
		/**
		 * 复制功能树节点.
		 */
		moveTreeNode_CopyNode:function(params){
			
			   var url = "function!copyFunction.action";
				$.post(url,params,
					function (r) 
					{
						$('#functionGrid').jqGrid().trigger('reloadGrid');
						msgShow(i18n['msg_operationSuccessful'],'show');
					},
					'json'
				);
		},

		
		/**
		 * 剪切功能树节点.
		 */
		moveTreeNode_CutNode:function(params){
			
			  var url = "function!cutFunction.action";
				$.post(url,params,
					function (r){
					
						$('#functionGrid').jqGrid().trigger('reloadGrid');
						msgShow(i18n['msg_operationSuccessful'],'show');

					},
					'json'
				);
			
		},
		
		
		/**
		 * @description 选择树
		 * @param windowId 窗口ID
		 * @param functionId 选定后将功能编号赋值到 functionId
		 * @param functionName 选定后将功能名称赋值到 functionId
		 * @param treePanel 树DIV编号
		 */
		showSelectFunctionTree:function(windowId,functionId,functionName,treePanel){
			
			//打开窗口
			$(windowId).window('open');
			
				$(treePanel).jstree({
					json_data: {
						ajax: {url : "function!findTree.action",cache: false}
					},
					plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]

				})
				.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
				.bind('select_node.jstree',function(event, data){
					
					if(functionName!=''){
						$(functionName).val(data.rslt.obj.attr("resName"));
					}
					
					if(functionId!=''){
						$(functionId).val(data.rslt.obj.attr("resNo"));
					}
					
					
					$(windowId).window('close');
					
				});
		}
		

		
		
	};
	

  
}();
