$package('itsm.security')
/**  
 * @author Tan  
 * @constructor ldap
 * @description  LDAP管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
itsm.security.ldap=function(){
	
	this.operator;
	return{
		/**
		 * LDAP动作格式化
		 */
		ladpActionFormatter:function(cell,data,dd){
			return '<a href="javascript:itsm.security.ldap.editLDAP()" title="'+i18n['common_edit']+'">'
			+'<img src="../images/icons/edit.gif" border="0"/></a>&nbsp;&nbsp;&nbsp;'
			+'<a href="javascript:itsm.security.ldap.deleteLDAP()"  title="'+i18n['deletes']+'">'
			+'<img src="../images/icons/delete.gif" border="0"/></a>'
			+'</div>';
		},
		
		/**
		 * @description 加载LDAP列表.
		 */
		ldapList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'ldap!find.action',
				caption:i18n['caption_ldap'],
				colNames:['ID',i18n['common_name'],i18n['title_ldap_ladpServerType'],i18n['title_ldap_server'],i18n['title_ldap_port'],i18n['title_ldap_userName'],i18n['title_ldap_pwd'],'BaseDN',i18n['title_ldap_searchFilter'],i18n['common_action']],
			 	colModel:[
			 	          {name:'ldapId',width:20},
			 	          {name:'ldapName',width:80},
			 	          {name:'ldapType',width:100},
			 	          {name:'ldapURL',width:120},
			 	          {name:'prot',width:30},
			 	          {name:'adminName',width:80},
			 	          {name:'adminPassword',hidden:true},
			 	          {name:'searchBase',width:80},
			 	          {name:'searchFilter',width:80},
			 	          {name:'act', width:50,align:'center',formatter:itsm.security.ldap.ladpActionFormatter}
			 	],
				jsonReader: $.extend(jqGridJsonReader, {id: "ldapId"}),
				sortname:'ldapId',
				pager:'#ldapPager'
			});
			$("#ldapGrid").jqGrid(params);
			$("#ldapGrid").navGrid('#ldapPager',navGridParams);
			//列表操作项
			$("#t_ldapGrid").css(jqGridTopStyles);
			$("#t_ldapGrid").append($('#ldapTopMenu').html());
			
			//自适应宽度
			setGridWidth("#ldapGrid","regCenter",10);
		},
		
		/**
		 * @description 新增LDAP.
		 */
		
		addLDAP:function(){
			
			if($('#ldapForm').form('validate')){
			
				var ldap_form = $('#ldapData form').serialize();
				var url = 'ldap!'+operator+'.action';
				$.post(url, ldap_form, function(){
					$('#addLdap').window('close');
					$('#ldapGrid').trigger('reloadGrid');
				});
			
			}
		},
		
		/**
		 * @description 新增窗口.
		 */
		ldap_add_win:function(){
			$('#ldapConfigError').text("");
			$("#ldapData form")[0].reset();
			$('#addLdap').window('open');
			operator = 'save';
			
		},
		/**
		 * @description 编辑LDAP.
		 */
		editLDAP:function(){
	
			checkBeforeEditGrid('#ldapGrid',function(data){
				resetForm("#ldapForm");
				operator = 'mergeLdap';
				$('#ldapId').val(data.ldapId);
				$('#ldapName').val(data.ldapName);
				$('#ldapType').val(data.ldapType);
				$('#ldapURL').val(data.ldapURL);
				$('#prot').val(data.prot);
				$('#adminName').val(data.adminName);
				$('#adminPassword').val(data.adminPassword);
				$('#searchBase').val(data.searchBase);
				$('#searchFilter').val(data.searchFilter);
				$('#ldapConfigError').text("");
				$('#addLdap').window('open');
			});
		},
		
		
		/**
		 * @description 删除LDAP.
		 */
		deleteLDAP:function(){
			checkBeforeDeleteGrid('#ldapGrid',function(rowIds){
				var pp = $.param({'ids':rowIds},true);
				$.post("ldap!delete.action", pp, function(){
					$('#ldapGrid').trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'show');
				}, "json");
				
			});
		},
		 
		/**
		 * @description 搜索
		 */
		searchLdap:function(){
			var sdata=$('#searchLdap form').getForm();
			var postData = $("#ldapGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata); 
			
			var _url = 'ldap!find.action';		
			$('#ldapGrid').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
			return false;
			
		},
		
		connTest:function(){
			var pp="ldapCheckDto.ldapURL="+$('#ldapURL').val()+
			"&ldapCheckDto.prot="+$('#prot').val()+
			"&ldapCheckDto.adminName="+$('#adminName').val()+
			"&ldapCheckDto.adminPassword="+$('#adminPassword').val()+
			"&ldapCheckDto.searchFilter="+$('#searchFilter').val()+
			"&ldapCheckDto.searchBase="+$('#searchBase').val()+
			"&ldapCheckDto.ldapType="+$('#ldapType').val();
			$('#ldapConfigError').text(i18n['label_ldap_connection']);
			$.post('ldap!ldapConfigCheck.action',pp,function(data){
				if(data){
					$('#ldapConfigError').text(i18n['label_ldap_connectionSuccessful']);
				}	
				else{
					$('#ldapConfigError').text(i18n['label_ldap_paramError']);
				}	
			},"json")
		},
	
	
		init:function(){
			
			
			 $("#ldapMain_loading").hide();
			 $("#ldapMain_content").show();
			
			 itsm.security.ldap.ldapList();
			
			//添加
			$('#link_ldap_add').click(itsm.security.ldap.ldap_add_win);
			$('#link_ldap_save').click(itsm.security.ldap.addLDAP);
			
			//编辑
			$('#link_ldap_edit').click(itsm.security.ldap.editLDAP)
			
			//删除
			$('#link_ldap_delete').click(itsm.security.ldap.deleteLDAP)
			
			//打开搜索窗口
			$('#link_ldap_search').click(function(){$('#searchLdap').window('open');})
			
			//开始搜索
			$('#link_start_search').click(function(){itsm.security.ldap.searchLdap();});
			
			//连接测试
			$('#link_conn_test').click(itsm.security.ldap.connTest);
			
		}
	}
}();

/**载入**/
$(document).ready(itsm.security.ldap.init);