/**  
 * @author Van  
 * @constructor resourceMain
 * @description 资源管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
$package('itsm.security');

itsm.security.operationGrid = function() {
	
	
	return {
		
		
		/**
		 * @description 图标格式化.
		 */
		iconFormatter:function(cell,opt,data){
		
			if(data.resIcon==""){
				return i18n['label_resource_notUpload'];
			}else{
				
				return "<div style='border:#ddd 1px solid;padding:1px;width:20px;height:20px'><img src='../upload/images/"+data.resIcon+"' width='20px' height='20px' /></div>";
			}
		},
	
		/**
		 * @description  格式化操作
		 */
		operationGridFormatter:function(cell,opt,data){
			
			return '<div style="padding:5px">'+
			'<img style="cursor:pointer" src="../images/icons/edit.gif" onclick="itsm.security.operationGrid.editInLine('+opt.rowId+')"/>'+
			'<img style="margin-left:8px;cursor:pointer" src="../images/icons/delete.gif" onclick="itsm.security.operationGrid.deleteOperation('+data.resNo+')"/>'+
			'</div>';
			
		},
		
		
		/**
		 * @description  加载操作列表
		 */
		showOperationGrid:function()
		{
			
			var params = $.extend({},jqGridParams, {	
				url:'operation!find.action',
				caption:i18n['caption_operationGrid'],
				colNames:[i18n['title_resource_code'],i18n['common_name'],i18n['title_resource_icon'],i18n['title_resource_url'],i18n['common_action'],'',''],
				colModel:[
						  {name:'resCode',width:20,align:'center'},
						  {name:'resName',width:15,align:'center'},
						  {name:'resIconPanel',width:15,align:'center',formatter:itsm.security.operationGrid.iconFormatter},
						  {name:'resUrl',width:30,align:'center'},
						  {name:'act', width:20,align:'center',formatter:itsm.security.operationGrid.operationGridFormatter},
						  {name:'resNo',hidden:true},
						  {name:'resIcon',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "resNo"}),
				sortname:'resNo',
				pager:'#operationPager'
				});
				$("#operationGrid").jqGrid(params);
				$("#operationGrid").navGrid('#operationPager',navGridParams);
				//列表操作项
				$("#t_operationGrid").css(jqGridTopStyles);
				$("#t_operationGrid").append($('#operationToolbar').html());
				
				//自适应宽度
				setGridWidth('#operationGrid', 'resourceTabMain', 10);
				
				resourceGrids.push('#operationGrid');
			
		},
	
	
	
		/**
		 * @description 打开新增操作窗口.
		 */
		openAddOperationWindow:function (){
	
			if(itsm.security.operationGrid.validateParentFunction()){
				$('#addOperation_win').window('open');
			}
		},
		
		/**
		 * @description Close add operation window.
		 */
		addOperation_closewindow:function(){
			
			$('#addOperation_win').window('close');		
		},
		
		
		
		/**
		 * 验证是否选择功能节点.
		 */
		validateParentFunction:function(){
			
			var functionNo=$('#operation_functionNo').val();
			
			if(functionNo==null || functionNo==""){
				msgAlert(i18n['msg_chooseFunction'],'error');
				return false;
			}else{
				return true;
			}
		},
		
		
	
		/**
		 * @description Do add operation.
		 */
		addOperation:function (){
			
	
			if(itsm.security.operationGrid.validateParentFunction() && $('#addOperationForm_win').form('validate')){
				
					
				//验证资源名称
				var resName=$('#opeartion_resName').val();
				 var url_resName="operation!findOperationExist.action?operationQueryDto.resName="+resName;
				
				 $.post(url_resName,function(res){
					 
					if(res==true){
						
						msgAlert(i18n['msg_resource_operationNameExist'],'info');
						return;
						
					}else{
						
						//验证资源编码 start
						
						var resCode=$('#opeartion_resCode').val();
						var url_resCode="operation!findOperationExist.action?operationQueryDto.resCode="+resCode;
						
						 //判断操作编码
						 $.post(url_resCode,function(res){
							 
								if(res==true){
									msgAlert(i18n['msg_resource_operationCodeExist'],'info');
									return;
									
								}else{
	
									//判断资源地址 start
									var resUrl=$('#opeartion_resUrl').val();
									var url_resUrl="operation!findOperationExist.action?operationQueryDto.resUrl="+resUrl;
									
									 //判断操作编码
									 $.post(url_resUrl,function(res){
										 
											if(res==true){
												
												msgAlert(i18n['msg_resource_functionUrlExist'],'info');
												return;
												
											}else{
												
												
												//开始新增
												 var frm = $('#addOperation_win form').serialize();
												 var url = 'operation!addOperation.action';
												 $.post(url,frm, function(){
													 
													 	$('#addOperation_win').window('close');
														$('#operationGrid').trigger('reloadGrid');//刷新列表
														resetForm("#addOperationForm_win");
														$('#show_opicon').html("");
														msgShow(i18n['addSuccess'],'show');
														
												 });
												
												
											}
										 
									 });
									
									//判断资源地址end
									
								}
							 
						 });
						
						
						//验证资源编码 end
						
						
					}
					 
				 });
				
				
	
			}
	
		},
		
	
	
		
		
	
		/**
		 * @description 编辑操作
		 */
		openEditOperationWindow:function(){
			
			checkBeforeEditGrid("#operationGrid",function(rowData){
				 //填充数据
				itsm.security.operationGrid.editFillData(rowData);
			});
		},
	
		
		/**
		 * 行内编辑
		 */
		editInLine:function(rowId){
			
			var rowData=$('#operationGrid').getRowData(rowId);
			itsm.security.operationGrid.editFillData(rowData);
			
		},
		
		/**
		 * 填充数据.
		 */
		editFillData:function(rowData){
			
			 $('#edit_opeartion_resName').val(rowData.resName);
			 $('#edit_opeartion_resCode').val(rowData.resCode);
			 $('#edit_opeartion_resIcon').val(rowData.resIcon);
			 $('#edit_opeartion_resNo').val(rowData.resNo);
			 $('#edit_opeartion_resUrl').val(rowData.resUrl);
			 $('#show_editOpeartion_resIcon').html('<img src="../upload/images/'+rowData.resIcon+'" width="30px" height="30px" />');
			 $('#editOperation_win').window('open');
		},
		
		
		/**
		 * @description 关闭编辑窗口
		 */
		closeEditOperationWindow:function(){
			$('#editOperation_win').window('close');
		},
		
		/**
		 * @description 编辑操作
		 */
		editOperation:function (){
			
			if($('#editOperationForm_win').form('validate')){
				var url = 'operation!updateOperation.action';
				submitFormCommon("#editOperation_win",url,function(r){
					
					var sdata = {functionNo: $('#operation_functionNo').val()+"" };   
					var postData = $("#operationGrid").jqGrid("getGridParam", "postData");  
					$.extend(postData,sdata); //传入值	
					$('#operationGrid').trigger('reloadGrid');
					itsm.security.operationGrid.closeEditOperationWindow();
					msgShow(i18n['editSuccess'],'show');
					
				});
			}
		},
		
		/**
		 * @description 删除操作
		 */
		deleteOperations:function(){
			
			checkBeforeDeleteGrid("#operationGrid",function(rowIds){
				
				var param = $.param({'resNos':rowIds},true);
				$.post("operation!deleteOperations.action", param, function(){
						$('#operationGrid').trigger('reloadGrid');
						msgShow(i18n['msg_deleteSuccessful'],'show');
				}, "json");
				
			});
		},
	
		/**
		 * @description 行内删除操作.
		 */
		deleteOperation:function(rowId){
			
			confirmBeforeDelete(function(){
				
				var param = $.param({'operationDto.resNo':rowId},true);
				$.post("operation!deleteOperation.action", param, function(data){

					if(data){
						
						$('#operationGrid').trigger('reloadGrid');
						msgShow(i18n['msg_deleteSuccessful'],'show');
					}
					else{
						
						msgAlert(i18n['msg_canNotDeleteSystemData'],'info');
					}	
					
				}, "json");
				
				
			});


		},
	
		/**
		 * @description 打开搜索窗口.
		 */
		openSearchOperationWindow:function(){
			$('#searchOperation_win').window('open');
		},
	
		/**
		 * @description 搜索操作.
		 */
		searchOperation:function(){
			
			var sdata = $('#searchOperation_win form').getForm();
			var postData = $("#operationGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);
			
			var _url = 'operation!find.action';		
			$('#operationGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');
			
		},
	
		/**
		 * @description 根据功能显示操作列表.
		 */
		showGridByFunction:function(){
			
			$('#search_operationQueryDto_resName').val('');
			$('#search_operationQueryDto_resCode').val('');
			$('#search_operationQueryDto_resUrl').val('');
			var sdata = $('#searchOperation_win form').getForm();
			var postData = $("#operationGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);
			var _url = 'operation!find.action';		
			$('#operationGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');
			
		},
		
		/**
		 * 导出数据
		 */
		exportData:function(){
			
			var searchData = $('#searchOperation_win form').getForm();
			var gridData = $("#operationGrid").jqGrid("getGridParam", "postData");   
			
			for(i in searchData){    	   	
				
				if(searchData[i]!="" && searchData[i]!=null){
					if(i=='operationQueryDto.resName'){$('#exportOperation_resName').val(searchData[i]);}
					if(i=='operationQueryDto.resCode'){$('#exportOperation_resCode').val(searchData[i]);}
					if(i=='operationQueryDto.resUrl'){$('#exportOperation_resUrl').val(searchData[i]);}
					if(i=='functionNo'){$('#exportOperation_functionNo').val(searchData[i]);}
				}
			}
			
			$('#exportOperation_page').val(gridData.page);
			$('#exportOperation_rows').val(gridData.rows);
			$('#exportOperationForm').submit();
			
		},
		
		/**
		 * 导入数据.
		 */
		importData:function(){

			importCSV('operation!importOperation.action',function(){
				$('#index_import_excel_window').window('close');
				$('#operationGrid').trigger('reloadGrid');
	        	msgShow(i18n['msg_dc_dataImportSuccessful'],'show');
	        	resetForm('#index_import_excel_window form');
			});

		},
		
		
		/**
		 * 载入
		 */
		init:function(){
			
			//加载列表
			itsm.security.operationGrid.showOperationGrid();
			
			//事件
			$('#operationGrid_add').click(itsm.security.operationGrid.openAddOperationWindow);
			$('#operationGrid_edit').click(itsm.security.operationGrid.openEditOperationWindow);
			$('#operationGrid_delete').click(itsm.security.operationGrid.deleteOperations);
			$('#operationGrid_search').click(itsm.security.operationGrid.openSearchOperationWindow);
			
			$("#addOperationBtn_OK").click(itsm.security.operationGrid.addOperation);
			$("#editOperationBtn_OK").click(itsm.security.operationGrid.editOperation);
			$("#searchOperationBtn_OK").click(itsm.security.operationGrid.searchOperation);
			
			
			//导出
			$('#exportOperation').click(itsm.security.operationGrid.exportData);
			
			//导入
			$('#importOperation').click(function(){
				readyImportCSV(itsm.security.operationGrid.importData);
			});
			
		}

	};
	
}();
