/**  
 * @author Van  
 * @constructor Van
 * @description 机构列表视图函数
 * @date 2011-02-25
 * @since version 1.0 
 * @param {Num} organizationGridOperationFlag 动作标识 
 */
$package('itsm.security');
$import('itsm.security.organizationTree');

itsm.security.organizationGrid= function() {
	
	/**
	 * 动作标识.
	 */
	this.organizationGridOperationFlag='';
	
	this.treeType="inner";
		
	return {
		
		/**
		 * @description 动作格式化.
		 */
		orgGridFormatter:function(cell,opt,data){
			
			//alert($.toJSON(opt));
			
			return actionFormat('1','1')
			.replace('[edit]','itsm.security.organizationGrid.editOrganizationInLine('+opt.rowId+')')
			.replace('[delete]','itsm.security.organizationGrid.deleteOrg('+data.orgNo+')');

		},
		
		/**
		 * @description 显示机构列表.
		 */
		showGrid:function(){

			var params = $.extend({},jqGridParams, {
				url:'organization!find.action',
				caption:i18n['caption_org'],
				colNames:[i18n['common_name'],i18n['common_phone'],i18n['common_email'],i18n['common_address'],i18n['common_action'],'','','','','','','','',''],
				colModel:[
						  {name:'orgName',width:100,align:'center'},
						  {name:'officePhone',width:80,align:'center'},
						  {name:'email',width:80,align:'center'},
						  {name:'address',width:150,align:'center'},
						  {name:'act', width:50,align:'center',formatter:itsm.security.organizationGrid.orgGridFormatter},
						  {name:'officeFax',hidden:true},
						  {name:'homePage',hidden:true},
						  {name:'logo',hidden:true},
						  {name:'orgType',hidden:true},
						  {name:'parentNo',hidden:true},
						  {name:'parentOrgName',hidden:true},
						  {name:'personInChargeName',hidden:true},
						  {name:'personInChargeNo',hidden:true},
						  {name:'orgNo',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "orgNo"}),
				sortname:'orgNo',
				pager:'#orgGridPager'
				});
				$("#orgGrid").jqGrid(params);
				$("#orgGrid").navGrid('#orgGridPager',navGridParams);
				//列表操作项
				$("#t_orgGrid").css(jqGridTopStyles);
				$("#t_orgGrid").append($('#orgGridToolbar').html());
				//自适应宽度
				setGridWidth("#orgGrid","organizationMainTab",10);
				organizationGrids.push('#orgGrid');
		},
		
		
		/**
		 * @description 打开新增窗口.
		 */
		addOrganizationOpenWindow:function (){
			
			organizationGridOperationFlag="save";
			$('#organizationWindow').window({'title':i18n['title_org_addOrg']});
			$('#organizationWindow').window('open');
		},
		
		/**
		 * @description 进行添加操作.
		 */

		saveOrganization:function (){
			var uname=$('#organizationDto_personInChargeName_gridAdd').val();
			
			if(uname!=''){
				
				//查看用户是否存在
				checkUserByName(uname,itsm.security.organizationGrid.saveOrganizationMethod);
				
			}else{
				itsm.security.organizationGrid.saveOrganizationMethod('');
			}
		},
		
		saveOrganizationMethod:function(userId){
			
			if($('#organizationWindowForm').form('validate')){
			
				$('#organizationDto_personInChargeNo_gridAdd').val(userId);
				
				var frm = $('#organizationWindow form').serialize();
				var url = 'organization!'+organizationGridOperationFlag+'.action';
				$.post(url,frm, function(){
					
					$('#organizationWindow').window('close');
					
					
					var msg=i18n['msg_org_orgAddSuccessful'];
					
					if(organizationGridOperationFlag=='updateOrgWin'){
						msg=i18n['msg_org_orgEditSuccessful'];
					}
					
					$('#orgGrid').trigger('reloadGrid');
					
					
					itsm.security.organizationTree.loadOrganizationTreeView('#orgTreeDIV');//重新载入树结构
					
					loadTreeView('#selectTreeDIV','organization!findAll.action',itsm.security.organizationGrid.selectTreeNode);


					resetForm("#organizationWindowForm");
					
					$('#orgWindow_orgType').val('inner');
					
					msgShow(msg,'show');
					
				});

			}
		},
		

		/**
		 * @description 打开编辑窗口.
		 */
		editOrganizationOpenWindow:function (){
			
			checkBeforeEditGrid("#orgGrid",itsm.security.organizationGrid.editOrgMethod);
		},
		
		/**
		 * 行内编辑
		 */
		editOrganizationInLine:function(rowId){
			
			var rowData=$('#orgGrid').getRowData(rowId);
			itsm.security.organizationGrid.editOrgMethod(rowData);
		},
		
		/**
		 * @description 编辑机构方法.
		 */
		editOrgMethod:function(rowData){
			
			 $('#orgWindow_orgNo').val(rowData.orgNo);
			 $('#orgWindow_orgName').val(rowData.orgName);
			 $('#orgWindow_officeFax').val(rowData.officeFax);
			 $('#orgWindow_officePhone').val(rowData.officePhone);
			 $('#orgWindow_email').val(rowData.email);
			 $('#orgWindow_address').val(rowData.address);

			 $('#orgWindow_parentOrgName').val(rowData.parentOrgName);
			 $('#orgWindow_parentOrgNo').val(rowData.parentOrgNo);
			 
			 $('#organizationDto_personInChargeName_gridAdd').val(rowData.personInChargeName);
			 $('#organizationDto_personInChargeNo_gridAdd').val(rowData.personInChargeNo);

			 if(rowData.parentNo==""){
				 $('#orgWindow_parentOrgNo').val("1");
			 }
			 else{
				 
				 $('#orgWindow_parentOrgNo').val(rowData.parentNo);
			 }
			 
			 if(rowData.orgNo=="1"){
				 
				$('#orgWindow_parentOrgName').val(i18n['msg_org_isTheRoot']);
				$('#orgWindow_parentOrgName').attr("disabled",true)//将input元素设置为disabled
				
				$("#orgWindow_orgType>option[value='services']").remove();
				$("#orgWindow_orgType>option[value='inner']").remove();
				$("<option value='company'>"+i18n['label_org_companyInfo']+"</option>").appendTo("#orgWindow_orgType");
				
			 }else{
				 
				 
				 $("#orgWindow_orgType>option").remove();
				 
				 $('#orgWindow_parentOrgName').attr("disabled","")//将input元素设置为disabled
				 
				 if(rowData.orgType=="inner"){
					 
					 treeType="inner";
					 
					 $("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#orgWindow_orgType");
				 }
				 if(rowData.orgType=="services"){
					 
					 treeType="services";
					 
					 $("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#orgWindow_orgType");
					 
				 }
			 }

			 organizationGridOperationFlag="updateOrgWin";
			 $('#organizationWindow').window({'title':i18n['title_org_editOrg']});
			 $('#organizationWindow').window('open');
		},

		/**
		 * @description 删除机构.
		 */
		deleteOrgs:function(){
			checkBeforeDeleteGrid("#orgGrid",itsm.security.organizationGrid.deleteOrgMethod);
		},
		
		/**
		 * @description 删除机构Method.
		 */
		deleteOrgMethod:function(rowIds){
			
			var param = $.param({'orgNos':rowIds},true);
			$.post("organization!deleteOrgs.action", param, function()
			{
				$('#orgGrid').trigger('reloadGrid');
				itsm.security.organizationTree.loadOrganizationTreeView('#orgTreeDIV');//重新载入树结构
				
				loadTreeView('#selectTreeDIV','organization!findAll.action',itsm.security.organizationGrid.selectTreeNode);
				msgShow(i18n['msg_deleteSuccessful'],'show');
				
			}, "json");
		},
		

		/**
		 * @description 删除机构InLineMethod.
		 */
		deleteOrg:function(rowId){
						
			confirmBeforeDelete(function(){
				
				var url = "organization!remove.action";
				var params = {"orgNo" :rowId};
				$.post(url,params,function (r) {
						
							$('#orgGrid').trigger('reloadGrid');
							itsm.security.organizationTree.loadOrganizationTreeView('#orgTreeDIV');//重新载入树结构
							loadTreeView('#selectTreeDIV','organization!findAll.action',itsm.security.organizationGrid.selectTreeNode);
							msgShow(i18n['msg_deleteSuccessful'],'show');
							
					},'json');
			});

		},

		
		/**
		 * @description 搜索机构.
		 */
		searchOrg_openwindow:function(){
			$('#searchOrg_win').window('open');
		},
		

		/**
		 * @description 搜索机构Method.
		 */
		searchOrg:function(){
			
			var _url = 'organization!find.action';	
			searchGridWithForm('#orgGrid','#searchOrg_win',_url);

		},
		
		
		/**
		 * @description 选择树.
		 */
		selectParentOrganization:function(){
			
			$('#selectTree').window('open');
			loadTreeView('#selectTreeDIV','organization!findAll.action',itsm.security.organizationGrid.selectTreeNode);
			
		},
		
		
		/**
		 * @description 选择节点.
		 */
		selectTreeNode:function(event, data){

			
			var orgNo=data.rslt.obj.attr("orgNo");
			var orgName=data.rslt.obj.attr("orgName");
			
			$('#orgWindow_parentOrgName').val(orgName);
			$('#orgWindow_parentOrgNo').val(orgNo);
			
			var orgType=data.rslt.obj.attr("orgType");

			if(orgType=="inner"||orgType=="innerPanel"){

				$("#orgWindow_orgType>option[value='inner']").remove();
				$("#orgWindow_orgType>option[value='services']").remove();
				$("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#orgWindow_orgType");
			}
			
			if(orgType=="services"||orgType=="servicesPanel"){

				$("#orgWindow_orgType>option[value='inner']").remove();
				$("#orgWindow_orgType>option[value='services']").remove();
				$("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#orgWindow_orgType");
			}
			
			
			if(orgType=="ROOT"||orgType=="company"){
				
				$("#orgWindow_orgType>option[value='inner']").remove();
				$("#orgWindow_orgType>option[value='services']").remove();
				
				$("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#orgWindow_orgType");
				$("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#orgWindow_orgType");
			}
		
			$('#selectTree').window('close');
		},
		
		/**
		 * 导出数据.
		 */
		exportOrganization:function(){
			
			var searchData = $('#searchOrg_win form').getForm();
			var gridData = $("#orgGrid").jqGrid("getGridParam", "postData");   
			
			for(i in searchData){    	   	
				
				if(searchData[i]!="" && searchData[i]!=null){
					
					if(i=='organizationQueryDto.orgName')
						$('#exportOrganization_orgName').val(searchData[i]);
					if(i=='organizationQueryDto.officePhone')
						$('#exportOrganization_officePhone').val(searchData[i]);
					if(i=='organizationQueryDto.address')
						$('#exportOrganization_address').val(searchData[i]);
				}
			}

			$('#exportOrganization_sidx').val(gridData.sidx);
			$('#exportOrganization_sord').val(gridData.sord);
			$('#exportOrganization_page').val(gridData.page);
			$('#exportOrganization_rows').val(gridData.rows);
			
			$('#exportOrganizationForm').submit();
		},
		
		doImport:function(){
			
			$.ajaxFileUpload({
	            url:'organization!importOrganization.action',
	            secureuri:false,
	            fileElementId:'importFile', 
	            dataType:'json',
	            success: function(data,status){
					$('#index_import_excel_window').window('close');
					$('#orgGrid').trigger('reloadGrid');
	            	msgShow(i18n['msg_dc_dataImportSuccessful'],'show');
	            	resetForm('#index_import_excel_window form');
	            }
	      });
			
		},

		
		init:function(){
			
			//加载机构列表
			itsm.security.organizationGrid.showGrid();
			
			$('#organizationExport').click(itsm.security.organizationGrid.exportOrganization);//导出数据
			
			//导入数据
			$('#organizationImport').click(function(){
				$('#index_import_excel_window').window('open');
				$("#index_import_confirm").unbind(); //清空事件      				
				$('#index_import_confirm').click(itsm.security.organizationGrid.doImport);
			});
			
			//绑定事件			
			$('#organizationGrid_add').click(itsm.security.organizationGrid.addOrganizationOpenWindow);
			$('#organizationGrid_edit').click(itsm.security.organizationGrid.editOrganizationOpenWindow);
			$('#organizationGrid_delete').click(itsm.security.organizationGrid.deleteOrgs);
			$('#organizationGrid_search').click(itsm.security.organizationGrid.searchOrg_openwindow);
			
			$("#saveOrganizationBtn").click(itsm.security.organizationGrid.saveOrganization);
			//搜索机构
			$("#searchOrgBtn_OK").click(itsm.security.organizationGrid.searchOrg);
			
			//选择父节点
			$('#orgWindow_parentOrgName').click(itsm.security.organizationGrid.selectParentOrganization);

		}
		
		
	};
	
	
}();


