/**  
 * @author Van  
 * @constructor Van
 * @description 节假日设置主函数.
 * @date 2011-02-25
 * @since version 1.0 
 * @param {Num} holidayOperation 动作  
 */
$package('itsm.security');

itsm.security.organizationHoliday = function() {
	

	
	//动作
	this.holidayOperation="";

	
	return {
		
		
		
		/**
		 * @description 动作格式化.
		 */
		holidayGridFormatter:function(cell,opt,data){
			
			return actionFormat('1','1')
			.replace('[edit]','itsm.security.organizationHoliday.editHolidayOpenwindow()')
			.replace('[delete]','itsm.security.organizationHoliday.deleteHolidayInLine('+data.hid+')');
		},
		
		
		/**
		 * @description 加载节假日列表.
		 */
		showHoliday:function() {
			
			var params = $.extend({},jqGridParams, {	
				url:'holiday!findHolidayPage.action',
				caption:i18n['caption_holiday'],
				colNames:[i18n['common_id'],i18n['common_date'],i18n['common_desc'],i18n['common_action']],
				colModel:[
						  {name:'hid',hidden:true,align:'center'},
						  {name:'hdate',width:100,align:'center',formatter:timeFormatter},
						  {name:'hdesc',width:80,align:'center'},
						  {name:'act', width:80,align:'center',formatter:itsm.security.organizationHoliday.holidayGridFormatter}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "hid"}),
				sortname:'hid',
				pager:'#holidayGridPager'
			});
			$("#holidayGrid").jqGrid(params);
			$("#holidayGrid").navGrid('#holidayGridPager',navGridParams);
			//列表操作项
			$("#t_holidayGrid").css(jqGridTopStyles);
			$("#t_holidayGrid").append($('#holidayGridToolbar').html());
			
			//自适应宽度
			setGridWidth('#holidayGrid', 'organizationMainTab', 10);
			
			organizationGrids.push('#holidayGrid');

		},
		
		

		/**
		 * @description 打开新增节假日窗口.
		 */
		addHolidayOpenwindow:function(){

			
			var holiday_orgNo=$("#hoilday_orgNo").val();
			
			if(holiday_orgNo==""){
				
				msgAlert(i18n['msg_chooseOrg'],'info');
				
			}else{
				
				holidayOperation="addHoliday";
				$('#addHolidayWindow').window({title: i18n['title_holiday_add']});
				$('#saveHolidayBtn').linkbutton({text:i18n['common_saveAdd'],iconCls:'icon-ok'});
				$('#addHolidayWindow').window('open');
			}

			
		},
		
		
		/**
		 * @description 打开编辑节假日窗口.
		 */
		editHolidayOpenwindow:function(){
			checkBeforeEditGrid("#holidayGrid",itsm.security.organizationHoliday.editHolidayMethod);
		},
		
		
		
		/**
		 * @description 提交编辑节假日.
		 */
		editHolidayMethod:function(rowData){
			
			 //填充数据
			 $('#hoilday_hdate').val(timeFormatter(rowData.hdate,'',''));
			 $('#hoilday_hedate').val(timeFormatter(rowData.hdate,'',''));
			 $('#hoilday_hdesc').val(rowData.hdesc);
			 $('#hoilday_hid').val(rowData.hid);
			 
			 
			holidayOperation="updateHoliday";
			
			$('#saveHolidayBtn').linkbutton({text:i18n['common_saveEdit'],iconCls:'icon-save'});
			
			$('#addHolidayWindow').window({title: i18n['title_holiday_edit']});
			$('#addHolidayWindow').window('open');
			
		},

		
		/**
		 * @description 保存节假日.
		 */
		saveHoliday:function(){
		

			if($('#holidayForm').form('validate')){
				var frm = $('#addHolidayWindow form').serialize();
				var url="holiday!"+holidayOperation+".action";
				
				$.post(url,frm, function(){
					
					$('#addHolidayWindow').window('close');
					$('#holidayGrid').trigger('reloadGrid');
					
					$('#hoilday_hdate').val('');
					$('#hoilday_hedate').val('');
					$('#hoilday_hdesc').val('');
					
					
					
					msgShow(i18n['msg_operationSuccessful'],'show');
				});
			}
		},
		
		
		/**
		 * @description 删除节假日.
		 */
		deleteHoliday:function(){
			
			checkBeforeDeleteGrid("#holidayGrid",itsm.security.organizationHoliday.deleteHolidayMethod);
		},
		
		/**
		 * @description 提交删除节假日.
		 */
		deleteHolidayMethod:function(rowIds){
			
			var param = $.param({'ids':rowIds},true);
			$.post("holiday!deleteHoliday.action", param, function()
			{
				$('#holidayGrid').trigger('reloadGrid');
				
				msgShow(i18n['deleteSuccess'],'show');
				
			}, "json");
			
		},

		

		/**
		 * @description 提交删除节假日.
		 */
		deleteHolidayInLine:function(rowId){
			
			confirmBeforeDelete(function(){
				
				var param = $.param({'ids':rowId},true);
				$.post("holiday!deleteHoliday.action", param, function(){
					$('#holidayGrid').trigger('reloadGrid');				
					msgShow(i18n['deleteSuccess'],'show');
				}, "json");
				
			});

		},
		
		
		/**
		 * @description 显示机构对应的假期
		 */
		showHolidayByOrganization:function(orgNo){
			
			var _url = 'holiday!findHolidayPage.action?holidayQueryDTO.orgNo='+orgNo;	
			
			if(orgNo=="0"){
				
				_url = 'holiday!findHolidayPage.action';
			}
			
			$('#holidayGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');
		},
		
		/**
		 * 载入.
		 */
		init:function(){
			
			//加载列表
			itsm.security.organizationHoliday.showHoliday();
			
			//绑定事件
			$('#holidayGrid_add').click(itsm.security.organizationHoliday.addHolidayOpenwindow);
			$('#holidayGrid_edit').click(itsm.security.organizationHoliday.editHolidayOpenwindow);
			$('#holidayGrid_delete').click(itsm.security.organizationHoliday.deleteHoliday);
			$('#holidayGrid_save').click(itsm.security.organizationHoliday.saveHoliday);
			
			
			
		}
		
		
	};
	
	

}();
