﻿/**  
 * @author Van  
 * @constructor Van
 * @description 机构管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.security');
$import('itsm.security.organizationTree');
$import('itsm.security.organizationGrid');
$import('itsm.security.organizationRole');
$import('itsm.security.organizationHoliday');
$import('itsm.security.organizationServiceTime');
$import("itsm.security.userUtil");


itsm.security.organizationMain = function() {
	

	
	//机构中的数据列表集合
	this.organizationGrids=[];
	//加载标识
	this.holidayTabClick="0";
	this.gridTabClick="0";
	this.roleTabClick="0";
	
	
	return {
		
		
		/**
		 * @description 编辑当前机构.
		 */
		saveCurrentOrg:function (){
			var uname=$('#organizationDto_personInChargeName').val();
			if(uname!=''){
				//查看用户是否存在
				checkUserByName(uname,itsm.security.organizationMain.checkUserEdit);
			}else{
				itsm.security.organizationMain.checkUserEdit('');
			}
		},
		
		
		/**
		 * @description 编辑机构方法。
		 */
		checkUserEdit:function(userId){
			
			if($('#editCurrentOrgForm').form('validate')){
				
				$('#organizationDto_personInChargeNo').val(userId);
				var frm = $('#editOrgDiv form,#orgRoleDiv form').serialize();
				var url = 'organization!updateOrg.action';
				$.post(url,frm, function(){
					$('#orgGrid').trigger('reloadGrid');
					itsm.security.organizationTree.loadOrganizationTreeView('#orgTreeDIV');//重新载入树结构
					msgShow(i18n['msg_org_orgEditSuccessful'],'show');
				});
			}
		},
		
		/**
		 * @description 保存机构信息.
		 */
		addCurrentOrg:function (){
			if($('#addChildForm').form('validate')){
				var uname=$('#organizationDto_personInChargeName_add').val();
				if(uname!=""){
					//查看用户是否存在
					checkUserByName(uname,itsm.security.organizationMain.addCurrentOrgMethod);
				}else{
					itsm.security.organizationMain.addCurrentOrgMethod('');
				}	
			}
		},
		
		/**
		 * @description 保存机构信息.
		 */
		addCurrentOrgMethod:function (userId){
			
			$('#organizationDto_personInChargeNo_add').val(userId);
			
				var frm = $('#addOrgDiv form').serialize();
				var url = 'organization!save.action';
				$.post(url,frm, function(){
					
					//重新载入树结构
					itsm.security.organizationTree.loadOrganizationTreeView('#orgTreeDIV');
				
					$('#orgGrid').trigger('reloadGrid');
					$('#add_actionType').val('inner');
					$('#addChild_orgName').val('');
					$('#addChild_officePhone').val('');
					$('#addChild_officeFax').val('');
					$('#addChild_email').val('');
					$('#addChild_address').val('');
					$('#organizationDto_personInChargeName_add').val('');
					$('#organizationDto_personInChargeNo_add').val('');
					msgShow(i18n['msg_org_orgAddSuccessful'],'show');
					
				});
		},

		
		/**
		 * @description 默认显示公司信息.
		 */
		showCompanyInfo:function(){
			
			
			var url = 'organization!findCompany.action';
			$.post(url,function(res){

				$("#edit_actionType>option[value='services']").remove();
				$("#edit_actionType>option[value='inner']").remove();
				$("<option value='company'>"+i18n['label_org_companyInfo']+"</option>").appendTo("#edit_actionType");
				
				$('#edit_officeFax').val(res.officeFax);
				$('#edit_officePhone').val(res.officePhone);
				$('#edit_email').val(res.email);
				$('#edit_address').val(res.address);
				$('#edit_orgNo').val(res.orgNo);
				$('#edit_orgName').val(res.orgName);
				
				if(res.personInChargeName!=null && res.personInChargeName!='null'){
					$('#organizationDto_personInChargeName').val(res.personInChargeName);
					$('#organizationDto_personInChargeNo').val(res.personInChargeNo);
				}else{
					$('#organizationDto_personInChargeName').val('');
					$('#organizationDto_personInChargeNo').val('');
				}
				
			});
		},
		
		
		/**
		 * @description 为tab点击绑定事件
		 */
		innerTabClick:function(){

		        $('#organizationMainTab').tabs({
		            onSelect:function(title){
		            	
		        		if(title==i18n['title_org_holiday'] && holidayTabClick=="0"){	
		        			itsm.security.organizationHoliday.init();
	        				holidayTabClick="1";
		        		}

		        		if(title==i18n['common_gridView'] && gridTabClick=="0"){     
	        				itsm.security.organizationGrid.init();
	        				gridTabClick="1";
		        		}
		        		if(title==i18n['title_org_role'] && roleTabClick=="0"){
	        			
	        				itsm.security.organizationRole.showRoleView('','#orgRoleDiv');	        				
	        				roleTabClick="1";
		        		}
		            }  
		        });
		},
		
		/**
		 * 展开或收缩面板.
		 */
		panelCollapseExpand:function(){
			
			 $(organizationGrids).each(function(i, g) {
			      setGridWidth(g, 'organizationMainTab', 10);
			 });
		},
		
		/**
		 * 数据列表自动伸展.
		 */
		fitOrganizationGrids:function(){
			
			$('#organzationWest,#organizationEast').panel({
				onCollapse:itsm.security.organizationMain.panelCollapseExpand,
				onExpand:itsm.security.organizationMain.panelCollapseExpand
			});
		},
		
		
		/**
		 * @description 选择机构负责人.
		 */
		selectPersonIncharge:function(userId,userName){
			
			itsm.security.userUtil.selectUser(userName,userId,'','loginName');
		},
		
		
		/**
		 * 载入.
		 */
		init:function(){
			
		
			//隐显面板
			$("#organizationMain_loading").hide();
			$("#organizationMain_content").show();
			
			//面板点击事件
			itsm.security.organizationMain.innerTabClick();
			//默认公司信息
			itsm.security.organizationMain.showCompanyInfo();
			//显示机构树
			itsm.security.organizationTree.loadOrganizationTreeView('');
			//面板伸展
			setTimeout(itsm.security.organizationMain.fitOrganizationGrids,0);
			//点击事件
			$('#mergeCurrentOrgBtn').click(itsm.security.organizationMain.saveCurrentOrg);
			$('#saveCurrentOrgBtn').click(itsm.security.organizationMain.addCurrentOrg);
			
			//服务时间
			itsm.security.organizationServiceTime.init();
			
			//选择机构负责人
			$('#organizationDto_personInChargeName_choose').click(function(){
				itsm.security.organizationMain.selectPersonIncharge('#organizationDto_personInChargeNo','#organizationDto_personInChargeName');
				
			});
			
			$('#organizationDto_personInChargeName_add_choose').click(function(){
				itsm.security.organizationMain.selectPersonIncharge('#organizationDto_personInChargeNo_add','#organizationDto_personInChargeName_add');
				
			});
			
			$('#organizationDto_personInChargeName_gridAdd_choose').click(function(){
				itsm.security.organizationMain.selectPersonIncharge('#organizationDto_personInChargeNo_gridAdd','#organizationDto_personInChargeName_gridAdd');
				
			});
			

		}
		
	};
	

}();


//载入
$(document).ready(itsm.security.organizationMain.init);