/**  
 * @author Van  
 * @constructor Van
 * @description 服务时间管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
$package('itsm.security');

itsm.security.organizationServiceTime = function() {

	
	return {
		
		/**
		 * @description 根据机构编号查找服务时间.
		 */
		findServiceByOrganizationNo:function(orgNo){
			
			
			var url="serviceTime!findByOrgNo.action?serviceTimeDTO.orgNo="+orgNo;
			
			$.post(url,function(res){
					
					if(res.sid!=null){
						$('#serviceTimeDTO_sid').val(res.sid);
					}else{
						$('#serviceTimeDTO_sid').val('');
					}
				 	if(res.allday){
				 		
				 		$('#setTime').hide();
				 		$('#fullday').attr("checked",true);
						$('#fullDayTd').css('width','100%');
				 		
				 		
				 	}else{
				 		
				 		$('#setTime').show();
				 		$('#diyday').attr("checked",true);
						$('#fullDayTd').css('width','50%');
				 	}
				    
				    $('#serviceTimeDTO_startHour').val(res.startHour);
				    $('#serviceTimeDTO_startMinute').val(res.startMinute);
				    $('#serviceTimeDTO_endHour').val(res.endHour);
				    $('#serviceTimeDTO_endMinute').val(res.endMinute);
				    
				    
				    
				    if(res.monday){
				    	$('#serviceTimeDTO_monday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_monday').attr("checked",'');
				    }
				    
				    if(res.tuesday){
				    	$('#serviceTimeDTO_tuesday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_tuesday').attr("checked",'');
				    }

				    if(res.wednesday){
				    	$('#serviceTimeDTO_wednesday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_wednesday').attr("checked",'');
				    }

				    if(res.thursday){
				    	$('#serviceTimeDTO_thursday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_thursday').attr("checked",'');
				    }

				    if(res.friday){
				    	$('#serviceTimeDTO_friday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_friday').attr("checked",'');
				    }
				    
				    if(res.saturday){
				    	$('#serviceTimeDTO_saturday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_saturday').attr("checked",'');
				    }
				    
				    if(res.sunday){
				    	$('#serviceTimeDTO_sunday').attr("checked",true);
				    }else{
				    	$('#serviceTimeDTO_sunday').attr("checked",'');
				    }
				});
		},
		
		
		/**
		 * @description 保存服务时间.
		 */
		saveServiceTime:function(){
			
			var serviceTime_orgNo=$('#serviceTime_orgNo').val();
			
			if(serviceTime_orgNo==''){
				msgAlert(i18n['msg_chooseOrg'],'info');
			}else{
			
				itsm.security.organizationServiceTime.setFormValue();
				var url="serviceTime!saveOrgUpdate.action";
				var frm = $('#serviceTimeDiv form').serialize();
				
				$.post(url,frm, function(){
					msgShow(i18n['msg_serviceTime_updateSuccessful'],'show')
				});
			}
		},
		
		
		
		/**
		 * @description 设置表单值.
		 */
		setFormValue:function(){
			
			var allday=$("input:radio:checked").val(); 

			$('#serviceTimeDTO_allday').val(allday);
			
			if($('#serviceTimeDTO_monday').attr("checked")){
				$('#serviceTimeDTO_monday').val("true");
			}
			if($('#serviceTimeDTO_tuesday').attr("checked")){
				$('#serviceTimeDTO_tuesday').val("true");
			}
			if($('#serviceTimeDTO_wednesday').attr("checked")){
				$('#serviceTimeDTO_wednesday').val("true");
			}
			if($('#serviceTimeDTO_thursday').attr("checked")){
				$('#serviceTimeDTO_thursday').val("true");
			}
			if($('#serviceTimeDTO_friday').attr("checked")){
				$('#serviceTimeDTO_friday').val("true");
			}
			if($('#serviceTimeDTO_saturday').attr("checked")){
				$('#serviceTimeDTO_saturday').val("true");
			}
			if($('#serviceTimeDTO_sunday').attr("checked")){
				$('#serviceTimeDTO_sunday').val("true");
			}
		},
		
		init:function(){
			
			$('#serviceTime_save').click(itsm.security.organizationServiceTime.saveServiceTime);
			
			
			$('#fullday').click(function(){//全天工作
				
				$('#setTime').hide();
				$('#fullDayTd').css('width','100%');
				itsm.security.organizationServiceTime.setFormValue();
			});
			

			$('#diyday').click(function(){//自定义工作时间
				
				$('#setTime').show();
				$('#fullDayTd').css('width','50%');
				itsm.security.organizationServiceTime.setFormValue();
			});
			
			
		}
		
		
	
		
	};
	

}();
