/**  
 * @author Van  
 * @constructor Van
 * @description 机构树结构.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.security');
$import('itsm.security.organizationRole');
$import('itsm.security.organizationHoliday');
$import('itsm.security.organizationServiceTime');

itsm.security.organizationTree = function() {

	
	return {

		/**
		 * @description 加载右边树菜单
		 */
		loadOrganizationTreeView:function(treeDIV){
			
			if(treeDIV==''){
				treeDIV='#orgTreeDIV';
			}
			
			$(treeDIV).jstree({
				json_data:{
					ajax: {url : "organization!findAll.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',itsm.security.organizationTree.selectTreeNode)
			.bind('delete_node.jstree',itsm.security.organizationTree.deleteTreeNode)
			.bind('move_node.jstree', itsm.security.organizationTree.moveTreeNode);
		},
		
		/**
		 * @description 选择节点事件.
		 */
		selectTreeNode:function(event, data){
			
		
			
			var orgNo=data.rslt.obj.attr("orgNo");
			var orgName=data.rslt.obj.attr("orgName");
			var companyNo=data.rslt.obj.attr("companyNo");
			var orgType=data.rslt.obj.attr("orgType");
			
			if(orgNo!=null && orgNo!='' && orgName!='ROOT' && orgType!="innerPanel" && orgType!="servicePanel"){
				
				//加载机构角色			
				itsm.security.organizationRole.showOrganizationRole(orgNo);
				
				//加载节假日列表
				$('#hoilday_orgNo').val(orgNo);
				itsm.security.organizationHoliday.showHolidayByOrganization(orgNo);
				
				//服务机构
				$('#serviceTime_orgNo').val(orgNo);
				itsm.security.organizationServiceTime.findServiceByOrganizationNo(orgNo);

				$('#add_parentOrgNo').val(orgNo);
				
				
				//显示当前机构信息
				itsm.security.organizationTree.findOrganizationByTree(data);
			}

			if(orgType!=null && orgType!=''){
				
				itsm.security.organizationTree.enableOrDisableOrgType(orgType);
			}
			
		},

		
		/**
		 * 改变机构类型.
		 * 
		 */
		enableOrDisableOrgType:function(orgType){
			
			$('#edit_orgType').val(orgType);
			
			//添加时禁用或启用机构
			if(orgType=="inner"  || orgType=="innerPanel"){
				
				//添加
				$("#add_actionType>option[value='inner']").remove();
				$("#add_actionType>option[value='services']").remove();
				$("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#add_actionType");
				
				//编辑
				$("#edit_actionType>option[value='company']").remove();
				$("#edit_actionType>option[value='services']").remove();
				$("#edit_actionType>option[value='inner']").remove();
				
				$("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#edit_actionType");

				
				
			}else if(orgType=="services"  || orgType=="servicePanel"){
				
				//添加
				$("#add_actionType>option[value='inner']").remove();
				$("#add_actionType>option[value='services']").remove();
				$("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#add_actionType");
				
				//编辑
				$("#edit_actionType>option[value='company']").remove();
				$("#edit_actionType>option[value='services']").remove();
				$("#edit_actionType>option[value='inner']").remove();
				
				$("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#edit_actionType");
				
				
			}else{
				
				//添加
				$("#add_actionType>option[value='inner']").remove();
				$("#add_actionType>option[value='services']").remove();
				$("<option value='inner'>"+i18n['msg_org_innerOrg']+"</option>").appendTo("#add_actionType");
				$("<option value='services'>"+i18n['msg_org_serviceOrg']+"</option>").appendTo("#add_actionType");
				
				//编辑
				$("#edit_actionType>option[value='company']").remove();
				$("#edit_actionType>option[value='services']").remove();
				$("#edit_actionType>option[value='inner']").remove();
				
				$("<option value='company'>"+i18n['label_org_companyInfo']+"</option>").appendTo("#edit_actionType");
				
				
				
				$('#add_parentOrgNo').val("1");
			}
			
		},
		
		/**
		 * @description 删除节点.
		 */
		deleteTreeNode:function (e, data) {
			
			var url = "organization!remove.action";
			var params = {"orgNo" : data.rslt.obj.attr("orgNo")};
			$.post(url,params,
				function (r) {
					if(r && !r.status) {
						$.jstree.rollback(data.rlbk);  
					}else{
						msgShow(i18n['msg_operationSuccessful'],'show');
					}
				},
				'json'
			);	
		},
		
		/**
		 * 拖拽机构（复制、剪切、粘贴）
		 */
		moveTreeNode:function(e, data){
			
			data.rslt.o.each(function (i) {
			
				   var tag=data.rslt.cy;
				   var cate_type=$(this).attr('orgType').replace('node_','');
				   var cate_ptype=data.rslt.np.attr('orgType').replace('node_','');

				   //标题机构
				   if(cate_type=="servicePanel"||cate_type=="innerPanel"||cate_type=="company"||cate_type=="ROOT"){
					   msgAlert(i18n['msg_org_disMove'],'info');
					   $.jstree.rollback(data.rlbk);  
				   }else{		   
						   
						   var msg=itsm.security.organizationTree.switchMessage(cate_type,cate_ptype);
						   
						   if(msg!=''){
							   $.jstree.rollback(data.rlbk);  
							   msgAlert(msg,'info');
						   }else{
							   
							   //可以移动
							   var cate_id=$(this).attr('orgNo').replace('node_','');
							   var cate_parid=1;
		
							   if(cate_ptype!="servicePanel"&&cate_ptype!="innerPanel"&&cate_ptype!="company"&&cate_ptype!="ROOT"){
								   cate_parid=data.rslt.np.attr('orgNo').replace('node_','');
							   }
							   var params = {"organizationDto.orgNo" : cate_id,"organizationDto.parentOrgNo":cate_parid};
							   //复制节点
							   if(tag==true){
								   itsm.security.organizationTree.moveTreeNode_Copy(params);
							   }
							   //剪切节点
							   if(tag==null||tag==false){
								   itsm.security.organizationTree.moveTreeNode_Cut(params);
							   }
						 }
				   }

			});
			
		},
		
		/**
		 * 匹配消息
		 */
		switchMessage:function(cate_type,cate_ptype){
			
			  var msg='';
			 if(cate_type=="services"&&cate_ptype=="innerPanel"){
				   msg=i18n['msg_org_serviceMoveToInner'];
			   }
			   if(cate_type=="services"&&cate_ptype=="inner"){
				   msg=i18n['msg_org_serviceMoveToInner'];
			   }
			   if(cate_type=="inner"&&cate_ptype=="services"){
				   msg=i18n['msg_org_innerMoveToService'];
			   }
			   if(cate_type=="inner"&&cate_ptype=="servicePanel"){
				   msg=i18n['msg_org_innerMoveToService'];
			   }
			   return msg;
		},
		
		/**
		 * 复制节点.
		 */
		moveTreeNode_Copy:function(params){
			
			  var url = "organization!copyOrg.action";
				$.post(url,params,function (r){
						if(r && !r.status){
							$.jstree.rollback(data.rlbk);  
						}else{
							
							
							msgShow(i18n['msg_operationSuccessful'],'show');
						}
					},
					'json'
				);
		},
		
		/**
		 * 剪切节点.
		 */
		moveTreeNode_Cut:function(params){
			
		    var url = "organization!moveOrg.action";
			$.post(url,params,function (r) {
					if(r && !r.status){
						$.jstree.rollback(data.rlbk);  
					}else{
						msgShow(i18n['msg_operationSuccessful'],'show');
					}
				},
				'json'
			);
		},

		/**
		 * 从树数据中获取机构信息（用于编辑）.
		 */
		findOrganizationByTree:function(data){
			
			//清空
			$('#edit_officeFax').val("");
			$('#edit_officePhone').val("");
			$('#edit_email').val("");
			$('#edit_address').val("");
			$('#edit_orgNo').val("");
			$('#parentOrgNo').val("1");
			$('#organizationDto_personInChargeName').val("");
			$('#organizationDto_personInChargeNo').val("");
			
			$('#edit_orgName').val(data.rslt.obj.attr("orgName"));
			$('#edit_officeFax').val(data.rslt.obj.attr("officeFax"));
			$('#edit_officePhone').val(data.rslt.obj.attr("officePhone"));
			$('#edit_email').val(data.rslt.obj.attr("email"));
			$('#edit_address').val(data.rslt.obj.attr("address"));
			$('#edit_orgNo').val(data.rslt.obj.attr("orgNo"));
			//add panel
			$('#edit_parentOrgNo').val(data.rslt.obj.attr("parentNo"));
			
			
			var personInChargeName = data.rslt.obj.attr("personInChargeName");
			
			if(personInChargeName!=null&&personInChargeName!=''){
				$('#organizationDto_personInChargeName').val(personInChargeName);
				$('#organizationDto_personInChargeNo').val(data.rslt.obj.attr("personInChargeNo"));
			}else{		
				$('#organizationDto_personInChargeName').val('');
				$('#organizationDto_personInChargeNo').val('');
			}
			
		}
		
	};

}();