/**  
 * @author Van  
 * @constructor Van
 * @description 机构树结构.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.security');

itsm.security.organizationTreeUtil = function() {

	
	return {

		/**
		 * 显示所有机构，含面板
		 */
		showAll:function(treeId,callback){
			
			$(treeId).jstree({
				json_data:{
					ajax: {url : "organization!findAll.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]

			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e,data){
				
				callback(e,data);
				
			});
		},
		
		
		
		
		
		
		
		/**
		 * 显示所有机构，含面板
		 */
		showAll_2:function(windowPanel,treePanel,namePut,idPut){
			
			$(windowPanel).window('open');//打开窗口
			
			$(treePanel).jstree({
				json_data:{
					ajax: {url : "organization!findAll.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]

			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e,data){
				
				$(namePut).val(data.rslt.obj.attr("orgName"));
				$(idPut).val(data.rslt.obj.attr("orgNo"));
				
				$(windowPanel).window('close');//关闭窗口
				
			});
		},
		
		
		/**
		 * 公共模块，指派组.
		 */
		assginGroup:function(namePut,idPut){
			
			itsm.security.organizationTreeUtil.showAll_2('#index_assignGroup_window','#index_assignGroup_tree',namePut,idPut);
		},
		
		
		
		/**
		 * 仅显示服务机构
		 */
		showService:function(windowPanel,treePanel,namePut,idPut){
			
			
			$(windowPanel).window('open');//打开窗口
			
			$(treePanel).jstree({
				json_data:{
					ajax: {url : "organization!findServicesTree.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})//默认展开
			.bind('select_node.jstree',function(e,data){


				$(namePut).val(data.rslt.obj.attr("orgName"));
				$(idPut).val(data.rslt.obj.attr("orgNo"));
	
				$(windowPanel).window('close');//关闭窗口
				
			});
			
			
		},
		
		/**
		 * 仅显示内部机构.
		 */
		showInner:function(treeId,callback){
			
		},
		
		/**
		 * 显示所有机构，不含面板.
		 */
		showSelectOrgs:function(windowId,treeId,callback){
			
			$(windowId).window('open');
			
			$(treeId).jstree({
				json_data:{
					ajax: {url : "organization!findAll.action",cache: false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]

			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e,data){
				
				callback(e,data);
				
				$(windowId).window('close');
			});
			
		}
		
	};

}();