/**  
 * @author Van  
 * @constructor Van
 * @description 供应商管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.security');

itsm.security.supplierMain = function() {


	return {
	
		/**
		 * @description 动作格式化.
		 */
		supplierGridFormatter:function(cell,opt,data){
			
			return actionFormat('1','1')
			.replace('[edit]','itsm.security.supplierMain.editSupplier_openWindow()')
			.replace('[delete]','itsm.security.supplierMain.deleteSupplierInLine('+data.orgNo+')');
		},
	
		/**
		 * @description 加载供应商列表.
		 */
		showSupplierGrid:function(){
	
			var params = $.extend({},jqGridParams, {	
				url:'supplier!findByCompany.action',
				caption:i18n['caption_supplier'],
				colNames:[i18n['common_name'],i18n['common_phone'],i18n['common_email'],i18n['common_address'],i18n['common_action'],'','','','','',''],
				colModel:[
						 
						  {name:'orgName',width:100,align:'center'},
						  {name:'officePhone',width:80,align:'center'},
						  {name:'email',width:80,align:'center'},
						  {name:'address',width:150,align:'center'},
						  {name:'act', width:80,align:'center',sortable:false,formatter:itsm.security.supplierMain.supplierGridFormatter},
						  {name:'orgNo',hidden:true},
						  {name:'officeFax',hidden:true},
						  {name:'homePage',hidden:true},
						  {name:'logo',hidden:true},
						  {name:'orgType',hidden:true},
						  {name:'companyNo',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "orgNo"}),
				sortname:'orgNo',
				pager:'#supplierGridPager'
				});
				$("#supplierGrid").jqGrid(params);
				$("#supplierGrid").navGrid('#supplierGridPager',navGridParams);
				//列表操作项
				$("#t_supplierGrid").css(jqGridTopStyles);
				$("#t_supplierGrid").append($('#supplierGridToolbar').html());
				
				//自适应宽度
				setGridWidth("#supplierGrid","regCenter",10);
				
		},
	
	
		/**
		 * @description 打开新增供应商窗口.
		 */
		addSupplier_openWindow:function(){
			
			$('#addSupplier_win').window('open');
		},
		
		/**
		 * @description 提交新增供应商.
		 */
		addSupplier_doAdd:function(){
			
			if($('#addSupplier_form').form('validate')){
				var frm = $('#addSupplier_win form').serialize();
				var url = 'supplier!save.action';
				$.post(url,frm, function(){
					
					$('#supplierGrid').trigger('reloadGrid');
					$('#addSupplier_win').window('close');
					
					$('#addSupplier_orgName').val('');
					$('#addSupplier_officeFax').val('');
					$('#addSupplier_officePhone').val('');
					$('#addSupplier_email').val('');
					$('#addSupplier_address').val('');
					
					msgShow(i18n['msg_supplier_addSuccessful'],'show');
					
				});
			}
		},
		
		/**
		 * @description 编辑供应商.
		 */
		editSupplier_openWindow:function(){
			
			checkBeforeEditGrid("#supplierGrid",function(rowData){
				
				 $('#editSupplier_orgName').val(rowData.orgName);
				 $('#editSupplier_officeFax').val(rowData.officeFax);
				 $('#editSupplier_officePhone').val(rowData.officePhone);
				 $('#editSupplier_email').val(rowData.email);
				 $('#editSupplier_address').val(rowData.address);
				 $('#editSupplier_orgNo').val(rowData.orgNo);
				 
				 $('#editSupplier_companyNo').val(rowData.companyNo);
				 $('#editSupplier_win').window('open');
				
			});
		},
		
		
		/**
		 * @description 提交编辑供应商.
		 */
		editSupplier_doEdit:function(){
			
			if($('#editSupplier_form').form('validate')){
				var frm = $('#editSupplier_win form').serialize();
				var url = 'supplier!merge.action';
				$.post(url,frm, function(){
					$('#supplierGrid').trigger('reloadGrid');
					$('#editSupplier_win').window('close');
					msgShow(i18n['msg_supplier_editSuccessful'],'show');
				});
			}
		},
	
		/**
		 * @description 删除客户.
		 */
		deleteSupplier_tooBar:function(){
		
			checkBeforeDeleteGrid("#supplierGrid",function(rowIds){
				
				var param = $.param({'orgNos':rowIds},true);
				$.post("supplier!deleteSuppliers.action", param, function(){
					
					$('#supplierGrid').trigger('reloadGrid');
					msgShow(i18n['msg_supplier_deleteSuccessful'],'show');
					
				}, "json");
				
			});
		},
		
		
	
		/**
		 * @description 提交删除客户.
		 */
		deleteSupplierInLine:function(rowId){
			
			confirmBeforeDelete(function(){
				
				var url = "supplier!deleteSuppliers.action";
				var params = {"orgNos" :rowId};
				$.post(url,params,
					function (r) {
					
						$('#supplierGrid').trigger('reloadGrid');
						msgShow(i18n['msg_supplier_deleteSuccessful'],'show');
					},
					'json'
				);
			});
		},
	
		
		/**
		 * @description 搜索供应商.
		 */
		searchSupplier_openWindow:function(){
			
			$('#searchSupplierGrid').window('open');
		},
		
		/**
		 * @description 搜索供应商.
		 */
		searchSupplier_doSearch:function(){
			
			var _url = 'supplier!findByCompany.action';	
			searchGridWithForm('#supplierGrid','#searchSupplierGrid',_url);	
		},


		init: function(){

			//隐显加载图标
			showAndHidePanel('#supplierMain_content','#supplierMain_loading');
			
			//加载列表
			itsm.security.supplierMain.showSupplierGrid();

			//供应商
			$('#addSupplierBtn').click(itsm.security.supplierMain.addSupplier_openWindow);
			$('#addSupplierBtn_OK').click(itsm.security.supplierMain.addSupplier_doAdd);
			$('#editSupplierBtn').click(itsm.security.supplierMain.editSupplier_openWindow);
			$('#editSupplierBtn_OK').click(itsm.security.supplierMain.editSupplier_doEdit);
			$('#deleteSupplierBtn').click(itsm.security.supplierMain.deleteSupplier_tooBar);
			$('#searchSupplierBtn').click(itsm.security.supplierMain.searchSupplier_openWindow);
			$('#searchSupplierBtn_OK').click(itsm.security.supplierMain.searchSupplier_doSearch);
		}
		
	};
}();


//载入
$(document).ready(itsm.security.supplierMain.init);
