/**  
 * @author Van  
 * @constructor Van
 * @description 用户选择公共函数.
 * @date 2011-02-25
 * @since version 1.0 
 */
$package('itsm.security');
$import('itsm.security.organizationTreeUtil');


itsm.security.userUtil=function(){

	this.showFlag='loginName';
	this.userNamePut='';
	this.userIdPut='';
	this.userCostPut='';
	this.loadUserSelectFlag='no';
	this.multiTag=true;
	return {

		/**
		 * 用户选择，多选.
		 */
		selectUserMulti:function(namePut,idPut,showType){
			
			multiTag=true;
			$('#selectUser_south_multi').show();//显示按钮
			$('#selectUser_south_single').hide();//隐藏提示
			itsm.security.userUtil.selectUserComm(namePut,idPut,'',showType);
		},
	
		
		
		/**
		 * 用户选择，单选.
		 */
		selectUser:function(namePut,idPut,tcCostPut,showType){
			
			
			multiTag=false;
			$('#selectUser_south_multi').hide();//隐藏按钮
			$('#selectUser_south_single').show();//显示提示
			itsm.security.userUtil.selectUserComm(namePut,idPut,tcCostPut,showType);
		
		},
		
		/**
		 * 选择用户,公共.
		 */
		selectUserComm:function(p_namePut,p_idPut,p_tcCostPut,p_showType){
			
			userNamePut=p_namePut;
			userIdPut=p_idPut;
			userCostPut=p_tcCostPut;
			showFlag=p_showType;
			
//			if(loadUserSelectFlag=="no"){
//				
//				itsm.security.userUtil.showSelectUserGrid();
//				loadUserSelectFlag="yes";
//				
//				//多选，确认选择
//				$('#selectUser_ConfirmSelect').click(itsm.security.userUtil.confirmMultiSelect);
//			}
			
			itsm.security.userUtil.showSelectUserGrid();
			//多选，确认选择
			$('#selectUser_ConfirmSelect').click(itsm.security.userUtil.confirmMultiSelect);
			
			itsm.security.userUtil.loadTree();//加载树
			$('#selectUser_window').window('open');//打开窗口
			$('#selectUser_window_tabs').tabs();//显示tab
			
			setTimeout(function(){//隐藏显示复选框

				if(multiTag){
					$('#selectUser_userGrid').jqGrid('showCol', 'cb');
				}else{
					$('#selectUser_userGrid').jqGrid('hideCol', 'cb');
				}
			},0);
			
		
			
		},

		/**
		 * 加载树结构
		 */
		loadTree:function(){
			
			itsm.security.organizationTreeUtil.showAll('#selectUser_organizationTree',function(e,data){
				
				$('#searchSelectUser_loginName').val("");
				$('#searchSelectUser_orgNo').val("0");
				//ROOT
				if(data.rslt.obj.attr("orgNo")!=null){
					$('#searchSelectUser_orgNo').val(data.rslt.obj.attr("orgNo"));
				}
				var sdata=$('#searchUserOnSelect form').getForm();
				var postData = $("#selectUser_userGrid").jqGrid("getGridParam", "postData");
				$.extend(postData,sdata);  //将postData中的查询参数覆盖为空值
				$('#selectUser_userGrid').trigger('reloadGrid',[{"page":"1"}]);
			});
		},
		
		/**
		 * 动作格式化.
		 */
		userGridFormatter:function(cell,event,data){
			return '<div style="padding:0px">'+
			'<a href=javascript:itsm.security.userUtil.confirmCheck("'+data.firstName+data.lastName+'","'+data.loginName+'","'+data.userId+'","'+data.userCost+'") title="'+i18n['check']+'">'+
			'<img src="../images/icons/ok.png"/></a>'+
			'</div>';
		},
		
		/**
		 * 姓名格式化.
		 */
		fullNameFormatter:function(cell,event,data){
			var firstName='';
			var lastName='';
			if(data.firstName!=null)
				firstName=data.firstName;
			if(data.lastName!=null)
				lastName=data.lastName;
				
			return firstName+lastName;
		},
		
		
		/**
		 * 确认选定.
		 */
		confirmCheck:function(fullName,loginName,userId,userCost){
			
			
			
			
			if(multiTag){
				if(showFlag=="fullName"){
					if($(userNamePut).val()=='')
						$(userNamePut).val(fullName);
					else{
						if($(userNamePut).val().substring($(userNamePut).val().length-1,$(userNamePut).val().length)==';'){
							$(userNamePut).val($(userNamePut).val()+fullName);
						}else{
							$(userNamePut).val($(userNamePut).val()+";"+fullName);
						}
					}

				}else{
					if($(userNamePut).val()=='')
						$(userNamePut).val(loginName);
					else{
						if($(userNamePut).val().substring($(userNamePut).val().length-1,$(userNamePut).val().length)==';'){
							$(userNamePut).val($(userNamePut).val()+loginName);
						}else{
							$(userNamePut).val($(userNamePut).val()+";"+loginName);
						}
					}
				}
				
				
				
			}else{
				if(showFlag=="fullName"){
					
					$(userNamePut).val(fullName);
				}else{
					
					$(userNamePut).val(loginName);
				}
				
				
				if(userCostPut!=''){
					
					$(userCostPut).val(userCost);
				}
			}
			
			
			$(userIdPut).val(userId);
				
			
			$('#selectUser_window').window('close');
		},
		
		/**
		 * 加载用户列表.
		 */
		showSelectUserGrid:function(){
			if($("#selectUser_userGrid").html()!=''){
				$("#selectUser_userGrid").trigger("reloadGrid"); 
			}else{
				var params = $.extend({},jqGridParams, {	
					url : 'user!find.action',
					colNames:[i18n['loginName'],i18n['title_user_firstName'],i18n['telephone'],i18n['check'],'','','',''],
					colModel:[{name:'loginName',width:150},
							  {name:'fullName',width:130,align:'center',sortable:false,formatter:itsm.security.userUtil.fullNameFormatter},
							  {name:'moblie',width:130,sortable:false,align:'center',editable:true},
							  {name:'act', width:80,sortable:false,align:'center',formatter:itsm.security.userUtil.userGridFormatter},
							  {name:'userCost',hidden:true},
							  {name:'userId',hidden:true},
							  {name:'firstName',hidden:true},
							  {name:'lastName',hidden:true},
							  ],
					jsonReader : $.extend(jqGridJsonReader, {
						id : "userId"
					}),
					sortname : 'userId',
					pager : '#selectUser_userGridPager',
					toolbar:false,
					autowidth:true,
					ondblClickRow:function(rowId){
						
						var data=$('#selectUser_userGrid').getRowData(rowId);
						itsm.security.userUtil.confirmCheck(data.fullName,data.loginName,data.userId,data.userCost);
					},
				});
				
				$("#selectUser_userGrid").jqGrid(params);
				$("#selectUser_userGrid").navGrid('#selectUser_userGridPager', navGridParams);
				$("#selectUser_userGrid").navButtonAdd('#selectUser_userGridPager',{caption:"",buttonicon:"ui-icon-search",onClickButton:function(){$('#searchUserOnSelect').window('open');},position:"last"});  
				$('#selectUser_common_dosearch').click(itsm.security.userUtil.searchUser);//搜索用户
			}	
			
		
		},
		
		/**
		 * 搜索用户.
		 */
		searchUser:function(){
			
			var sdata=$('#searchUserOnSelect form').getForm();
			var postData = $("#selectUser_userGrid").jqGrid("getGridParam", "postData");
			$.extend(postData,sdata);  //将postData中的查询参数覆盖为空值
			$('#selectUser_userGrid').trigger('reloadGrid',[{"page":"1"}]);
			$('#searchUserOnSelect').window('close');
		},
		
		/**
		 * 多选，确认选择.
		 * 
		 */
		confirmMultiSelect:function(){
			
			var userNames="";
			var userIds="";
			var rowIds = $("#selectUser_userGrid").getGridParam('selarrrow');
			
			
			$.each(rowIds, function(k, v){
				var rowData=$("#selectUser_userGrid").getRowData(v); 
				userNames+=rowData.loginName+";"
				userIds+=rowData.userId;
			});
			

			if($(userNamePut).val()=='')
				$(userNamePut).val(userNames);
			else{
				if($(userNamePut).val().substring($(userNamePut).val().length-1,$(userNamePut).val().length)==';'){
					$(userNamePut).val($(userNamePut).val()+userNames);
				}else{
					$(userNamePut).val($(userNamePut).val()+";"+userNames);
				}
			}
			$(userIdPut).val(userIds);
			
			$('#selectUser_window').window('close');
			
		}
		
		
	};
	
}();
