
 /**  
 * @author Van  
 * @constructor SLAServiceManage
 * @description SLA详细信息主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.sla');
$import('itsm.sla.slaDetail_ruleGrid_Operation');

itsm.sla.slaDetail_ruleGrid=function(){
	
	
	return{


		
		
		/**
		 * 时间格式化
		 */
		slaTimeFormatter:function(cell,event,data){
		
			return cell.replace("DD",i18n['label_slaRule_days'])
			.replace("HH",i18n['label_slaRule_hours'])
			.replace("MM",i18n['label_slaRule_minutes']);
		},
		
		/**
		 * @description 加载SLA规则列表.
		 */
		showSLARuleGrid:function(){
	
			var params = $.extend({},jqGridParams, {	
			url:'slaRule!find.action?contractNo='+_contractNo,
			caption:i18n['caption_slaRuleGrid'],
			colNames:[i18n['title_sla_name'],i18n['title_sla_requestTime'],i18n['title_sla_completeTime'],''],
			colModel:[
					  {name:'ruleName',width:40,align:'center'},
					  {name:'showRespondTime',width:30,align:'center',formatter:itsm.sla.slaDetail_ruleGrid.slaTimeFormatter},
					  {name:'showFinishTime',width:30,align:'center',formatter:itsm.sla.slaDetail_ruleGrid.slaTimeFormatter},
					  {name:'ruleNo',hidden:true}
					  ],
			jsonReader: $.extend(jqGridJsonReader, {id: "ruleNo"}),
			sortname:'ruleNo',
			pager:'#slaDetail_ruleGridPager'
			});
			
			$("#slaDetail_ruleGrid").jqGrid(params);
			$("#slaDetail_ruleGrid").navGrid('#slaDetail_ruleGridPager',navGridParams);
			//列表操作项
			$("#t_slaDetail_ruleGrid").css(jqGridTopStyles);
			$("#t_slaDetail_ruleGrid").append($('#slaDetail_ruleGridToolbar').html());
			//自适应宽度
			setGridWidth("#slaDetail_ruleGrid","regCenter",338);
			slaDetailGrids.push('#slaDetail_ruleGrid');
			
			
		},
		
	
		/**
		 * @description 删除SLA规则.
		 */
		deleteSLARule:function(){
	
			checkBeforeDeleteGrid('#slaDetail_ruleGrid',function(rowIds){
				
				var _param = $.param({'ruleNos':rowIds},true);
				$.post("slaRule!delete.action",_param,function(){
					$("#slaDetail_ruleGrid").trigger('reloadGrid');
					msgShow(i18n['msg_deleteSuccessful'],'show');
				},"json");
				
			});
		},
	
		init:function(){
			
			itsm.sla.slaDetail_ruleGrid.showSLARuleGrid();
			
			itsm.sla.slaDetail_ruleGrid_Operation.addSLARule_ruleTermSet();
			
			//绑定事件
			$('#slaDetail_ruleGrid_add').click(itsm.sla.slaDetail_ruleGrid_Operation.addSLARuleOpenWindow);
			$('#slaDetail_ruleGrid_edit').click(itsm.sla.slaDetail_ruleGrid_Operation.editSLARuleOpenWindow);
			$('#slaDetail_ruleGrid_delete').click(itsm.sla.slaDetail_ruleGrid.deleteSLARule);
		}
	};

 }();
