/**  
 * @author Van  
 * @constructor slaDetail_SLARule
 * @description SLA规则主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.sla');

$import('itsm.rules.ruleCM');

itsm.sla.slaDetail_ruleGrid_Operation = function(){
	
	
	this.actionNo;
	this.slaRuleOperationTag="";
	this.i=0;
	
	
	return {
		

		/**
		 * @description 动态加载条件.
		 */
		addSLARule_ruleTermSet:function(){
			
			$('#addSLARule_team').html('');
			$(itsm.rules.ruleCM.loadConditionHTML()).appendTo("#addSLARule_team");
			$('#addSLARule_matical').html('');
			$(itsm.rules.ruleCM.loadConditionMathematicalOperationHTML()).appendTo("#addSLARule_matical");
		},
		
		/**
		 * @description 获取规则条件.
		 */
		addAndEdit_matchPname:function(){
			return $("#addSLARule_team").find("option:selected").text()+$("#addSLARule_matical").find("option:selected").text();
		},
		
		/**
		 * @description 获取列表显示内容.
		 */
		addAndEdit_matchPvalue:function(){		
			return itsm.rules.ruleCM.getRuleTitle('#addSLARule_team','#addSLARule_propertyValue','#slaRule_propertyName');
		},
	
		/**
		 * @description 设置值显示方式.
		 */
		setSLAPVHTML:function(){
			
			var flag=$('#addSLARule_team').val();
			
			itsm.rules.ruleCM.createRuleEvent(flag,'#addSLARule_propertyValueDIV','slaRule_propertyName','addSLARule_propertyValue','');
			
		},

		/**
		 * @description 符号.
		 */
		addSLARule_setTerm:function(){
			
			itsm.rules.ruleCM.setMathematicalOperation('#addSLARule_team','#addSLARule_matical');
		},
	
		
		/**
		 * 表单验证.
		 */
		checkBeforeSaveSLARule:function(method){
			
			var rday=$('#rule_rday').val();
			var rhour=$('#rule_rhour').val();
			var rminute=$('#rule_rminute').val();
			
			var fday=$('#rule_fday').val();
			var fhour=$('#rule_fhour').val();
			var fminute=$('#rule_fminute').val();
			
	
			if($('#addSLARuleForm').form('validate')){
			
			
				if(rday=='0'&&rhour=='0'&&rminute=='0' || fday=='0'&&fhour=='0'&&fminute=='0'){
					
					msgAlert(i18n['msg_msg_requestTimeAndCompleteTime'],'info');
					$('#slaTab_main').tabs('select',slaDetail);
	
				}else{
					 
					var constraintsNames = $('#addSLARuleDiv form input[name="rule_condition_constraints_propertyName"]');
					
					if(constraintsNames.length>0){
						
						method();
					}else{
						
						msgAlert(i18n['msg_msg_vaildateSLARules'],'error');
						$('#slaTab_main').tabs('select',fitRule);
					}
				}
				
			}else{
				
				$('#slaTab_main').tabs('select',slaDetail);
				
			}
		},
		
		
		
		/**
		 * @description 新增SLA规则.
		 */
		addSLARuleOpenWindow:function(){
			
			slaRuleOperationTag="save";
			$('#addSLARuleDivWindow').window({"title":i18n["title_sla_addSLARule"]});
			$('#addSLARuleDivWindow').window('open');
		},
		
		
		/**
		 * @description 编辑SLA规则.
		 */
		editSLARuleOpenWindow:function(){
			
			
			checkBeforeEditGrid('#slaDetail_ruleGrid',function(data){
				
				//删除表格里所有行
				$('#addRule_constraintsTable tbody').html('');
				
				var url = "slaRule!findSLARule.action?contractNo="+_contractNo+"&ruleNo="+data.ruleNo;
				
				slaRuleOperationTag="merge";
				itsm.sla.slaDetail_ruleGrid_Operation.fillSLARuleData(url);
				
				$('#rule_ruleNo').val(data.ruleNo);
				$('#save_slaRule').linkbutton({text:i18n['label_sla_saveEdit']});
				$('#addSLARuleDivWindow').window({"title":i18n["title_sla_editSLARule"]});
				$('#addSLARuleDivWindow').window('open');
			});
		},
	
		/**
		 * @description 保存方法
		 */
		saveSLARuleMethod:function(){
			
		
			var ckVal=$("input[name='rule_includeHoliday']:checked").val(); 
			$('#rule_includeHolidayVl').val(ckVal);
			
			var rule=itsm.rules.ruleCM.getRuleInfo('#addSLARuleDiv','#addSLARule_and','sla');//取得规则对象
			var url= "slaRule!"+slaRuleOperationTag+".action";
			
			var operationMsg=i18n["msg_add_successful"];
			if(slaRuleOperationTag=="merge"){
				operationMsg=i18n["msg_edit_successful"];
			}
			
			startProcess();//开始进程
			$.post(url,rule,function(){
				endProcess();//结束进程
				
				$('#addSLARuleDivWindow').window('close');

				//提示信息
				msgShow(operationMsg,'show');

				//刷新列表
				$("#slaDetail_ruleGrid").trigger('reloadGrid');
				
				//清空数据
				$('#rule_condition_rulePatternNo').val("");
				$('#rule_ruleNo').val("");
				$('#rule_ruleName').val("");
				$('#rule_rday').val("0");
				$('#rule_rhour').val("0");
				$('#rule_rminute').val("0");
				$('rule_fday').val("0");
				$('#rule_fhour').val("0");
				$('#rule_fminute').val("0");
				$('#rule_responseRate').val("0");
				$('#rule_completeRate').val("0");

				//清空规则列表
				$('#addRule_constraintsTable tbody').html('');
			});
			
		},
		
		
		/**
		 * @description 提交新增.
		 */
		saveSLARule:function(){
			itsm.sla.slaDetail_ruleGrid_Operation.checkBeforeSaveSLARule(itsm.sla.slaDetail_ruleGrid_Operation.saveSLARuleMethod);
		},
	

		/**
		 * @description 添加规则集.
		 */
		addToSLARuleList:function(){
			
			
			var propertyName = $('#addSLARule_team').val()+' '+$('#addSLARule_matical').val();
			var propertyValue = $('#addSLARule_propertyValue').val();
			
			if(propertyValue!="" || $('#addSLARule_team').val()=="etitle"){
				
			var key=$('#addSLARule_matical').val();
			
			
			if(key=="matches"){
				propertyValue=".*"+propertyValue+".*";
			}
			
			if(key=="matches start"){
				propertyValue=propertyValue+".*";
			}
			
			if(key=="matches end"){
				propertyValue=".*"+propertyValue;
			}
			
			
			i++;

			var trHTML=itsm.rules.ruleCM.replaceRuleStr(i,
					itsm.sla.slaDetail_ruleGrid_Operation.addAndEdit_matchPname(),
					'',
					itsm.rules.ruleCM.switchDataType('#addSLARule_team'),
					propertyName,
					itsm.sla.slaDetail_ruleGrid_Operation.addAndEdit_matchPvalue(),
					itsm.sla.slaDetail_ruleGrid_Operation.addAndEdit_matchPvalue(),
					propertyValue,
					"#constraint"+i
			);

			$("#addRule_constraintsTable tbody").append(trHTML);
			
			}else{
				
				msgAlert(i18n['label_rule_actionValueCanNotBeNull'],'info');
				
			}
		},

	
		/**
		 * @description 查找动集并显示.
		 */
		fillSLARuleData:function(url){
			
			$.post(url,function(res){	

				 var data=eval('('+res+')');
				 actionNo=data.actionNo;
				 
				 $('#rule_condition_rulePatternNo').val(data.rulePatternNo);
				 $('#rule_ruleNo').val(data.ruleNo);
				 $('#rule_ruleName').val(data.ruleName);
				 $('#rule_rday').val(data.rday);
				 $('#rule_rhour').val(data.rhour);
				 $('#rule_rminute').val(data.rminute);
				 $('#rule_fday').val(data.fday);
				 $('#rule_fhour').val(data.fhour);
				 $('#rule_fminute').val(data.fminute);
				 $('#rule_responseRate').val('0');
				 $('#rule_completeRate').val('0');
				 
				 if(data.responseRate!=null && data.responseRate!="null"){
					 $('#rule_responseRate').val(data.responseRate);
				 }
				 
				 if(data.completeRate!=null && data.completeRate!="null"){
					 $('#rule_completeRate').val(data.completeRate);
				 }
				 
				 $("input[name='rule_includeHoliday']").val([data.includeHoliday]);  
	
				 
	
				 for(var i=0;i<data.constraints.length;i++){
					 
					 if(data.constraints[i]!=null){
	
						 $('input[name="orand"]').val([data.constraints[i].andOr]);        //选中radio
						 
							var trHTML=itsm.rules.ruleCM.replaceRuleStr(data.constraints[i].conNo,
									itsm.rules.ruleCM.switchRuleName(data.constraints[i].propertyName),
									data.constraints[i].conNo,
									data.constraints[i].dataType,
									data.constraints[i].propertyName,
									data.constraints[i].propertyValueName,
									data.constraints[i].propertyValueName,
									data.constraints[i].propertyValue,
									"#constraint"+data.constraints[i].conNo
							);
						
						$("#addRule_constraintsTable tbody").append(trHTML);
						 
					 }
					 
				 }
	
			});
	
		},
		init:function(){
			
			//itsm.sla.slaDetail_ruleGrid_Operation.addSLARule_ruleTermSet();
			
			
			
			$('#addSLARule_team').change(function(){
				
				itsm.sla.slaDetail_ruleGrid_Operation.setSLAPVHTML();
				itsm.sla.slaDetail_ruleGrid_Operation.addSLARule_setTerm();
				
			});
			
			$('#slaDetail_ruleGrid_addRuleToList').click(itsm.sla.slaDetail_ruleGrid_Operation.addToSLARuleList);
			
			$('#slaDetail_ruleGrid_saveRule').click(itsm.sla.slaDetail_ruleGrid_Operation.saveSLARule);
			
			
		}
	
	};
	
}();

$(document).ready(itsm.sla.slaDetail_ruleGrid_Operation.init);