/**  
 * @author Van  
 * @constructor SLAServiceManage
 * @description SLA详细信息主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.sla');
$import("itsm.security.userUtil");

itsm.sla.slaDetail_updateGrid = function(){
	
	
	this.updateGrid_operation;
	
	
	
	
	return {
		
	
	
		/**
		 * 格式化逾期前，逾期后.
		 */
		formatBeforeOrAfterStr:function(cell){
			return cell=='逾期前升级'?i18n['label_slaRule_upgradeBeforeOverdue']:i18n['label_slaRule_upgradeAfterOverdue'];
		},
	
		/**
		 * 美化时间显示方式.
		 */
		timeStrFormatter:function(cell){
			
			return cell.replace('天',i18n['label_slaRule_days']).replace('小时',i18n['label_slaRule_hours']).replace('分钟',i18n['label_slaRule_minutes']);
		},
		
		
		/**
		 * @description 自动升级列表.
		 */
		showAutoUpdateGrid:function(){
			
	
			var params = $.extend({},jqGridParams, {	
				url:'promoteRule!findPromoteRulePage.action?contractNo='+_contractNo,
				caption:i18n['caption_autoUpdateGrid'],
				colNames:[i18n['title_sla_autoName'],i18n['title_sla_updateStyle'],i18n['title_sla_updateTime'],'','','','','',''],
				colModel:[
						  {name:'ruleName',width:70,align:'center'},
						  {name:'beforeOrAfterStr',width:120,align:'center',formatter:itsm.sla.slaDetail_updateGrid.formatBeforeOrAfterStr},
						  {name:'timeStr',width:120,align:'center',formatter:itsm.sla.slaDetail_updateGrid.timeStrFormatter},
						  {name:'beforeOrAfter',hidden:true},
						  {name:'time',hidden:true},
						  {name:'isIncludeHoliday',hidden:true},
						  {name:'assigneeNo',hidden:true},
						  {name:'assigneeName',hidden:true},
						  {name:'ruleNo',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "ruleNo"}),
				sortname:'ruleNo',
				pager:'#autoUpdateGridPager'
				});
				
				$("#autoUpdateGrid").jqGrid(params);
				$("#autoUpdateGrid").navGrid('#autoUpdateGridPager',navGridParams);
				//列表操作项
				$("#t_autoUpdateGrid").css(jqGridTopStyles);
				$("#t_autoUpdateGrid").append($('#autoUpdateGridToolbar').html());
				//自适应宽度
				setGridWidth("#autoUpdateGrid","regCenter",338);
				slaDetailGrids.push('#autoUpdateGrid');
		},
		
	
		/**
		 * @description 新增自动升级策略.
		 */
		addAutoUpdate_OpenWindow:function(){
			updateGrid_operation = "savePromoteRule";
			itsm.sla.slaDetail_updateGrid.resetAutoUpdateFrom();
			$('#autoUpdateWindow').window('open');
		
		},
		
	
		/**
		 * @description 保存自动升级.
		 */
		saveAutoUpdate:function(){
			
			var day=$('#promoteRuleDay').val();
			var hour=$('#promoteRuleHour').val();
			var minute=$('#promoteRuleMinute').val();
			
			if($('#autoUpdateForm').form('validate')){
				
				if(day!='0'||hour!='0'||minute!='0'){
					
					var frm = $('#autoUpdateWindow form').serialize();
					var _url="promoteRule!"+updateGrid_operation+".action";
	
					$.post(_url,frm, function(){
						
						$('#autoUpdateWindow').window('close');
						$('#autoUpdateGrid').trigger('reloadGrid');
						msgShow(i18n['msg_operationSuccessful'],'show');
						
					});
				}else{
					
					msgAlert(i18n['msg_msg_updateTimeCannotBeNull'],'info');
				}
			}
			
		},
		
		
		/**
		 * 清空表单.
		 */
		resetAutoUpdateFrom:function(){
			
			$('#promoteRule_ruleName').val('');
			$('#promoteRuleDay').val('0');
			$('#promoteRuleHour').val('0');
			$('#promoteRuleMinute').val('0');
			$('#promoteRule_assigneeName').val('');
			$('#promoteRule_assigneeNo').val('');
		},
		
		
		/**
		 * @description 打开编辑自动升级窗口.
		 */
		editAutoUpdate_OpenWindow:function(){
			
			checkBeforeEditGrid('#autoUpdateGrid',function(rowData){
				
				
				 itsm.sla.slaDetail_updateGrid.resetAutoUpdateFrom();
				
				 var time=rowData.time;
				 
				 $('#promoteRule_ruleNo').val(rowData.ruleNo);
				 $('#promoteRule_ruleName').val(rowData.ruleName);
				 $("input[name='promoteRuleDTO.beforeOrAfter']").val([rowData.beforeOrAfter]); 
				 
				 
				 if(time!=null&&time!='null'){
					 
					 $('#promoteRuleDay').val(time/86400);
					 $('#promoteRuleHour').val(time%86400/3600);
					 $('#promoteRuleMinute').val(time%86400%3600/60);
				 }else{
					 
					 $('#promoteRuleDay').val('0');
					 $('#promoteRuleHour').val('0');
					 $('#promoteRuleMinute').val('0');
				 }
				 
				 $("input[name='promoteRuleDTO.isIncludeHoliday']").val([rowData.isIncludeHoliday]);  
				 $('#promoteRule_assigneeName').val(rowData.assigneeName);
				 $('#promoteRule_assigneeNo').val(rowData.assigneeNo);

				 updateGrid_operation="mergePromoteRule";
				 $('#autoUpdateWindow').window('open');
			});
		},
	
		
		/**
		 * @description 删除自动升级.
		 */
		deleteAutoUpdate:function(){
			
			checkBeforeDeleteGrid('#autoUpdateGrid',function(rowIds){
				
				var _param = $.param({'ruleNos':rowIds},true);
				
				$.post("promoteRule!deletePromoteRules.action",_param,function(){
					
					$("#autoUpdateGrid").trigger('reloadGrid');
					
					msgShow(i18n['msg_deleteSuccessful'],'show');
					
				},"json");
			});
		},


		
		init:function(){
			
			
			itsm.sla.slaDetail_updateGrid.showAutoUpdateGrid();
			
			$('#autoUpdateGrid_add').click(itsm.sla.slaDetail_updateGrid.addAutoUpdate_OpenWindow);
			$('#autoUpdateGrid_edit').click(itsm.sla.slaDetail_updateGrid.editAutoUpdate_OpenWindow);
			$('#autoUpdateGrid_delete').click(itsm.sla.slaDetail_updateGrid.deleteAutoUpdate);
			$('#autoUpdateGrid_save').click(itsm.sla.slaDetail_updateGrid.saveAutoUpdate);
			
			
			$('#promoteRule_assigneeName').click(function(){
				itsm.security.userUtil.selectUser('#promoteRule_assigneeName','#promoteRule_assigneeNo','','loginName');
			});
			
		}
	};
	
 }();

