/**  
 * @author Van  
 * @constructor Van
 * @description SLA管理主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */

$package('itsm.sla');
$import('itsm.rules.ruleCM');


itsm.sla.slaMain=function(){
	 
	this.operation="";
	this.operationCounts="0";
	
	
	
	return {
		
	
		
		/**
		 * 动作格式化
		 */
		slaActionFormatter:function(cell,event,data){
			return $('#contractGridFormatter').html();
//			return actionFormat('1','1')
//			.replace('[edit]','itsm.sla.slaMain.editSlaOpenWindow()')
//			.replace('[delete]','itsm.sla.slaMain.deleteSLAInline('+data.contractNo+')');
		},
	
	
		/**
		 * @description 加载服务协议列表.
		 */
		showContractGrid:function(){
	
			var params = $.extend({},jqGridParams, {	
			url:'slaContractManage!find.action',
			caption:i18n['caption_slaGrid'],
			colNames:[i18n['title_sla_name'],i18n['title_sla_org'],i18n['title_sla_version'],i18n['title_sla_startTime'],i18n['title_sla_endTime'],i18n['common_action'],'','',''],
			colModel:[{name:'contractName',width:120,align:'center'},
					  {name:'serviceOrgName',width:100,align:'center',sortable:false},
					  {name:'versionNumber',width:100,align:'center'},
					  {name:'beginTime',width:100,align:'center',formatter:timeFormatter},
					  {name:'endTime',width:100,align:'center',formatter:timeFormatter},
					  {name:'act',align:'center',formatter:itsm.sla.slaMain.slaActionFormatter},
					  {name:'agreement' ,hidden:true},
					  {name:'rulePackageNo',hidden:true},
					  {name:'contractNo',hidden:true}
					  ],
			jsonReader: $.extend(jqGridJsonReader, {id: "contractNo"}),
			sortname:'contractNo',
			pager:'#contractGridPager'
			});
			$("#contractGrid").jqGrid(params);
			$("#contractGrid").navGrid('#contractGridPager',navGridParams);
			//列表操作项
			$("#t_contractGrid").css(jqGridTopStyles);
			$("#t_contractGrid").append($('#contractGridToolbar').html());
			//自适应宽度
			setGridWidth("#contractGrid","regCenter",10);
		},
		
		
		
	
		
		/**
		 * @description 打开新增SLA窗口
		 */
		addSlaOpenWindow:function(){
			
			
			//清空数据
			$('#slaContract_contractNo').val("");
			$('#slaContract_contractName').val("");
			
			$('#slaContract_serviceOrgName').val("");
			$('#slaContract_serviceOrgNo').val("");
			
			$('#slaContract_versionNumber').val("");
			$('#slaContract_beginTime').val("");
			$('#slaContract_endTime').val("");
			$('#slaContract_agreement').val("");
			
			operation="save";
			
			$('#saveOreditBtn').linkbutton({text:i18n['label_sla_save'],iconCls:'icon-ok'});
			$('#SLAOperationWindow').window({title: i18n['label_sla_addSLA']});
			
			$('#SLAOperationWindow').window('open');
			
			
			if(operationCounts=="0"){
	
				itsm.sla.slaMain.showByServicesOrgGrid();
				$('#byServicesOrgGrid').jqGrid().clearGridData();
				operationCounts="1";
				
			}else{
				
				$("#byServicesOrgGrid").trigger('reloadGrid');
			}
			
			$('#slaMain_tabs').tabs();
		},
	
		/**
		 * @description 打开编辑SLA窗口.
		 */
		editSlaOpenWindow:function(){
			
		
			checkBeforeEditGrid('#contractGrid',function(rowData){
				
				if(operationCounts=="0"){
					operationCounts="1";
					itsm.sla.slaMain.showByServicesOrgGrid();
				}
				
				
				var url = 'slaContractManage!findSlaById.action?contractNo='+rowData.contractNo;
				$.post(url,function(res){
					
					operation="merge";
					$('#slaContract_contractNo').val(res.contractNo);
					$('#slaContract_contractName').val(res.contractName);
					$('#slaContract_versionNumber').val(res.versionNumber);
					
					if(res.beginTime!=null && res.beginTime!='null'){
						
						$('#slaContract_beginTime').val(timeFormatter(res.beginTime));
						
					}else{
						
						$('#slaContract_beginTime').val("");
					}
					
					if(res.endTime!=null && res.endTime!='null'){
						
						$('#slaContract_endTime').val(timeFormatter(res.endTime));
						
					}else{
						$('#slaContract_endTime').val("");
					}
					
					$('#slaContract_agreement').val(res.agreement);
					$('#slaContract_serviceOrgName').val(res.serviceOrgName);
					$('#slaContract_serviceOrgNo').val(res.serviceOrgNo);
					$('#SLAOperationWindow').window({title:i18n['label_sla_editSLA']});
					$('#saveOreditBtn').linkbutton({text:i18n['label_sla_saveEdit'],iconCls:'icon-save'});
	
					$('#SLAOperationWindow').window('open');
					//填充GRID
					var grid_url="slaContractManage!findByOrgServices.action?contractNo="+rowData.contractNo;
					$('#byServicesOrgGrid').jqGrid('setGridParam',{url:grid_url}).trigger('reloadGrid');
				});
				
			});
			
		},
	
		
		
		/**
		 * @description 提交保存SLA.
		 */
		saveSla:function(){
			
			if($('#SLAOperationForm').form('validate')){
			
	
				//清空数据
				var conName=$.trim($('#slaContract_contractName').val());
				var orgNo=$.trim($('#slaContract_serviceOrgNo').val());
				
				if(conName==''||orgNo==''){
		
					msgAlert(i18n['msg_validateSLA'],'info');
					
				}else{
					
				
					var ids = $("#byServicesOrgGrid").getDataIDs();
			
					$('#byServicesNosStr').val(ids);
					
					
					var contract = $('#SLAOperationDiv form').getForm();
					var url="slaContractManage!"+operation+".action";
			
					
					
					var msgStr=i18n["msg_addSuccessful"];
					
					if(operation=="merge"){msgStr=i18n["msg_editSuccessful"];}
					
					
					$.post(url,contract,function(){
						
						$("#contractGrid").trigger('reloadGrid');
						
						$('#SLAOperationWindow').window('close');
						
						
						//清空数据
						$('#slaContract_contractNo').val("");
						$('#slaContract_contractName').val("");
						
						$('#slaContract_serviceOrgName').val("");
						$('#slaContract_serviceOrgNo').val("");
						
						$('#slaContract_versionNumber').val("");
						$('#slaContract_beginTime').val("");
						$('#slaContract_endTime').val("");
						$('#slaContract_agreement').val("");
						
						var grid_url="slaContractManage!findByOrgServices.action?contractNo=0";
						
						$('#byServicesOrgGrid').jqGrid('setGridParam',{url:grid_url}).clearGridData();
						
						msgShow(msgStr,'show');
		
					});
		
				}
			
			}else{
				
				$('#slaMain_tabs').tabs('select',slaBaseInfo);
			}
			
		},
		
		
		
		/**
		 * @description 删除SLA.
		 */
		deleteSLA:function(){
			
			checkBeforeDeleteGrid('#contractGrid',function(rowIds){
				
				var _param = $.param({'contractNos':rowIds},true);
				$.post("slaContractManage!delete.action",_param,function(data){
					if(data){
						$("#contractGrid").trigger('reloadGrid');
						msgShow(i18n['msg_deleteSuccessful'],'show');
					}else{
						msgAlert(i18n['msg_canNotDeleteSystemData'],'info');
					}
				},"json");	
			});
		},
		
	
		/**
		 * 行内删除.
		 */
		deleteSLAInline:function(rowId){
			
			confirmBeforeDelete(function(){
				itsm.sla.slaMain.deleteSLAMethod(rowId);
			});
		},
		
		
	
		/**
		 * @description 执行搜索.
		 */
		searchSLA:function(){
			var sdata = $('#searchContractDiv form').getForm();
			var postData = $("#contractGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
			var _url = 'slaContractManage!find.action';
			$('#contractGrid').trigger('reloadGrid');
			$("#searchContractDiv").window('close');
			$('#contractName').val("");
			$('#contractOrg').val("");
			$('#contractSlaSort').val("");
			sdata = $('#searchContractDiv form').getForm(); 
			$.extend(postData, sdata); 
		},
		
		/**
		 * @description 转到查看SLA详情页面.
		 */
		showSLADetail:function(){
			
			var gr = jQuery("#contractGrid").jqGrid('getGridParam','selrow');
			
			if(gr==null){
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}else{
				var row=$("#contractGrid").getRowData(gr);
				var url ="slaContractManage!findSLAContractShowRules.action?contractNo="+row.contractNo;
				refreshTab(i18n['title_sla_slaDetail'],url);
			}
		},
	
		/**
		 * @description 选择服务机构.
		 */
		selectServiceOrg_OpenWindow:function(){
			
			itsm.rules.ruleCM.selectServiceOrg('#selectServiceOrgTreeDiv','#selectServiceOrgDiv','#slaContract_serviceOrgNo','#slaContract_serviceOrgName');
		},
		
		/**
		 * @description 选择被服务机构.
		 */
		selectByServiceOrg:function(){
			
			$('#selectByServiceOrgTreeDiv').jstree({
				"json_data":{
				    ajax: {url : "organization!findAll.action"}
				},
				"plugins" : [ "themes", "json_data", "checkbox" ] 
				}).bind('loaded.jstree', function(e,data){data.inst.open_all(-1);});			
		},
		
		/**
		 * @description 打开加入被服务机构窗口.
		 */
		selectByServiceOrg_OpenWindow:function(){
			
			$('#selectByServiceOrgDiv').window('open');	
			itsm.sla.slaMain.selectByServiceOrg();
		},

		/**
		 * @description 加载被服务机构.
		 */
		showByServicesOrgGrid:function(){
			
			var params = $.extend({},jqGridParams, {	
				url:'slaContractManage!findByOrgServices.action',
				caption:i18n['title_sla_byServiceOrg'],
				colNames:['ID',i18n['title_sla_orgName']],
				colModel:[{name:'orgNo',width:100,align:'center'},
				          {name:'orgName',width:300,align:'center'}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "orgNo"}),
				sortname:'orgNo',
				pager:'#byServicesOrgGridPager',
				autowidth:false,
				width:548
				});
				$("#byServicesOrgGrid").jqGrid(params);
				$("#byServicesOrgGrid").navGrid('#byServicesOrgGridPager',navGridParams);
				//列表操作项
				$("#t_byServicesOrgGrid").css(jqGridTopStyles);
				$("#t_byServicesOrgGrid").append($('#byServicesOrgGridToolbar').html());
				
				
				$('#byServicesOrgGrid_add').click(itsm.sla.slaMain.selectByServiceOrg_OpenWindow);
				$('#byServicesOrgGrid_remove').click(itsm.sla.slaMain.deleteByServices);
				$('#selectByServiceOrg_getSelectedNodes').click(itsm.sla.slaMain.getSelectedNodes);
				
		},
	
		
		/**
		 * @description 获取已经选择的.
		 */
		getSelectedNodes:function(){
			
			$("#selectByServiceOrgTreeDiv").jstree("get_checked",false,true).each(function (i,n) { 
				
				 var node = jQuery(this); 
				 var orgType=node.attr('orgType');
				 
				 var flag="";
				 if(orgType=="ROOT"){//查找所有
					 
					 flag="all";
					 
				 }else if(orgType=="innerPanel"){//查找内部机构
					 
					 flag="inner";
					 
				 }else if(orgType=="servicePanel"){//查找所有服务机构
					 
					 flag="service";
					
				 }else{//仅加载树内容
					 
					var orgNo=node.attr('orgNo');
					var orgName=node.attr('orgName');
					 
					var row=$("#byServicesOrgGrid").getRowData(orgNo);  //根据ID拿到一行的数据  
					if(row.orgNo==null){
						
						var dataRow = {orgNo:orgNo,orgName:orgName}; 
						$("#byServicesOrgGrid").jqGrid("addRowData",orgNo, dataRow, "first"); 
					}
				 }
	
				 //查找
				 if(flag!=""){
					 itsm.sla.slaMain.fillByServicesOrganization(flag);
				 }
			});
			
			$('#selectByServiceOrgDiv').window('close');
			
		},
		
		/**
		 * 填充被服务机构列表.
		 */
		fillByServicesOrganization:function(flag){
			
			 var url="organization!findOrganizationsByType.action?orgType="+flag;
			 
			 $.post(url,function(res){
					
					for(var i=0;i<res.length;i++){
						
						var row=$("#byServicesOrgGrid").getRowData(res[i].orgNo);  //根据ID拿到一行的数据  判断是否已经存在
						if(row.orgNo==null){
							
							var dataRow = {orgNo:res[i].orgNo,orgName:res[i].orgName}; 
							$("#byServicesOrgGrid").jqGrid("addRowData",res[i].orgNo, dataRow, "first"); 
						}
					}
				});
		},
	
		
		/**
		 * @description 移除服务机构.
		 */
		deleteByServices:function(){
			
			
			checkBeforeDeleteGrid('#byServicesOrgGrid',function(rowIds){
				
				for(var i=0;i<rowIds.length;i++){
					
					$("#byServicesOrgGrid").delRowData(rowIds[i]);
				}
			});
			
			
		},
		
		init:function(){
			
			
			$("#contarctManage_loading").hide();
			$("#contarctManage_content").show();
			
			itsm.sla.slaMain.showContractGrid();	
			
			$('#contractGrid_add').click(itsm.sla.slaMain.addSlaOpenWindow);
			$('#contractGrid_edit').click(itsm.sla.slaMain.editSlaOpenWindow);
			$('#contractGrid_delete').click(itsm.sla.slaMain.deleteSLA);
			$('#contractGrid_search').click(function(){
				$("#searchContractDiv").window('open');
			});
			$('#contractGrid_showSLADetail').click(itsm.sla.slaMain.showSLADetail);
			$('#contractGrid_doSearch').click(itsm.sla.slaMain.searchSLA);//搜索
			$('#contractGrid_doSave').click(itsm.sla.slaMain.saveSla);
			
//			$('#contractGrid_act_edit').click(itsm.sla.slaMain.editSlaOpenWindow);
//			$('#contractGrid_act_delete').click(itsm.sla.slaMain.deleteSLA);
			
			$('#slaContract_serviceOrgName').click(itsm.sla.slaMain.selectServiceOrg_OpenWindow);
		}
	
	};
	
	
 }();
 
 $(document).ready(itsm.sla.slaMain.init);
