 /**  
 * @fileOverview snmp/networkManage.jsp
 * @author Tan
 * @version 1.0  
 */  
 /**  
 * @author Tan  
 * @constructor networkManage
 * @description snmp/networkManage.jsp
 * @date 2010-11-17
 * @since version 1.0 
 */
var networkManage=function(){
	
	/**
	 * @description 扫描IP
	 * */
	this.scanIp=function(){
		$('#scanResult').text(i18n['label_snmp_startScan']);
		$.post('snmp!scanIp.action',function(data){
			if(data!=null){
				$('#scanResult').text(i18n['label_snmp_scanComplete']+data.length);
			}else
				$('#scanResult').text(i18n['label_snmp_scanComplete']+'0');
		})
	}
	/**
	 * @description 获取已保存的IP
	 * */
	this.lanIp=new Array();
	this.getLanIp=function(){
		$.post('snmp!getLanIp.action',function(data){
			lanIp=data;
			this.strHtml;
			strHtml='';
			if(lanIp!=null){
				
				for(var i=0;i<lanIp.length;i++){
					if(i==0)
						setDefaultIp(lanIp[i].ipAddress);
					if(i % 8==0){
						strHtml=strHtml+"<tr>"
					}
					strHtml=strHtml+"<td class='client' align='center' width='100px' >"+
							"<table><tr><td colspan='2' id='clientSelect' style='cursor: pointer;' onClick=setLocIp('"+lanIp[i].ipAddress+"') title='"+i18n['common_view']+"'>"+
							"<img src='../images/comm/company.png'/></td></tr>"+
							"<tr><td><span>"+lanIp[i].hostName+"</span><br>"+
							"<span>"+lanIp[i].ipAddress+"</span></td>"+
							"<td><input type='checkbox' class='companyName' value='"+lanIp[i].lansId+"' /></td>"+
							"</tr></table><td>"
				}
				$('#client').html(strHtml);
			}
		})
	}
	
	this.checkIP=function(ip) 
	{ 
		obj=ip;
		var exp=/^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/; 
		var reg = obj.match(exp); 
		if(reg==null) 
		{ 
			return false;
		} 
		else 
		{ 
			return true;
		} 
	}
	
	/**
	 * @description 添加主机
	 * */
	this.addClient=function(){
		
		if(checkIP($('#client_ipAddress').val())){
			var client_form = $('#add_client_win form').serialize();
			$.post('snmp!save.action', client_form, function(){
				
				msgShow(i18n['msg_add_successful'],'info');
				
				$('#add_client_win').window('close');
				getLanIp();
			});
		}else{
			$('#client_ipAddress_check').text(i18n['label_snmp_ipIllegal']);
		}
			
	}
	
	/**
	 * @description 删除主机
	 * */
	this.deleteClient=function(){
		var lanIpIds="";
		
		$(".companyName").each(function(i,n){ 
			//由于复选框一般选中的是多个,所以可以循环输出
			if($(this).attr('checked')){
				if(lanIpIds=="")
					lanIpIds='lanIps='+$(this).val();
				else
					lanIpIds=lanIpIds+"&lanIps="+$(this).val();
			}	
		});
		
		if(lanIpIds==""){
			
			msgAlert(i18n['msg_snmp_chooseServerToDelete'],'info');
			
		}else{
			
			$.messager.confirm(i18n['msg_msg'], i18n['msg_snmp_confirmDlete'], function(r){
				if (r){
					$.post('snmp!delete.action',lanIpIds,function(){
						
						getLanIp();
						msgShow(i18n['deleteSuccess'],'show');
					})
					
				}
			});
		}
	}
	
	
	/**
	 * @description TABS切换ID
	 * */
	this.tabsEvent=function(){
		$('#sysProperties').tabs({
			onSelect:function(title){
				if(title==i18n['title_snmp_process'])
					hrSWRunTable();
				if(title==i18n['title_snmp_service'])
					svSvcTable();
				if(title==i18n['title_snmp_installSoftwares'])
					hrSWInstalledTable();
				if(title==i18n['title_snmp_device'])
					hrDervice();
				if(title==i18n['title_snmp_save'])
					hrStorage();
				if(title==i18n['title_snmp_ICMPCount'])
					icmp();
				if(title==i18n['title_snmp_TCPCount'])
					tcp();
				if(title==i18n['title_snmp_UDPCount'])
					udp();
				if(title==i18n['title_snmp_SNMPCount'])
					snmp();
				if(title==i18n['title_snmp_IP'])
					ipAddrTable();
				if(title==i18n['title_snmp_IPRouting'])
					ipRouteTable();
				if(title==i18n['title_snmp_IPMedia'])
					ipNetToMediaTable();
				if(title==i18n['title_snmp_IPCount'])
					ipStat();
				if(title==i18n['title_snmp_interface'])
					interfaces();
				if(title==i18n['title_snmp_TCPTabel'])
					tcpTable();
				if(title==i18n['title_snmp_UDPTabel'])
					udpTable();
				if(title==i18n['title_snmp_help'])
					help();
			}	
		});
	}
	
	var ip;
	
	/**
	 * @description 设置默认IP
	 * */
	this.setDefaultIp=function(setip){
		ip=setip;
		$('#locHostIp').text(ip);
		getSystem();
		connTest();
		
	}
	
	/**
	 * @description 设置当前IP
	 * */
	this.setLocIp=function(setip){
		ip=setip;
		$('#locHostIp').text(ip);
		getSystem();
		connTest();
		hrSWRunTable();
	}
	
	
	/**
	 * @description 测试当前IP是否连接成功
	 * */
	this.connTest=function(){
		$('#snmpTestResult_no').text('');
		$('#snmpTestResult_yes').text(i18n['label_snmp_connection']);
		$.post('snmp!connTest.action','ip='+ip,function(result){
			
			if(result==true){
				$('#snmpTestResult_yes').text(i18n['label_snmp_okey']);
				$('#snmpTestResult_no').text('');
			}else{
				$('#snmpTestResult_no').text(i18n['label_snmp_connectionFailure']);
				$('#snmpTestResult_yes').text('');
			}	
				
		})
	}
	/**
	 * @description 系统描述
	 * */
	
	this.getSystem=function(){
		if(ip!=undefined){
			/**sysdescr*/
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.1&oidindex=7&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					if(data[0]==undefined){
						$('#sysdescr').val('');
						$('#sysObjectID').val('');
						$('#sysUpTime').val('');	
						$('#sysContact').val('');
						$('#sysName').val('');
						$('#sysLocation').val('');
						$('#sysService').val('');
					}else{
						$('#sysdescr').val(data[0].desc);
						$('#sysObjectID').val(data[1].desc);
						$('#sysUpTime').val(data[2].desc);	
						$('#sysContact').val(data[3].desc);
						$('#sysName').val(data[4].desc);
						$('#sysLocation').val(data[5].desc);
						$('#sysService').val(data[6].desc);
					}
				}else{
					$('#sysdescr').val('');
					$('#sysObjectID').val('');
					$('#sysUpTime').val('');	
					$('#sysContact').val('');
					$('#sysName').val('');
					$('#sysLocation').val('');
					$('#sysService').val('');
				}
					
			})
		}
	}
	
	/**
	 * @description hrSWRunTable进程,进程开始OID是：1.3.6.1.2.1.25.4.2.1，查询的节点是第10
	 * 查询出来分别是： hrSWRunIndex\hrSWRunName\hrSWRunID\hrSWRunPath\hrSWRunParameters\hrSWRunType
	 * \hrSWRunStatus\hrSWRunPerfCPU\hrSWRunPerfMem
	 **/
	this.hrSWRunTable=function(){
		if(ip!=undefined){
		/**hrSWRunName*/
		$.post('snmp!getMIBproc.action','stroids=1.3.6.1.2.1.25.4.2.1&oidindex=10&ifChangeCN=false&ip='+ip,function(data){
			if(data!=null){
				this.rem;
				rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_processID']+"</th><th>"+i18n['title_snmp_processName']+"</th><th>"+i18n['title_snmp_productID']+"</th><th>"+i18n['title_snmp_url']+"</th><th>"+i18n['title_snmp_parameters']+"</th>"+
				"<th>"+i18n['title_snmp_type']+"</th><th>"+i18n['title_snmp_state']+"</th><th>"+i18n['title_snmp_CPU']+"</th><th>"+i18n['title_snmp_memory']+"</th></tr>";
				var each=data.length/9;
				for(var i=0;i<each;i++)
				{	
					rem=rem+"<tr>"+
					"<td>"+(i+1)+"</td>"+
					"<td>"+data[i].desc+"</td>"+
					"<td>"+data[i+each].desc+"</td>"+
					"<td>"+data[i+each*2].desc+"</td>"+
					"<td>"+data[i+each*3].desc+"</td>"+
					"<td>"+data[i+each*4].desc+"</td>"+
					"<td>"+data[i+each*5].desc+"</td>"+
					"<td>"+data[i+each*6].desc+"</td>"+
					"<td>"+data[i+each*7].desc+"</td>"+
					"<td>"+data[i+each*8].desc+"</td></tr>"
				}
				rem=rem+"</table>"
				$('#hrSWRunTable').html(rem);
			}
		})
		}
	}

	/**
	 * @description hrSWInstalledTable安装软件
	 * 进程开始OID是：1.3.6.1.2.1.25.4.2.1，查询的节点是第10
	 * 查询出来分别是： 
	 **/
	this.hrSWInstalledTable=function(){
		if(ip!=undefined){
		/**hrSWRunName*/
		$.post('snmp!getMibInstalled.action','stroids=1.3.6.1.2.1.25.6.3.1&oidindex=9&ifChangeCN=false&ip='+ip,function(data){
			if(data!=null){
				this.rem;
				rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_name']+"</th><th>ID</th><th>"+i18n['title_snmp_type']+"</th><th>"+i18n['title_snmp_date']+"</th></tr>";
				var each=data.length/5;
				for(var i=0;i<each;i++)
				{	
					rem=rem+"<tr>"+
					"<td>"+(i+1)+"</td>"+
					"<td>"+data[i].desc+"</td>"+
					"<td>"+data[i+each].desc+"</td>"+
					"<td>"+data[i+each*2].desc+"</td>"+
					"<td>application("+data[i+each*3].desc+")</td>"+
					"<td>"+data[i+each*4].desc+"</td></tr>"
				}
				rem=rem+"</table>"
				$('#hrSWInstalledTable').html(rem);
			}
		})
		}
	}
	
	/**
	 * @description  svSvcTable服务
	 * 进程开始OID是：1.3.6.1.4.1.77.1.2.3.1，查询的节点是第11
	 * 查询出来分别是： svSvcName\svSvcInsatlledState\svSvcOperatingSatae\svSvcCanBeUninstalled\svSvcCanBePaused
	 */
	this.svSvcTable=function(){
		if(ip!=undefined){
			/**hrSWRunName*/
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.4.1.77.1.2.3.1&oidindex=10&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_name']+"</th><th>"+i18n['title_snmp_installState']+"</th><th>"+i18n['title_snmp_operationState']+"</th><th>"+i18n['title_snmp_uninstallable']+"</th><th>"+i18n['title_snmp_stopable']+"</th></tr>";
					var each=data.length/5;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>installed("+data[i+each].desc+")</td>"+
						"<td>active("+data[i+each*2].desc+")</td>"+
						"<td>can be uninstalled("+data[i+each*3].desc+")</td>"+
						"<td>can be paused("+data[i+each*4].desc+")</td></tr>"
					}
					rem=rem+"</table>"
					$('#svSvcTable').html(rem);
				}
			})
		}
	}
	
	/**
	 * @description 设备
	 * */
	this.hrDervice=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.25.3.2.1.1&oidindex=9&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_description']+"</th><th>"+i18n['title_snmp_productID']+"</th><th>"+i18n['title_snmp_state']+"</th><th>"+i18n['title_snmp_errorCount']+"</th></tr>";
					var each=data.length/6;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>"+data[i+each*3].desc+"</td>"
						switch(data[i+each*4].desc){
							case "1":
								rem=rem+"<td>unknown("+data[i+each*4].desc+")</td>";
								break;
							case "2":
								rem=rem+"<td>running("+data[i+each*4].desc+")</td>";
								break;
							default:
								rem=rem+"<td>"+data[i+each*4].desc+"</td>"
								break;
						}
						
						rem=rem+"<td>"+data[i+each*5].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#hrDervice').html(rem);
				}
			})
		}
	}
	
	
	/**
	 * 容量转换法
	 */
	this.capacityChange=function(type,capacitySize){
//		alert(type);
//		if(type.indexOf("Label: Serial Number")>=0){
//			if(capacitySize>0){
//				return Math.floor((capacitySize*1+1)/1024*4)
//			}else
//			{
//				return "0";
//			}
//		}else{
//			return capacitySize;
//		}
		return capacitySize;
	}
	/**
	 * @description 存储
	 * */
	this.hrStorage=function(){
		if(ip!=undefined){
			$.post('snmp!getMIBstorage.action','stroids=1.3.6.1.2.1.25.2.3.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_description']+"</th><th>"+i18n['title_snmp_distribution']+"</th><th>"+i18n['title_snmp_allMemory']+"</th><th>"+i18n['title_snmp_usedMemory']+"</th>"+
						"<th>"+i18n['title_snmp_allocationFailures']+"</th><th>"+i18n['title_snmp_useRate']+"</th></tr>";
					var each=data.length/7;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>"+data[i+each*3].desc+"</td>"+
						"<td>"+capacityChange(data[i+each*2].desc,data[i+each*4].desc)+"</td>"+
						"<td>"+capacityChange(data[i+each*2].desc,data[i+each*5].desc)+"</td>"+
						"<td>"+data[i+each*6].desc+"</td>"
						if(data[i+each*4].desc!="0")
							rem=rem+"<td>"+Math.ceil(data[i+each*5].desc/data[i+each*4].desc*100)+"%</td></tr>"
						else
							rem=rem+"<td>0%</td></tr>"
					}
					rem=rem+"</table>"
					$('#hrStorage').html(rem);
				}
			})
		}
	}
	
	/**
	 * @description ICMP统计
	 * */
	this.icmp=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.5&oidindex=7&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_result']+"</th></tr>";
					var each=data.length;
					var index=new Array('icmpInMsgs','icmpInErrors','icmpInDestUnreachs','icmpInTimeExcds','icmpInParmProbs','icmpInSrcQuenchs',
							'icmpInRedirects','icmpInEchos','icmpInEchoReps','icmpInTimestamps','icmpInTimestampReps','icmpInAddrMasks',
							'icmpInAddrMaskReps','icmpOutMsgs','icmpOutErrors','icmpOutDestUnreachs','icmpOutTimeExcds','icmpOutParmProbs',
							'icmpOutSrcQuenchs','icmpOutRedirects','icmpOutEchos','icmpOutEchoReps','icmpOutTimestamps','icmpInTimestampReps',
							'icmpOutAddrMasks','icmpOutAddrMaskReps');
					for(var i=0;i<26;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+index[i]+"</td>"+
						"<td>"+data[i].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#icmp').html(rem);
				}
			})
		}
	}
	
	/**
	 * @description TCP统计
	 * */
	this.tcp=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndEndoids.action','stroids=1.3.6.1.2.1.6&endoids=1.3.6.1.2.1.6.12.0&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_result']+"</th></tr>";
					var each=data.length;
					var index=new Array('tcpRtoAlgorithm','tcpRtoMin','tcpRtoMax','tcpRtoMaxConn','tcpActiveOpens','tcpPassiveOpens',
							'tcpAttemptFails','tcpEstabResets','tcpCurrEstab','tcpInSegs','tcpOutSegs','tcpRetransSegs');
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+index[i]+"</td>"+
						"<td>"+data[i].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#tcp').html(rem);
				}
			})
		}
	}
	/**
	 * @description UDP统计
	 * */
	this.udp=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndEndoids.action','stroids=1.3.6.1.2.1.7.1&endoids=1.3.6.1.2.1.7.4.0&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_result']+"</th></tr>";
					var each=data.length;
					var index=new Array('udpInDatagrams','udpNoPorts','udpInErrors','udpOutDatagrams');
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+index[i]+"</td>"+
						"<td>"+data[i].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#udp').html(rem);
				}
			})
		}
	}
	/**
	 * @description SNMP统计
	 * */
	this.snmp=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndEndoids.action','stroids=1.3.6.1.2.1.11.1&endoids=1.3.6.1.2.1.11.29.0&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_result']+"</th></tr>";
					var each=data.length;
					var index=new Array('snmpInPkts','snmpOutPkts','snmpInBadVersions','snmpInBadCommunityNames','snmpInBadCommunityUser',
							'snmpInASNParseErrs','snmpInTooBigs','snmpInNoSuchNames','snmpInBadValues','snmpInReadOnlys',
							'snmpInGenErrs','snmpInTotalReqVars','snmpInTotalSetVars','snmpInGetRequests','snmpInGetNexts',
							'snmpInSetRequests','snmpInGetResponses','snmpInTraps','snmpOutTooBigs','snmpOutNoSuchNames',
							'snmpOutBadValues','snmpOutGenErrs','snmpOutGetRequests','snmpOutGetNexts','snmpOutSetRequests',
							'snmpOutGetResponses','snmpOutTraps');
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+index[i]+"</td>"+
						"<td>"+data[i].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#snmp').html(rem);
				}
			})
		}
	}
	/**
	 * @description IP地址
	 * */
	
	this.ipAddrTable=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.4.20.1.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_name']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_mask']+"</th><th>"+i18n['title_snmp_broadcastAddress']+"</th><th>"+i18n['title_snmp_maxSize']+"</th></tr>";
					var each=data.length/5;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*1].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>"+data[i+each*3].desc+"</td>"+
						"<td>"+data[i+each*4].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#ipAddrTable').html(rem);
				}
			})
		}
	}
	/**
	 * @description IP路由
	 * */
	this.ipRouteTable=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.4.21.1.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_targetAddress']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>Mric1</th><th>Metric2</th><th>Metric3</th>"+
					"<th>Metric4</th><th>"+i18n['title_snmp_nextJump']+"</th><th>"+i18n['title_snmp_type']+"</th><th>"+i18n['title_snmp_agreement']+"</th><th>Age</th><th>"+i18n['title_snmp_mask']+"</th><th>Metric5</th><th>"+i18n['title_snmp_info']+"</th></tr>";
					var each=data.length/13;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*1].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>"+data[i+each*3].desc+"</td>"+
						"<td>"+data[i+each*4].desc+"</td>"+
						"<td>"+data[i+each*5].desc+"</td>"+
						"<td>"+data[i+each*6].desc+"</td>"+
						"<td>"+data[i+each*7].desc+"</td>"+
						"<td>"+data[i+each*8].desc+"</td>"+
						"<td>"+data[i+each*9].desc+"</td>"+
						"<td>"+data[i+each*10].desc+"</td>"+
						"<td>"+data[i+each*11].desc+"</td>"+
						"<td>"+data[i+each*12].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#ipRouteTable').html(rem);
				}
			})
		}
	}
	/**
	 * @description IP介质
	 * */
	this.ipNetToMediaTable=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.4.22.1.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>MAC</th><th>"+i18n['title_snmp_netAddress']+"</th><th>"+i18n['title_snmp_type']+"</th></tr>";
					var each=data.length/4;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*1].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>dynamic("+data[i+each*3].desc+")</td></tr>"
					}
					rem=rem+"</table>"
					$('#ipNetToMediaTable').html(rem);
				}
			})
		}
	}
	
	/**
	 * @description IP统计
	 * */
	this.ipStat=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndEndoids.action','stroids=1.3.6.1.2.1.4.1&endoids=1.3.6.1.2.1.4.19.0&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_result']+"</th></tr>";
					var each=data.length;
					var index=new Array('ipForwarding','ipDefaultTTL','ipInReceives','ipInHdrErrors','ipAddrErrors',
							'ipForwDatagrams','ipInUnknownProtos','ipInDiscards','ipInDelivers','ipOutRequests',
							'ipOutDiscards','ipOutNoRoutes','ipReasmTimeout','ipReasmReqds','ipReasmOKs',
							'ipReasmFails','ipFragOKs','ipFragFails','ipFragCreates');
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+index[i]+"</td>"+
						"<td>"+data[i].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#ipStat').html(rem);
				}
			})
		}
	}
	
	
	/**
	 * @description 接口
	 * */
	this.interfaces=function(){
		if(ip!=undefined){
			$.post('snmp!getMIBinterfaces.action','stroids=1.3.6.1.2.1.2.2.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_Index']+"</th><th>"+i18n['title_snmp_description']+"</th><th>"+i18n['title_snmp_type']+"</th><th>MTU</th><th>"+i18n['title_snmp_speed']+"</th>"+
					"<th>MAC</th><th>"+i18n['title_snmp_manageState']+"</th><th>"+i18n['title_snmp_operationState']+"</th><th>"+i18n['title_snmp_lastChangeTime']+"</th><th>"+i18n['title_snmp_receiveBytes']+"</th>"+
					"<th>"+i18n['title_snmp_receivedMulticast']+"</th><th>"+i18n['title_snmp_receivedNoneMulticast']+"</th><th>"+i18n['title_snmp_receiveDiscard']+"</th><th>"+i18n['title_snmp_receiveErrors']+"</th><th>"+i18n['title_snmp_receiveAddressAgreements']+"</th>"+
					"<th>"+i18n['title_snmp_outputBytes']+"</th><th>"+i18n['title_snmp_outputMulticast']+"</th><th>"+i18n['title_snmp_outputNoneMulticast']+"</th><th>"+i18n['title_snmp_outputDiscard']+"</th><th>"+i18n['title_snmp_outputErrorCount']+"</th>"+
					"<th>"+i18n['title_snmp_outputPackageLength']+"</th><th>"+i18n['title_snmp_specifications']+"</th></tr>";
					var each=data.length/22;
					
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*1].desc+"</td>"
						switch(data[i+each*2].desc){
						    case "1":
						    	rem=rem+"<td>other("+data[i+each*2].desc+")</td>";
						    	break;
						    case "2":
						    	rem=rem+"<td>regular1822("+data[i+each*2].desc+")</td>";
						    	break;
						    case "3":
						    	rem=rem+"<td>hdh1822("+data[i+each*2].desc+")</td>";
						    	break;
						    case "4":
						    	rem=rem+"<td>ddn-x25("+data[i+each*2].desc+")</td>";
						    	break;
						    case "5":
						    	rem=rem+"<td>rfc877-x25("+data[i+each*2].desc+")</td>";
						    	break;
						    case "6":
						    	rem=rem+"<td>ethernet-csmacd("+data[i+each*2].desc+")</td>";
						    	break;
						    case "7":
						    	rem=rem+"<td>iso88023-csmacd("+data[i+each*2].desc+")</td>";
						    	break;
						    case "8":
						    	rem=rem+"<td>iso88024-tokenBus("+data[i+each*2].desc+")</td>";
						    	break;
						    case "9":
						    	rem=rem+"<td>iso88025-tokenRing("+data[i+each*2].desc+")</td>";
						    	break;
						    case "10":
						    	rem=rem+"<td>iso88026-man("+data[i+each*2].desc+")</td>";
						    	break;
						    case "11":
						    	rem=rem+"<td>starLan("+data[i+each*2].desc+")</td>";
						    	break;
						    case "12":
						    	rem=rem+"<td>proteon-10Mbit("+data[i+each*2].desc+")</td>";
						    	break;
						    case "13":
						    	rem=rem+"<td>proteon-80Mbit("+data[i+each*2].desc+")</td>";
						    	break;
						    case "14":
						    	rem=rem+"<td>hyperchannel("+data[i+each*2].desc+")</td>";
						    	break;
						    case "15":
						    	rem=rem+"<td>fddi("+data[i+each*2].desc+")</td>";
						    	break;
						    case "16":
						    	rem=rem+"<td>lapb("+data[i+each*2].desc+")</td>";
						    	break;
						    case "17":
						    	rem=rem+"<td>sdlc("+data[i+each*2].desc+")</td>";
						    	break;
						    case "18":
						    	rem=rem+"<td>ds1("+data[i+each*2].desc+")</td>";
						    	break;
						    case "19":
						    	rem=rem+"<td>e1("+data[i+each*2].desc+")</td>";
						    	break;
						    case "20":
						    	rem=rem+"<td>basicISDN("+data[i+each*2].desc+")</td>";
						    	break;
						    case "21":
						    	rem=rem+"<td>primaryISDN("+data[i+each*2].desc+")</td>";
						    	break;
						    case "22":
						    	rem=rem+"<td>propPointToPointSerial("+data[i+each*2].desc+")</td>";
						    	break;
						    case "23":
						    	rem=rem+"<td>ppp("+data[i+each*2].desc+")</td>";
						    	break;
						    case "24":
						    	rem=rem+"<td>softwareLoopback("+data[i+each*2].desc+")</td>";
						    	break;
						    case "25":
						    	rem=rem+"<td>eon("+data[i+each*2].desc+")</td>";
						    	break;
						    case "26":
						    	rem=rem+"<td>ethernet-3Mbit("+data[i+each*2].desc+")</td>";
						    	break;
						    case "27":
						    	rem=rem+"<td>nsip("+data[i+each*2].desc+")</td>";
						    	break;
						    case "28":
						    	rem=rem+"<td>slip("+data[i+each*2].desc+")</td>";
						    	break;
						    case "29":
						    	rem=rem+"<td>ultra("+data[i+each*2].desc+")</td>";
						    	break;
						    case "30":
						    	rem=rem+"<td>ds3("+data[i+each*2].desc+")</td>";
						    	break;
						    case "31":
						    	rem=rem+"<td>sip("+data[i+each*2].desc+")</td>";
						    	break;
						    case "32":
						    	rem=rem+"<td>frame-relay("+data[i+each*2].desc+")</td>";
						    	break;
						    default:
						    	rem=rem+"<td>"+data[i+each*2].desc+"</td>";
					    		break;
						    
						}
						rem=rem+"<td>"+data[i+each*3].desc+"</td>"+
						"<td>"+data[i+each*4].desc+"</td>"+
						"<td>"+data[i+each*5].desc+"</td>"+
						"<td>"+data[i+each*6].desc+"</td>"+
						"<td>"+data[i+each*7].desc+"</td>"+
						"<td>"+data[i+each*8].desc+"</td>"+
						"<td>"+data[i+each*9].desc+"</td>"+
						"<td>"+data[i+each*10].desc+"</td>"+
						"<td>"+data[i+each*11].desc+"</td>"+
						"<td>"+data[i+each*12].desc+"</td>"+
						"<td>"+data[i+each*13].desc+"</td>"+
						"<td>"+data[i+each*14].desc+"</td>"+
						"<td>"+data[i+each*15].desc+"</td>"+
						"<td>"+data[i+each*16].desc+"</td>"+
						"<td>"+data[i+each*17].desc+"</td>"+
						"<td>"+data[i+each*18].desc+"</td>"+
						"<td>"+data[i+each*19].desc+"</td>"+
						"<td>"+data[i+each*20].desc+"</td>"+
						"<td>"+data[i+each*21].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#interfaces').html(rem);
				}
			})
		}
	}
	
	/**
	 * @description TCP表
	 * */
	this.tcpTable=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.6.13.1.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_state']+"</th><th>"+i18n['title_snmp_localAddress']+"</th><th>"+i18n['title_snmp_localPort']+"</th><th>"+i18n['title_snmp_remoteAddress']+"</th><th>"+i18n['title_snmp_remotePort']+"</th></tr>";
					var each=data.length/5;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>";
						
						
						if(data[i].desc=="2"){
							rem=rem+"<td>listen("+data[i].desc+")</td>"
						}else{
							if(data[i].desc=="3")
								rem=rem+"<td>synSent("+data[i].desc+")</td>"
							else{
								if(data[i].desc=="4")
									rem=rem+"<td>synReceived("+data[i].desc+")</td>"
								else{
									if(data[i].desc=="5")
										rem=rem+"<td>established("+data[i].desc+")</td>"
									else{
										if(data[i].desc=="6")
											rem=rem+"<td>finWait1("+data[i].desc+")</td>"
										else{
											if(data[i].desc=="7")
												rem=rem+"<td>finWait2("+data[i].desc+")</td>"
											else{
												if(data[i].desc=="8")
													rem=rem+"<td>closeWait("+data[i].desc+")</td>"
												else{
													if(data[i].desc=="9")
														rem=rem+"<td>closing("+data[i].desc+")</td>"
													else{
														if(data[i].desc=="10")
															rem=rem+"<td>lastAck("+data[i].desc+")</td>"
														else{
															if(data[i].desc=="11")
																rem=rem+"<td>timeWait("+data[i].desc+")</td>"
															else{
																if(data[i].desc=="12")
																	rem=rem+"<td>closed("+data[i].desc+")</td>"
																else{
																	rem=rem+"<td>"+data[i].desc+"</td>"
																}
															}
														}
													}
												}
											}
										}
									}
									
								}
							} 	
						}
							
							
						rem=rem+"<td>"+data[i+each*1].desc+"</td>"+
						"<td>"+data[i+each*2].desc+"</td>"+
						"<td>"+data[i+each*3].desc+"</td>"+
						"<td>"+data[i+each*4].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#tcpTable').html(rem);
				}
			})
		}
	}
	
	
	/**
	 * @description UDP表
	 * */
	this.udpTable=function(){
		if(ip!=undefined){
			$.post('snmp!getMibByStroidsAndOidindex.action','stroids=1.3.6.1.2.1.7.5.1.1&oidindex=8&ifChangeCN=false&ip='+ip,function(data){
				if(data!=null){
					this.rem;
					rem="<table width='100%' class='mibTable'><tr><th>"+i18n['title_snmp_id']+"</th><th>"+i18n['title_snmp_localAddress']+"</th><th>"+i18n['title_snmp_localPort']+"</th></tr>";
					var each=data.length/2;
					for(var i=0;i<each;i++)
					{	
						rem=rem+"<tr>"+
						"<td>"+(i+1)+"</td>"+
						"<td>"+data[i].desc+"</td>"+
						"<td>"+data[i+each*1].desc+"</td></tr>"
					}
					rem=rem+"</table>"
					$('#udpTable').html(rem);
				}
			})
		}
	}
	/**
	 * @description 性能
	 * */
	this.help=function(){
		
	}
	
	this.webEvent=function(){
		/**扫描*/
		$('#scanIp').click(scanIp);
		/**列表刷新*/
		$('#reload_list').click(getLanIp);
		/**添加主机*/
		$('#add_client').click(function(){
			$('#client_hostName,#client_ipAddress').val('');
			$('#client_ipAddress_check').text('');
			$('#add_client_win').window('open');
		});
		/**删除主机*/
		$('#delete_client').click(function(){
			deleteClient();
		});
		/**添加*/
		$('#link_button_client_add').click(function(){
			addClient();
		});
		/**system刷新*/
		$('#reload_system_button').click(getSystem);
		/**hrSWRunTable进程刷新*/
		$('#reload_hrSWRunTable_button').click(hrSWRunTable);
		/**hrSWInstalledTable安装软件刷新*/
		$('#reload_hrSWInstalledTable_button').click(hrSWInstalledTable);
		/**svSvcTable服务刷新*/
		$('#reload_svSvcTable_button').click(svSvcTable);
		
		/**存储刷新*/
		$('#reload_hrStorage_button').click(hrStorage);
		/**设备刷新*/
		$('#reload_hrDervice_button').click(hrDervice);
		
		/**icmp统计刷新*/
		$('#reload_icmp_button').click(icmp);
		/**tcp统计刷新*/
		$('#reload_tcp_button').click(tcp);
		/**udp统计刷新*/
		$('#reload_udp_button').click(udp);
		/**snmp统计刷新*/
		$('#reload_snmp_button').click(snmp);
		/**IP地址刷新*/
		$('#reload_ipAddrTable_button').click(ipAddrTable);
		/**IP路由刷新*/
		$('#reload_ipRouteTable_button').click(ipRouteTable);
		/**IP介质刷新*/
		$('#reload_ipNetToMediaTable_button').click(ipNetToMediaTable);
		/**IP统计刷新*/
		$('#reload_ipStat_button').click(ipStat);
		/**接口刷新*/
		$('#reload_interfaces_button').click(interfaces);
		/**TCP表刷新*/
		$('#reload_tcpTable_button').click(tcpTable);
		/**UDP表刷新*/
		$('#reload_udpTable_button').click(udpTable);
		
		
		/**中文转换*/
		$('#reload_exString_button').click(function(){
			var exString=$('#exString').val();
			$('#exchange')
			
			$('#exStringResult').text(exString);
		});
		$('#reload_snmpTrapTest_button').click(function(){
			$.post('snmp!snmpTrapTest.action',function(){
			});
		});
		
		$('#reload_sendTrap_button').click(function(){
			$.post('snmp!sendPDU1.action',function(){
			});
		});
		
	}
	
	
	/**默认加载项*/
	return {
		init:function(){
			webEvent();
			getLanIp();
			tabsEvent();
			setTimeout(function(){
				hrSWRunTable();
			},1000);
		}
	}
}();

/**载入*/
$(document).ready(networkManage.init);
