$package('itsm.tools');

 /**  
 * @author coney  
 * @constructor affiche
 * @description tools/Affiche.jsp
 * @date 2010-11-17
 * @since version 1.0 
 */


itsm.tools.affiche = function() 
{
	
	
	return {
		
		taskActFormatter:function(){
			
			return $('#afficheActFormatterDiv').html();
		},
		
		/**
		 * @description加载公告列表.
		 */
		
		showAfficheGrid:function() {
			var params = $.extend({},jqGridParams, {	
				url:'affiche!find.action',
				caption:i18n['caption_afficheGrid'],
				colNames:[i18n['number'],i18n['title'],i18n['title_startTime'],i18n['title_endTime'],i18n['title_creator'],i18n['title_createTime'],i18n['common_action'],'','','',],
				colModel:[
			   		{name:'affId',width:60, sorttype:"int",sortable:true},
			   		{name:'affTitle',width:150},
			   		{name:'affStart',sortable:true,align:'center',width:100,formatter:timeFormatter},
			   		{name:'affEnd',sortable:true,align:'center',width:100,formatter:timeFormatter},
			   		{name:'affCreator',sortable:true,align:'center',width:100},
			   		{name:'affCreaTime',sortable:true,align:'center',width:100,formatter:timeFormatter},
			   		{name:'act', width:80,sortable:false,align:'center', formatter: itsm.tools.affiche.taskActFormatter },
			   		{name:'visibleState',hidden:true},
			   		{name:'noticeByEmal',hidden:true},
			   		{name:'affContents',hidden:true}
			   	],		
				jsonReader: $.extend(jqGridJsonReader, {id: "affId"}),
				sortname:'affId',
				pager:'#affichePager'
			});
			$("#afficheGrid").jqGrid(params);
			$("#afficheGrid").navGrid('#affichePager',navGridParams);
			//列表操作项
			$("#t_afficheGrid").css(jqGridTopStyles);
			$("#t_afficheGrid").append($('#afficheGridToolbar').html());
			//自适应大小
			setGridWidth("#afficheGrid","regCenter",10);
		},
		/**
		 * @description 打开添加公告窗口.
		 */
		add_openwindow:function()
		{
			$('#addAffiche').window('open');
		},
		/**
		 * @description 执行添加公告.
		 */
		add_affiche:function(){
			
			if($('#addAfficheForm').form('validate')){
				var _param = $('#addAffiche form').serialize();
				var _url='affiche!save.action';
				$.post(_url,_param,function(){
					$('#addAffiche').window('close');
					$('#afficheGrid').trigger('reloadGrid');		
					resetForm('#addAfficheForm');
					msgShow(i18n['msg_add_successful'],'show');
				})
			}
		},
		


		
		/**
		 * @description 工具栏删除公告.
		 */
		toolbar_delete_aff:function(){
			checkBeforeDeleteGrid('#afficheGrid', itsm.tools.affiche.deleteAffiche);
		},
		
		/**
		 * @description 执行删除公告.
		 */
		deleteAffiche:function(rowIds) {
			var _param = $.param({'affId':rowIds},true);
			$.post("affiche!delete.action", _param, function(){
				$('#afficheGrid').trigger('reloadGrid');
				
				msgShow(i18n['msg_deleteSuccessful'],'show');
				
			}, "json");
		},
		
		/**
		 * @description 打开搜索公告窗口.
		 */
		search_openwindow:function(){
			
			$('#searchVisibleState').click(function(){
	    		if($('#searchVisibleState').attr("checked")){
	    			$('#searchVisibleState').val(1)
	    		}else
	    			$('#searchVisibleState').val(0)
	    	});
	    	
			$('#searchAffiche').window('open');
		},


		/**
		 * @description 提交查询公告.
		 */
		search_do:function(){		
			
			var sdata = $('#searchAffiche form').getForm();
			var postData = $("#afficheGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);  //将postData中的查询参数加上查询表单的参数		
				
			$('#afficheGrid').trigger('reloadGrid',[{"page":"1"}]);
			return false;
		},

		
		/**
		 * @description 打开编辑公告窗口.
		 * @param rowData:行数据
		 */
		edit_openwindow:function(rowData) {
			
			$("#editId").val(rowData.affId);
			$("#editTitle").val(rowData.affTitle);
			$("#edit_editStart").val(rowData.affStart);
			$("#edit_editEnd").val(rowData.affEnd);
			$("#editContents").val(rowData.affContents);
			$("#edit_affCreator").val(rowData.affCreator);
			
			
			
			if(rowData.visibleState==1){
				$('#editVisibleState').attr("checked",'checked')
			}else{
				$('#editVisibleState').removeAttr("checked");
			}
			
			if(rowData.noticeByEmal=='false'){
				$('#editNoticeByEmal1').attr("checked",'false')
			}else{
				$('#editNoticeByEmal').attr("checked",'ture');
			}
			$('#editAffiche').window('open');//Open window
		},

		
		/**
		 * @description 调用方法编辑公告.
		 */
		toolbar_edit_aff : function(){
			checkBeforeEditGrid('#afficheGrid', itsm.tools.affiche.edit_openwindow);
		},
		
		/**
		 * @description  提交编辑公告.
		 */
		edit_affiche:function(){

			if($('#editAfficheForm').form('validate')){
				var params=$("#editAffiche form").serialize();
			    var url = "affiche!update.action";
			    $.post(url, params, function(){
			    	$('#editAffiche').window('close');
			        $("#afficheGrid").trigger("reloadGrid");
			        msgShow(i18n['msg_edit_successful'],'show');
			    });
			}
		}
		,
		init:function(){
			
			itsm.tools.affiche.showAfficheGrid();
			
			$('#link_affiche_add_ok').click(itsm.tools.affiche.add_affiche);
			$('#link_affiche_edit_ok').click(itsm.tools.affiche.edit_affiche);
			$('#link_affiche_search_ok').click(itsm.tools.affiche.search_do);
		}
	
	
	};
	
	
	
}();

$(document).ready(itsm.tools.affiche.init);






