$package('itsm.tools');
/**  
 * @fileOverview 附件主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 附件主函数
 * @description 附件主函数
 * @date 2011-05-19
 * @since version 1.0 
 */
itsm.tools.eventAttachment=function(){
	
	
	
	return {
		/**
		 * @description 获取附件
		 * @param {String} end
		 */
		showEventAttachment:function(eventAttachmentTable,eno,eventType){
			$('#'+eventAttachmentTable).html('');
			var url = 'eventAttachment!findAllEventAttachment.action';
			$.post(url,'eventAttachmentDto.eno='+eno+'&eventAttachmentDto.eventType='+eventType, function(res){
				var arr=res;
				if(arr!=null && arr.length>0){
					for(var i=0;i<arr.length;i++){
						var file=arr[i].url;
						var fileName=file.substring(file.lastIndexOf("/")+1);
						var fileFix=fileName.substring(fileName.indexOf("."));
						var iconUrl=i+1+"、<img src='../images/attachicons/";
						if(fileFix==".rar"){
							iconUrl=iconUrl+"rar.gif'";
						}
						if(fileFix==".zip"){
							iconUrl=iconUrl+"zip.gif'";
						}
						if(fileFix==".gif"||fileFix==".jpg"||fileFix==".bmp"||fileFix==".png"){
							iconUrl=iconUrl+"image.gif'";
						}
						if(fileFix==".doc"||fileFix==".docx"||fileFix==".xls"||fileFix==".ppt"){
							iconUrl=iconUrl+"msoffice.gif'";
						}
						if(fileFix==".pdf"){
							iconUrl=iconUrl+"pdf.gif'";
						}
						if(fileFix==".swf"){
							iconUrl=iconUrl+"flash.gif'";
						}
						else{
							iconUrl=iconUrl+"unknown.gif'";
						}
						iconUrl=iconUrl+" width='14px' height='14px'/>&nbsp;";
					
						$('#'+eventAttachmentTable).append("<div id='eventAttachment_ID_"+arr[i].aid+"'>"+iconUrl+"<a href='attachment!download.action?downloadAttachmentId="+arr[i].aid+"' target='_blank'>"+arr[i].attachmentName+"</a>&nbsp;&nbsp;<a href=javascript:itsm.tools.eventAttachment.deleteEventAttachment('"+arr[i].aid+"')>"+i18n['deletes']+"</a></div>");

					}
				}else{
					$('#'+eventAttachmentTable).append(i18n['noData']);
				}
			});
		},
		//保存附件
		saveEventAttachment:function(eventAttachmentTable,eno,eventType,attachmentStr){
			$.post('eventAttachment!saveEventAttachment.action','eno='+eno+'&eventType='+eventType+'&attachmentStr='+$('#'+attachmentStr).val(),function(){
				$('#'+attachmentStr).val('');
				itsm.tools.eventAttachment.showEventAttachment(eventAttachmentTable,eno,eventType);
			})
		},
		//删除附件
		deleteEventAttachment:function(rowIds){
			$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
				if(r){
					var _param = $.param({'ids':rowIds},true);
					$.post('eventAttachment!deleteEventAttachment.action',_param,function(){
						$('div#eventAttachment_ID_'+rowIds).remove();
						msgShow(i18n['deleteSuccess'],'show');
					})
				}
			});
		},
		init:function(){
		}
	}
}();
$(document).ready(itsm.tools.eventAttachment.init);


