
/**  
 * @fileOverview 进展及成本主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 进展及成本主函数
 * @description 进展及成本主函数
 * @date 2011-05-19
 * @since version 1.0 
 */

function eventCost(eno,eventType){
	
	this.gridId='#'+eventType+'EventCostGrid';
	this.t_gridId='#t_'+eventType+'EventCostGrid';
	this.pagerId='#'+eventType+'EventCostGridPager';
	this.toolBarId='#'+eventType+'EventCostGridToolbar';
	this.actFormatter='#'+eventType+'EventCostActFormatterDiv';
	this.costFormId='#'+eventType+'AddOrEditEventCostForm';
	this.costWinId='#'+eventType+'AddOrEditEventCostDiv';
	this.eno=eno;
	this.eventType='itsm.'+eventType;
	
	
	this.costActFormatter=function(cell,opt,data){
		return $('#'+eventType+'EventCostActFormatterDiv').html();
	};
	//成本
	this.eventCostGrid=function() {
		var params = $.extend({},jqGridParams, {	
			url:'cost!findPagerCost.action?costDTO.eno='+eno+'&costDTO.eventType='+this.eventType,
			caption:i18n['caption_request_activityGrid'],
			colNames:['ID','',i18n['title_technician'],i18n['title_opertionTime'],i18n['title_spendTime'],i18n['title_perHourFees'],i18n['title_technicianCost'],i18n['title_otherCost'],i18n['title_totalCost'],i18n['description'],i18n['title_belongsStage'],'','','',i18n['operateItems']],
			colModel:[
			    {name:'progressId',align:'left',width:30},
			    {name:'userId',hidden:true},
		   		{name:'userName',align:'left',width:60},
		   		{name:'opertionTime',width:80,formatter:timeFormatter},
		   		{name:'useTime',width:60},
		   		{name:'perHourFees',width:100,hidden:true},
		   		{name:'skillFees',align:'left',width:30,hidden:true},
		   		{name:'othersFees',align:'left',width:30,hidden:true},
		   		{name:'totalFees',align:'left', width:30},
		   		{name:'description',align:'left',width:100},
		   		{name:'stage',align:'left',width:100},
		   		{name:'status',align:'left',width:20,hidden:true},
		   		{name:'taskId',align:'left',width:100,hidden:true},
		   		{name:'title',align:'left',width:20,hidden:true},
		   		{name:'act', width:50,align:'center',formatter:this.costActFormatter},
			],
			jsonReader: $.extend(jqGridJsonReader,{id: "progressId"}),
			sortname:'progressId',
			pager:this.pagerId
		});
		$(this.gridId).jqGrid(params);
		$(this.gridId).navGrid(this.pagerId,navGridParams);
		//列表操作项
		$(this.t_gridId).css(jqGridTopStyles);
		$(this.t_gridId).append($(this.toolBarId).html());
	};
	//操作
	this.saveEventCost=function(){
		if($(this.costFormId).form('validate')){
			var _param = $(this.costWinId+' form').serialize();
			var _url='cost!'+opt+'.action';
			$.post(_url,_param,function(){
				$('#'+eventType+'AddOrEditEventCostDiv').window('close');
	 			$('#'+eventType+'EventCostGrid').trigger('reloadGrid');
	 			msgShow(i18n['saveSuccess'],'show');	
			})
		}	
	};

	//新增
	this.addEventCost_win=function()
	{
		
		opt='saveCost';
		resetForm(this.costFormId);
		this.loadRequestWorkDetailsDefaultCurrency();
		$(this.costWinId).window('open');
	};
	
	//编辑
	this.editEventCost_aff=function(){
		this.loadRequestWorkDetailsDefaultCurrency();
		opt="editCost";
		checkBeforeEditGrid(this.gridId,this.editEventCost_win);
	};
	
	this.editEventCost_win=function(rowData) 
	{
		
		$('#'+eventType+'_progressId').val(rowData.progressId);
		$('#'+eventType+'_costUserId').val(rowData.userId);
		$('#'+eventType+'_costUserName').val(rowData.userName);
		$('#'+eventType+'_opertionTime').val(rowData.opertionTime);
		$('#'+eventType+'_useTime').val(rowData.useTime);
		$('#'+eventType+'_perHourFees').val(rowData.perHourFees);
		$('#'+eventType+'_skillFees').val(rowData.skillFees);
		$('#'+eventType+'_othersFees').val(rowData.othersFees);
		$('#'+eventType+'_totalFees').val(rowData.totalFees);
		$('#'+eventType+'_description').val(rowData.description);
		$('#'+eventType+'_stage').val(rowData.stage);
		if(rowData.status=='2'){
			$('#'+eventType+'_costStatus').attr("checked",'true');
		}else
		{
			$('#'+eventType+'_costStatus1').attr("checked",'true');
		}
		$('#'+eventType+'_costTaskId').val(rowData.taskId);
		$('#'+eventType+'_costEventTaskTitle').val(rowData.taskTitle);
		
		$('#'+eventType+'AddOrEditEventCostDiv').window('open');
		
	};
	
	
	this.deleteEventCost_aff=function()
	{
		checkBeforeDeleteGrid(this.gridId,this.deleteEventCost);
	};
	//删除
	this.deleteEventCost=function(rowIds)
	{
		var _param = $.param({'ids':rowIds},true);
		$.post("cost!deleteCost.action", _param, function(){
			$('#'+eventType+'EventCostGrid').trigger('reloadGrid');
			msgShow(i18n['deleteSuccess'],'show');
		}, "json");
	};
	this.loadRequestWorkDetailsDefaultCurrency=function(){
		$.post('currency!findDefaultCurrency.action',function(data){
			if(data!=null && data!=''){
				$('#'+eventType+'_perHourFees_currency').text(data);
				$('#'+eventType+'_skillFees_currency').text(data);
				$('#'+eventType+'_othersFees_currency').text(data);
				$('#'+eventType+'_totalFees_currency').text(data);
			}else{
				$('#'+eventType+'_perHourFees_currency').text('￥');
				$('#'+eventType+'_skillFees_currency').text('￥');
				$('#'+eventType+'_othersFees_currency').text('￥');
				$('#'+eventType+'_totalFees_currency').text('￥');
			}
		});
	};
	
}


/**
 * 计算工程师费用
 */
function calcTechnicianCost(skillFees,useTime,perHourFees,othersFees,totalFees){
	$('#'+skillFees).val($('#'+useTime).val()*$('#'+perHourFees).val());
	setTimeout(function(){calcTechnicianTotalCost(totalFees,skillFees,othersFees)},1000);
}
/**
 * 计算花费总费用
 */
function calcTechnicianTotalCost(totalFees,skillFees,othersFees){
	$('#'+totalFees).val($('#'+skillFees).val()*1+$('#'+othersFees).val()*1);
}