

function eventTask(eno,eventType){
	this.gridId='#'+eventType+'EventTaskGrid';
	this.t_gridId='#t_'+eventType+'EventTaskGrid';
	this.pagerId='#'+eventType+'EventTaskGridPager';
	this.toolBarId='#'+eventType+'EventTaskGridToolbar';
	this.actFormatter='#'+eventType+'EventTaskActFormatterDiv';
	this.eventTaskFormId='#'+eventType+'AddOrEditEventTaskForm';
	this.eventTaskWinId='#'+eventType+'AddOrEditEventTaskDiv';
	this.eno=eno;
	this.eventType='itsm.'+eventType;
	this.opt;
	
	this.requestTaskActFormatter=function(cell,opt,data){
		return $('#'+eventType+'EventTaskActFormatterDiv').html();
	};
	/**
	 * 状态格式化.
	 */
	this.requestTaskStateFormat=function(cellvalue, options){
		if(cellvalue=='0')
			return i18n['title_newCreate'];
		if(cellvalue=='1')
			return i18n['task_label_pending'];
		if(cellvalue=='2')
			return i18n['lable_complete'];
	};
	/**
	 * @description 任务列表
	 */
	this.eventTaskGrid=function(){
		var params = $.extend({},jqGridParams, {	
			url:'eventTask!findPagerChangeTask.action?queryDTO.eno='+this.eno+'&queryDTO.eventType='+this.eventType,
			caption:i18n['caption_request_taskGrid'],
			colNames:['ID',i18n['title'],i18n['lable_task_location'],i18n['status'],'',i18n['title_startTime'],i18n['title_endTime'],i18n['common_owner'],i18n['operateItems'],'',''],
			colModel:[
			    {name:'taskId',align:'left',width:45},
			    {name:'title',align:'left',width:220},
		   		{name:'location',align:'left',width:110},
		   		{name:'taskStatus',width:150,formatter:this.requestTaskStateFormat},
		   		{name:'taskStatus',width:150,hidden:true},
		   		{name:'startTime',align:'left',width:120,formatter:timeFormatter},
		   		{name:'endTime',align:'left',width:120,formatter:timeFormatter},
		   		{name:'owner',align:'center', width:120},
		   		{name:'act', width:80,align:'center',formatter:this.requestTaskActFormatter},
		   		{name:'introduction',hidden:true},
		   		{name:'allDay',hidden:true}
			],	
			toolbar: [true,"top"],
			jsonReader: $.extend(jqGridJsonReader,{id: "taskId"}),
			sortname:'taskId',
			pager:this.pagerId
		});
		$(this.gridId).jqGrid(params);
		$(this.gridId).navGrid(this.pagerId,navGridParams);
		//列表操作项
		$(this.t_gridId).css(jqGridTopStyles);
		$(this.t_gridId).append($(this.toolBarId).html());
	};
	/**
	 * @description 保存任务
	 */
	this.saveEventTask_opt=function()
	{
		if($(this.eventTaskFormId).form('validate')){
			var _param = $(this.eventTaskWinId+' form').serialize();
			var _url='eventTask!'+opt+'.action';
			$.post(_url,_param,function(){
				$('#'+eventType+'AddOrEditEventTaskDiv').window('close');
	 			$('#'+eventType+'EventTaskGrid').trigger('reloadGrid');
	 			msgShow(i18n['saveSuccess'],'show');
			})
		}
	};
	
	/**
	 * @description 新增
	 */
	this.addEventTask_win=function(){	
		opt='saveEventTask';
		resetForm(this.eventTaskFormId);
		$(this.eventTaskWinId).window('open');
	};
	/**
	 * @description 编辑
	 */
	this.editEventTask_aff=function(){
		checkBeforeEditGrid(this.gridId,this.editEventTask_win);
	};
	this.editEventTask_win=function(rowData){
		opt="editEventTask";
		$('#'+eventType+'_taskId').val(rowData.taskId);
		$('#'+eventType+'_taskTitle').val(rowData.title);
		$('#'+eventType+'_taskLocation').val(rowData.location);
		$('#'+eventType+'_taskDescription').val(rowData.introduction);
		if(rowData.taskStatus=='0'){
			$('#'+eventType+'_taskStatus').attr("checked",'true')
		}
		if(rowData.taskStatus=='1'){
			$('#'+eventType+'_taskStatus1').attr("checked",'false');
		}
		if(rowData.taskStatus=='2'){
			$('#'+eventType+'_taskStatus1').attr("checked",'false');
		}
		if(rowData.allDay=='true'){
			$('#'+eventType+'_taskAllDay').attr("checked",'ture');
		}else{
			$('#'+eventType+'_taskAllDay').attr("checked",'');	
		}
		$('#'+eventType+'_taskStartTime').val(rowData.startTime);
		$('#'+eventType+'_taskEndTime').val(rowData.endTime);
		$('#'+eventType+'_taskOwnerName').val(rowData.owner);
		$('#'+eventType+'AddOrEditEventTaskDiv').window('open');
	};
	
	
	this.deleteEventTask_aff=function(){
		checkBeforeDeleteGrid(this.gridId,this.deleteEventTask);
	};
	/**
	 * @description 删除
	 */
	this.deleteEventTask=function(rowIds){
		var _param = $.param({'ids':rowIds},true);
		$.post("eventTask!deleteEventTask.action", _param, function(){
			$('#'+eventType+'EventTaskGrid').trigger('reloadGrid');
			msgShow(i18n['deleteSuccess'],'show');
		}, "json");
	};
	
	
	/**
	 * @description 选择关联任务列表
	 */
	this.relatedEventTaskGrid=function(){
		if($('#'+eventType+'_relatedEventTaskGrid').html()==''){
			var params = $.extend({},jqGridParams, {	
				url:'eventTask!findPagerChangeTask.action?queryDTO.eno='+this.eno+'&queryDTO.eventType='+this.eventType,
				caption:'',
				colNames:['ID',i18n['title'],i18n['status'],'',i18n['title_startTime'],i18n['title_endTime'],i18n['common_owner'],i18n['operateItems']],
				colModel:[
				    {name:'taskId',align:'left',width:45},
			   		{name:'title',align:'left',width:150},
			   		{name:'taskStatus',width:100,formatter:this.relatedEventTaskStateFormat},
			   		{name:'taskStatus',width:100,hidden:true},
			   		{name:'startTime',align:'center',width:100,hidden:true},
			   		{name:'endTime',align:'center',width:100,hidden:true},
			   		{name:'owner',align:'left', width:100},
			   		{name:'act', width:80,align:'center',formatter:this.relatedEventTaskAct}
				],	
				toolbar:false,
				jsonReader: $.extend(jqGridJsonReader,{id: "taskId"}),
				sortname:'taskId',
				pager:'#'+eventType+'_relatedEventTaskGridPager'
			});
			$('#'+eventType+'_relatedEventTaskGrid').jqGrid(params);
			$('#'+eventType+'_relatedEventTaskGrid').navGrid('#'+eventType+'_relatedEventTaskGridPager',navGridParams);
		}else{
			$('#'+eventType+'_relatedEventTaskGrid').trigger('reloadGrid');
		}
		$('#'+eventType+'_relatedEventTaskGrid_win').window('open');
		
//		this.selectEventask();
	};
	this.relatedEventTaskStateFormat=function(cellvalue, options){
		if(cellvalue=='0')
			return i18n['title_newCreate'];
		if(cellvalue=='1')
			return i18n['task_label_pending'];
		if(cellvalue=='2')
			return i18n['lable_complete'];
	};
	
	this.relatedEventTaskAct=function(){
		return '<a href=javascript:select_eventTask_aff("'+eventType+'") title="'+i18n['check']+'"><img src="../images/icons/ok.png" /></a>';
	};
	
//	this.selectEventask=function() {
//		
//		$('.a_select_eventTask').click(function(){
//			alert('');
//			var rowId = $('#'+eventTypeId+'_relatedEventTaskGrid').getGridParam('selrow');
//			if(rowId==null)
//			{
//				$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
//			}
//			else
//			{
//				var rowData=$('#'+eventTypeId+'_relatedEventTaskGrid').getRowData(rowId);
//				$('#'+eventTypeId+'_costTaskId').val(taskId);
//				$('#'+eventTypeId+'_costEventTaskTitle').val(title);
//				$('#'+eventTypeId+'_relatedEventTaskGrid_win').window('close');
//			}
//		});
//	};
	
}
function select_eventTask_aff(eventTypeId){
	var rowId = $('#'+eventTypeId+'_relatedEventTaskGrid').getGridParam('selrow');
	if(rowId==null)
	{
		$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
	}
	else
	{
		var rowData=$('#'+eventTypeId+'_relatedEventTaskGrid').getRowData(rowId);
		confirmSelect(eventTypeId,rowData.taskId,rowData.title);
	}
}

function confirmSelect(eventTypeId,taskId,title){
	$('#'+eventTypeId+'_costTaskId').val(taskId);
	$('#'+eventTypeId+'_costEventTaskTitle').val(title);
	$('#'+eventTypeId+'_relatedEventTaskGrid_win').window('close');
}

