﻿$package('itsm.tools');


 /**  
 * @author Van  
 * @constructor IMMessage
 * @description 即时消息主函数. tools/im.jsp
 * @date 2010-11-17
 * @since version 1.0 
 */
$import("itsm.security.userUtil");

itsm.tools.im = function() 
{
	
	var id = '';
	var param;
	var receive='';
	
	return {
		
		/**
		 * @description 打开新增窗口.
		 */
		add_im_openwindow:function(){
			
			$('#addMessage').window('open');
		},

		/**
		 * @description 打开搜索窗口.
		 */
		search_openwindow:function(){		
			$('#searchImmanage').window('open');
		},
		
		/**
		 * @description 执行搜索操作.
		 */
		search_do:function(){				
			//获得表单对象
			var sdata = $('#searchImmanage form').getForm();		
			var postData = $("#IMjqGrid").jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);  
			var _url = 'immanage!findPager.action';	
			$('#IMjqGrid').trigger('reloadGrid');
			return false;
		},
		
		//检查用户是否存在
		checkUsers:function(userNames,method){
			
			var url='user!vaildateUserByIds.action';
			var _param = $.param({'userNames':userNames},true);
		
			$.post(url,_param, function(res){
				if(res==true || res=="true"){					
					method();
				}else{
					msgAlert(i18n['msg_msg_userNotExist'],'error');
				}
			});
		
		},

		
		/**
		 * 取得接收用户参数
		 */
		getReceiveUsers:function(userNames){
			
			var receivesUsers='';
			
			for(var i=0;i<userNames.length;i++){
				
				if(receivesUsers==''){
					
					receivesUsers='receiveUsers='+userNames[i];
				}else{
					receivesUsers+="&receiveUsers="+userNames[i];
				}	
			}
			return receivesUsers;
		},

		/**
		 * @description 发送临时消息.
		 */
		add_instanceMessage:function(){	

			if($('#addMessageForm').form('validate')){
			
				var userNames=$('#receiveUsers').val().split(";");

				itsm.tools.im.checkUsers(userNames,function(){
					
						var _param = $('#addMessage form').serialize();
						var _url='immanage!save.action';

						var receivesUsers=itsm.tools.im.getReceiveUsers(userNames);
						
						$.post(_url,_param+"&"+receivesUsers,function(){	
							
							$('#addMessage').window('close');
							$('#IMjqGrid').trigger('reloadGrid');
							
							$('#receiveUsers').val('');
							$('#title').val('');
							$('#add_content').val('');
							msgShow(i18n['msg_im_imSendSuccessful'],'show');
						});
				});
			}
		},
		
		/**
		 * @description回复窗口.
		 */

		im_reply_win:function(){
			
			receive='';
			$('#rep_toUser').val('')
			
			var receiveUsers='';
			
			var gr = jQuery("#IMjqGrid").jqGrid('getGridParam','selarrrow');
			if(gr!=null && gr!=''){
				param = $.param({'ids':gr},true);
				if(gr==null & gr==''){
					msgAlert(i18n['msg_atLeastChooseOneData'],'info');
					
				}else{	
					
					gr=gr+''
					var mygr=gr.split(",");
					
					
					for(var i=0;i<mygr.length;i++){
						var rowData=$("#IMjqGrid").getRowData(mygr[i]);	
						
						if(receive==''){
							receive='receiveUsers='+rowData.sendUsers;
						}else
							receive=receive+"&receiveUsers="+rowData.sendUsers;
						
						if(receiveUsers==''){
							receiveUsers=rowData.sendUsers;
						}else
							receiveUsers=receiveUsers+";"+rowData.sendUsers;
						
						$('#rep_title').val(i18n['label_im_reply']+": "+rowData.title);
					}
					
					$('#rep_toUser').val(receiveUsers+";");
					//打开窗口
					$('#editMessage').window('open');
				}
			}else{
				
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			
			}
			
		},
		
		/**
		 * @description 回复即时消息
		 */
		im_reply:function(){
			
			
			if($('#editMessageForm').form('validate')){
			
				
				var replyUser=$('#rep_toUser').val().split(";")
				
				itsm.tools.im.checkUsers(replyUser,function(){
					
					var _param = $('#editMessage form').serialize();
					var _url='immanage!reply.action';	
					
					var receivesUsers=itsm.tools.im.getReceiveUsers(replyUser);
					
					$.post(_url,_param+"&"+param+"&"+receivesUsers,function(){	
						
						$('#editMessage').window('close');
						$('#IMjqGrid').trigger('reloadGrid');

						msgShow(i18n['msg_im_imSendSuccessful'],'show');
					});
				});
				
				
			
			}
			
		},

		/**
		 * @description 查看信息.
		 */
		im_look_win:function(grs){
			var rowData=$("#IMjqGrid").getRowData(grs);	
			
			$('#look_im_sendUser').text(rowData.sendUsers);
			$('#look_im_sendTime').text(rowData.sendTime);
			$('#look_im_title').text(rowData.title);
			$('#look_im_content').text(rowData.content);
			$('#lookMessage_toUser').val(rowData.sendUsers);
			if(rowData.status=='0'){
				
				$.post('immanage!update.action','imDTO.imId='+rowData.imId+'&imDTO.status=1',function(){
					$('#IMjqGrid').trigger('reloadGrid');
				})
			}

			$('#lookMessage_title').val(i18n['label_im_reply']+": "+rowData.title);
			$('#lookMessage').window('open');
		},
		
		/**
		 * @description 回复消息.
		 */
		im_replyMess:function(){
			
			var _params = $('#lookMessage form').serialize();
			var _url='immanage!save.action';
			if($('#lookMessage_toUser').val()==''){
				
				msgAlert(i18n['msg_im_receiveUserCannotBeNull'],'info');
				
			}else{
				var rus='';
				var mygr2=$('#lookMessage_toUser').val().split(";")
				for(var i=0;i<mygr2.length;i++){
					if(rus==''){
						rus='receiveUsers='+mygr2[i];
					}else
						rus=rus+"&receiveUsers="+mygr2[i];
				}
				
				$.post(_url,_params+"&"+rus,function(){	
					$('#lookMessage').window('close');
					$('#IMjqGrid').trigger('reloadGrid');
					
					msgShow(i18n['msg_im_imSendSuccessful'],'show');
					
				})
			}
		},
		
		im_delete:function(){
			
			checkBeforeDeleteGrid("#IMjqGrid",itsm.tools.im.im_delete_method);
		},
		
		/**
		 * @description 删除
		 * */
		im_delete_method:function(s){
			
				var _param = $.param({'ids':s},true);
			 
				var _url = 'immanage!delete.action';
			
				$.post(_url,_param, function(){
					
					$('#IMjqGrid').trigger('reloadGrid');
					
					msgShow(i18n['msg_im_deleteSuccessful'],'show');
					
				},'json');
				
		},
		
		/**
		 * @description 行内删除
		 */
		im_delete_inline:function(id){
			
			$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
				if(r){
					
					itsm.tools.im.im_delete_method(id);
				}
			});
		},

		/**
		 * @description 即时消息内容格式化.
		 */
		contentFormatter:function (cellvalue, options, rowObject){	 		
			
			//正则表达式
			var reg = new RegExp( '<[^>]+>' , 'g' );
			
			//字符串中所有的html标签替换成空
			var tstr = cellvalue.replace(reg, '');	   		
		   
			return '<div class="content" style="width:100%;">'+tstr+'</div>';
		},
		
		contentUnFormatter:function(cellvalue,options){
		   return cellvalue;
		},
		
		statusFormat:function(cellvalue, options){
			if(cellvalue=='0'){
				
				cellvalue=i18n['label_im_notRead'];
			}
				
			if(cellvalue=='1'){
				cellvalue=i18n['label_im_readed'];
			}
				
			if(cellvalue=='2'){
				cellvalue=i18n['label_im_replyed'];
			}
				
			return cellvalue;
		},
		
		/**
		 * @description IM列表操作项格式化.
		 */
		
		IMGridFormatter:function(cell,opt,data){
			var actionHTML='';
			if(immanageReply=='1'){	
				actionHTML=actionHTML+'<a href="javascript:itsm.tools.im.im_reply_win('+data.imId+')" title="'+i18n['label_im_reply']+'"><img src="../images/icons/back.png" /></a>&nbsp;&nbsp;'
			}	
			actionHTML=actionHTML+'<a title="'+i18n['label_im_view']+'" href="javascript:itsm.tools.im.im_look_win('+data.imId+');"><img src="../images/icons/pencil.png"/></a>&nbsp;&nbsp;'
			if(immanageDelete=='1'){		
				actionHTML=actionHTML+'<a title="'+i18n['label_im_delete']+'" onclick="itsm.tools.im.im_delete_inline('+data.imId+')"><img src="../images/icons/delete.gif" /></a>'
			}
			return '<div style="padding:8px">'+actionHTML+'</div>';
		},
		
		/**
		 * @description 加载数据列表.
		 */
		showIMGrid:function(){
			
			var params = $.extend({},jqGridParams, {	
				url:'immanage!findPager.action?manageQueryDTO.receiveUsers='+$('#IM_sendUserName').val(),
				caption:i18n['caption_imGrid'],
				colNames:[i18n['common_title'],i18n['title_sendUser'],i18n['common_content'],i18n['common_state'],i18n['title_sendTime'],i18n['common_action'],'',''],
				colModel:[
						  {name:'title',width:80,align:'left'},
						  {name:'sendUsers',width:80,align:'center'},
						  {name:'content',width:100,align:'left'},
						  {name:'status',width:80,align:'center',formatter:itsm.tools.im.statusFormat},
						  {name:'sendTime',width:80,align:'center',formatter:timeFormatter},
						  {name:'act',width:80,align:'center',sortable:false,formatter:itsm.tools.im.IMGridFormatter},
						  {name:'status',hidden:true},
						  {name:'imId',hidden:true}
						  ],
				toolbar: [true,"top"],	
				jsonReader: $.extend(jqGridJsonReader, {id:"imId"}),
				sortname:'imId',
				pager:'#IMpager'
			});
			$("#IMjqGrid").jqGrid(params);
			$("#IMjqGrid").navGrid('#IMpager',navGridParams);
			//列表操作项
			$("#t_IMjqGrid").css(jqGridTopStyles);
			$("#t_IMjqGrid").append($('#IMgridToolbar').html());
			//自适应宽度
			setGridWidth("#IMjqGrid","regCenter",10);
			
		},
		
		
	  /**
	   * @description 选择用户.
	   */
	  selectImUser:function(userNamesPut){
		  
		  	itsm.security.userUtil.selectUserMulti(userNamesPut,'','loginName');
	  },
	  
	  init: function(){
			//加载数据列表
		    itsm.tools.im.showIMGrid();
			//动态创建事件
			$('#link_im_add_ok').click(itsm.tools.im.add_instanceMessage);
			$('#link_im_reply_ok').click(itsm.tools.im.im_reply);
			$("#link_im_search_ok").click(itsm.tools.im.search_do);	
			
			
			$("#IMjqGrid_add").click(itsm.tools.im.add_im_openwindow);	
			$("#IMjqGrid_reply").click(itsm.tools.im.im_reply_win);	
			$("#IMjqGrid_delete").click(itsm.tools.im.im_delete);	
			$("#IMjqGrid_search").click(itsm.tools.im.search_openwindow);	
			
			
			$("#read_im_reply_send").click(itsm.tools.im.im_replyMess);	
			
			
			$('#write_im_sendUser').click(function(){
				
				itsm.tools.im.selectImUser('#receiveUsers');
			});
			
			$('#write_im_reply').click(function(){
				
				itsm.tools.im.selectImUser('#rep_toUser');
			});
			
			$('#write_im_reply2').click(function(){
				
				itsm.tools.im.selectImUser('#lookMessage_toUser');
			});
			
			
			
			
			
		}
		
	};
	
	

  
}();
	
//载入
$(document).ready(itsm.tools.im.init);

