﻿$package('itsm.tools');


 /**  
 * @author Van  
 * @constructor sms
 * @description 发送短信主函数.
 * @date 2011-02-25
 * @since version 1.0 
 */  
itsm.tools.sms = function() {
	
	

	return {
		
		/**
		 * @description 查询余额.
		 */
		queryMoney:function(){
			
			var url = 'sms!queryMoney.action';
			$.post(url,function(res)
			{
				$('#accountMsg').html(i18n['label_sms_accountName']+':'+res.id+";<br/>"+i18n['label_sms_accountMoney']+':'+res.totalMoney+i18n['common_yuan']);
			});
		},
		
		
		
		/**
		 * @description 验证手机号码
		 */
		checkMobile:function(){
			
			var phones=$('#mobarea').val();
			
			var arrstr=phones.replace(/\n/g,'---'); 
			var arr=arrstr.split("---");
			
			var ck = /^1[3,5,8]\d{9}$/;

	    	for(var i=0;i<arr.length;i++){
	    		if(!ck.test(arr[i])){
	    			msgAlert(i18n["msg_msg_hasWrongPhoneNumber"]+"["+arr[i]+"]","error");
	    			return false;
	    		}
	    	}

	    	return true;
		},
		

		/**
		 * @description 发送短信.
		 */
		sendSms:function (){
			

			if($('#smsForm').form('validate') && $('#phoneNumberForm').form('validate')&&itsm.tools.sms.checkMobile()){
			
				//赋值
				$('#mobiles').val($('#mobarea').val());
				
		
				var url = 'sms!sendSMS.action';
				var frm = $('#sendMsgDiv form').serialize();
				
				$.post(url,frm, function(res){
				
					var msg="";
					
					if(res.stateMsg=="信息发送成功！"){
						msg=i18n["msg_im_imSendSuccessful"];
					}
						
					
					$.messager.show({
						title:i18n['msg_msg'],
						msg:'<br/>'+msg+"<br/>"+i18n['msg_sms_sended']+res.sendCount+i18n['common_tiao']+"<br/>"+i18n['msg_sms_takeMoney']+res.costMoney+i18n['common_tiao']+"<br/>"+i18n['label_sms_accountMoney']+res.totalMoney+i18n['common_yuan']+"<br/>",
						showType:'show',
						timeout:10000,
						height:150
					});
					
					
					//清空
					resetForm("#smsForm");
					resetForm("#phoneNumberForm");
					
					//重新计算
					itsm.tools.sms.queryMoney();
					
				});
			
			}
		},

		/**
		 * 载入
		 */
		init: function() {
			
			$("#sms_loading").hide();
			$("#sendMsgDiv").show();
			
			itsm.tools.sms.queryMoney();
			//动态创建事件
			$('#sendMsgBtn').click(itsm.tools.sms.sendSms);
		}
		
	};
}();


//载入
$(document).ready(itsm.tools.sms.init);

