/**  
 * @author Van  
 * @constructor smsAccount
 * @description 短信账户设置主函数（公司信息）.
 * @date 2011-02-25
 * @since version 1.0 
 */
$package('itsm.tools');

itsm.tools.smsAccount = function() 
{
	
	return {
				
		/**
		 * @description 查询短信账户信息.
		 */
		findSMSAccount:function(){
			
			var url="sms!findSMSAccount.action";
			
			$.post(url,function(res){
				
					$('#smsAccountDTO_said').val(res.said);
					$('#smsAccountDTO_uid').val(res.uid);
					$('#smsAccountDTO_pwd').val(res.pwd);
					
					/*
					$('#smsAccountDTO_sendUrl').val(res.sendUrl);
					$('#smsAccountDTO_queryUrl').val(res.queryUrl);
					$('#smsAccountDTO_smsLength').val(res.smsLength);
					$('#smsAccountDTO_moblieCount').val(res.moblieCount);
					*/
			});
		},
		
		
		/**
		 * @description 测试短信账户.
		 */
		testSMSAccount:function(){
			
			
			if($('#SMSAccountForm').form('validate')){
				
				var url="sms!testSMSAccount.action";
				var frm = $('#SMSAccountDiv form').serialize();
				
				$.post(url,frm, function(res){
					
					if(res.totalMoney<0){
								
						msgAlert(i18n['msg_sms_failure'],'error');
					
						
					}else{
						
						msgShow(i18n['msg_sms_success'],'show');
						
					}
					
				});
			}
		},
		
		

		/**
		 * @description 保存短信账户信息.
		 */
		saveSMSAccount:function(){
			
			if($('#SMSAccountForm').form('validate')){

				var ckurl="sms!testSMSAccount.action";
				var frm = $('#SMSAccountDiv form').serialize();
				
				$.post(ckurl,frm, function(res){
					
					if(res.totalMoney>=0){
						
						var sburl="sms!saveOrUpdateSMSAccount.action";
						$.post(sburl,frm, function(){
												
							msgShow(i18n['msg_sms_accountConfigSuccessful'],'show');
							
						});
						
						
					}else{
						
						msgAlert(i18n['msg_sms_failure'],'error');
						return false;
					}
					
				});

			}
		},
		
		
		/**
		 * 加载
		 */
		init: function(){

			itsm.tools.smsAccount.findSMSAccount();
			//动态创建事件
			
			
			$('#saveSMSAccountBtn').click(itsm.tools.smsAccount.saveSMSAccount);
			$('#testSMSAccountBtn').click(itsm.tools.smsAccount.testSMSAccount);

		}
		
		
	};

}();


//载入
$(document).ready(itsm.tools.smsAccount.init);

