 /**  
 * @author Tan  
 * @constructor task
 * @description "task"
 * @date 2010-11-17
 * @since version 1.0 
 */  

$package('itsm.tools');


itsm.tools.task = function() 
{
	
	this.opt;
	
	
	return{
		
		/**
		 * 可操作项格式化.
		 */
		taskActFormatter:function(){
			
			return $('#taslActFormatterDiv').html();
		},
		
		/**
		 * @description 状态格式化.
		 */
		taskStateFormat:function(cellvalue){
			if(cellvalue=='0')
				return i18n['title_newCreate']
			if(cellvalue=='1')	
				return i18n['task_label_pending']
			if(cellvalue=='2')
				return i18n['lable_complete']
			
		},
		
		
		/**
		 * @description 任务列表.
		 */
		showTaskGrid:function() {
			var params = $.extend({},jqGridParams, {	
				url:'tasks!findPagerTask.action?taskQueryDto.owner='+$('#task_owner').val(),
				caption:i18n['title_personTask'],
				colNames:['ID',i18n['title'],i18n['lable_task_location'],i18n['status'],'',i18n['title_startTime'],i18n['title_endTime'],i18n['label_request_assigner'],i18n['operateItems'],'',''],
				colModel:[
				    {name:'taskId',align:'center',width:45},
			   		{name:'title',align:'left',width:220},
			   		{name:'location',align:'center',width:220},
			   		{name:'taskStatus',width:150,formatter:itsm.tools.task.taskStateFormat},
			   		{name:'taskStatus',width:150,hidden:true},
			   		{name:'startTime',align:'center',width:120,formatter:timeFormatter},
			   		{name:'endTime',align:'center',width:120,formatter:timeFormatter},
			   		{name:'owner',align:'center', width:120},
			   		{name:'act', width:80,align:'center',sortable:false,formatter:itsm.tools.task.taskActFormatter},
			   		{name:'allDay',hidden:true},
			   		{name:'introduction',hidden:true}
				],	
				toolbar: [true,"top"],
				jsonReader: $.extend(jqGridJsonReader,{id: "taskId"}),
				sortname:'taskId',
				pager:'#taskPager'
			});
			$("#taskGrid").jqGrid(params);
			$("#taskGrid").navGrid('#taskPager',navGridParams);
			//列表操作项
			$("#t_taskGrid").css(jqGridTopStyles);
			$("#t_taskGrid").append($('#taskGridToolbar').html());
			//自适应宽度
			setGridWidth("#taskGrid","regCenter",9);
		},
		
		

		/**
		 * @description 配置项.
		 */
		addEditTask_win:function(){	
			resetForm('#myTaskForm');
			opt='saveTask';
			$('#addOrEditTaskDiv').window('open');
		},
		
		/**
		 * @description 保存或编辑.
		 */
		addEditTask_opt:function(){
			
			
			 if($('#myTaskForm').form('validate')){
			
				var _param = $('#addOrEditTaskDiv form').serialize();
				var _url='tasks!'+opt+'.action';
				$.post(_url,_param,function(){
					$('#addOrEditTaskDiv').window('close');
				
		 			$('#taskGrid').trigger('reloadGrid');
		 		
		 			resetForm('#myTaskForm');
		 			msgShow(i18n['saveSuccess'],'show');

				});
			 }
		},
		
		/**
		 * @description 删除任务.
		 */
		deleteTask_aff:function(){
			checkBeforeDeleteGrid('#taskGrid', itsm.tools.task.task_deleteTask);
		},
		
		/**
		 * @description 执行删除.
		 */
		task_deleteTask:function(rowIds){
			
			var _param = $.param({'taskIds':rowIds},true);
			$.post("tasks!deleteTask.action", _param, function(){
				$('#taskGrid').trigger('reloadGrid');
				
				msgShow(i18n['deleteSuccess'],'show');
				
				
			}, "json");
		},
		
		/**
		 * @description 打开编辑窗口.
		 */
		editTask_win:function(rowData){
			
			resetForm('#myTaskForm');			
			if(rowData.taskStatus=='0'){
				$('#taskStatus').attr("checked",'true')
			}else if(rowData.taskStatus=='1')
			{
				$('#taskStatus1').attr("checked",'true');
			}else{
				$('#taskStatus2').attr("checked",'true');
			}
			if(rowData.allDay=='true'){
				$('#taskAllDay').attr("checked",'true');
			}
			$("#task_taskId").val(rowData.taskId);
			$("#taskTitle").val(rowData.title);
			$("#taskLocation").val(rowData.location);
			$("#taskIntroduction").val(rowData.introduction);
			$("#taskStartTime").val(rowData.startTime);
			$("#taskEndTime").val(rowData.endTime);
			$("#taskOwner").val(rowData.owner);
			$('#addOrEditTaskDiv').window('open');
		},

		
		/**
		 * @description edit(Get the value of which reached the grid edit page)
		 */
		editTask_aff:function(){
			
			var rowId = jQuery("#taskGrid").jqGrid('getGridParam','selrow');
			if(rowId==null)
			{
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else
			{
				opt="editTask";
				var rowData=$("#taskGrid").getRowData(rowId);
				itsm.tools.task.editTask_win(rowData);
			}
		},

		
		init: function(){
			
			itsm.tools.task.showTaskGrid();
			$('#link_task_save_edit_ok').click(itsm.tools.task.addEditTask_opt);
		}
		
	};
	
	
	
}();

$(document).ready(itsm.tools.task.init);